/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter;

import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.parameter.DependencyParameter;

public class BindingObjectParameter
extends DependencyParameter {
    private static final long serialVersionUID = 1L;
    private final int hashCode;
    private final BindingObject bo;

    public BindingObjectParameter(Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, BindingObject bo, int hashCode) {
        super(DataType.BINDING_OBJECT_T, direction, stream, prefix, name, contentType, weight, false);
        this.bo = bo;
        this.hashCode = hashCode;
    }

    public String getId() {
        return this.bo.toString();
    }

    public int getCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return "BindingObjectParameter with Id " + this.bo.getId() + ", type " + this.bo.getType() + ", elements " + this.bo.getElements() + " and HashCode " + this.hashCode;
    }

    @Override
    public String getOriginalName() {
        return this.bo.getId();
    }

    @Override
    public String getDataTarget() {
        String dataTarget = super.getDataTarget();
        if (dataTarget != null) {
            if (dataTarget.contains("#")) {
                return dataTarget;
            }
            return dataTarget + "#" + this.bo.getType() + "#" + this.bo.getElements();
        }
        return "null#" + this.bo.getType() + "#" + this.bo.getElements();
    }

    public BindingObject getBindingObject() {
        return this.bo;
    }

    @Override
    public String generateDataTargetName(String tgtName) {
        if (!tgtName.contains("#")) {
            tgtName = tgtName + "#" + this.bo.getType() + "#" + this.bo.getElements();
        }
        return tgtName;
    }
}

