/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.COMPSsConstants;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class RuntimeConfigManager {
    private final PropertiesConfiguration config;

    public RuntimeConfigManager(String pathToConfigFile) throws ConfigurationException {
        this.config = new PropertiesConfiguration(pathToConfigFile);
    }

    public RuntimeConfigManager(URL pathToConfigFile) throws ConfigurationException {
        this.config = new PropertiesConfiguration(pathToConfigFile);
    }

    public RuntimeConfigManager(InputStream stream) throws ConfigurationException {
        this.config = new PropertiesConfiguration();
        this.config.load(stream);
    }

    public RuntimeConfigManager(File file) throws ConfigurationException {
        this.config = new PropertiesConfiguration(file);
    }

    public String getDeploymentId() {
        return this.config.getString("compss.uuid", COMPSsConstants.DEFAULT_DEPLOYMENT_ID);
    }

    public void setDeploymentId(String uuid) {
        this.config.setProperty("compss.uuid", uuid);
    }

    public String getMasterName() {
        return this.config.getString("compss.masterName");
    }

    public void setMasterName(String name) {
        this.config.setProperty("compss.masterName", name);
    }

    public String getMasterPort() {
        return this.config.getString("compss.masterPort");
    }

    public void setMasterPort(String port) {
        this.config.setProperty("compss.masterPort", port);
    }

    public String getAppName() {
        return this.config.getString("compss.appName");
    }

    public void setAppName(String name) {
        this.config.setProperty("compss.appName", name);
    }

    public String getTaskSummary() {
        return this.config.getString("compss.summary");
    }

    public void setTaskSummary(String value) {
        this.config.setProperty("compss.summary", value);
    }

    public String getCOMPSsBaseLogDir() {
        return this.config.getString("compss.baseLogDir");
    }

    public String getSpecificLogDir() {
        return this.config.getString("compss.specificLogDir");
    }

    public String getProjectFile() {
        return this.config.getString("compss.project.file");
    }

    public void setProjectFile(String location) {
        this.config.setProperty("compss.project.file", location);
    }

    public String getProjectSchema() {
        return this.config.getString("compss.project.schema");
    }

    public void setProjectSchema(String location) {
        this.config.setProperty("compss.project.schema", location);
    }

    public String getResourcesFile() {
        return this.config.getString("compss.resources.file");
    }

    public void setResourcesFile(String location) {
        this.config.setProperty("compss.resources.file", location);
    }

    public String getResourcesSchema() {
        return this.config.getString("compss.resources.schema");
    }

    public void setResourcesSchema(String location) {
        this.config.setProperty("compss.resources.schema", location);
    }

    public String getScheduler() {
        return this.config.getString("compss.scheduler");
    }

    public void setScheduler(String implementingClass) {
        this.config.setProperty("compss.scheduler", implementingClass);
    }

    public String getLog4jConfiguration() {
        return this.config.getString("log4j.configurationFile");
    }

    public void setLog4jConfiguration(String location) {
        this.config.setProperty("log4j.configurationFile", location);
    }

    public String getCommAdaptor() {
        return this.config.getString("compss.comm");
    }

    public void setCommAdaptor(String adaptor) {
        this.config.setProperty("compss.comm", adaptor);
    }

    public String getConn() {
        return this.config.getString("compss.conn");
    }

    public void setConn(String connector) {
        this.config.setProperty("compss.conn", connector);
    }

    public String getContext() {
        return this.config.getString("compss.context");
    }

    public void setContext(String context) {
        this.config.setProperty("compss.context", context);
    }

    public String getGATAdaptor() {
        return this.config.getString("gat.adaptor.path", COMPSsConstants.DEFAULT_GAT_ADAPTOR_LOCATION);
    }

    public void setGATAdaptor(String adaptorPath) {
        this.config.setProperty("gat.adaptor.path", adaptorPath);
    }

    public boolean isGATDebug() {
        return this.config.getBoolean("gat.debug", false);
    }

    public void setGATDebug(boolean debug) {
        this.config.setProperty("gat.debug", debug);
    }

    public String getGATBrokerAdaptor() {
        return this.config.getString("gat.broker.adaptor");
    }

    public void setGATBrokerAdaptor(String adaptor) {
        this.config.setProperty("gat.broker.adaptor", adaptor);
    }

    public String getGATFileAdaptor() {
        return this.config.getString("gat.file.adaptor");
    }

    public void setGATFileAdaptor(String adaptor) {
        this.config.setProperty("gat.file.adaptor", adaptor);
    }

    public boolean getReuseResourcesOnBlock() {
        return this.config.getBoolean("compss.execution.reuseOnBlock");
    }

    public void setReuseResourcesOnBlock(boolean reuse) {
        this.config.setProperty("compss.execution.reuseOnBlock", reuse);
    }

    public void setWorkerCPUAffinity(boolean isAffinityEnabled) {
        this.config.setProperty("compss.worker.cpu_affinity", isAffinityEnabled);
    }

    public boolean isWorkerCPUAffinityEnabled() {
        return this.config.getBoolean("compss.worker.cpu_affinity", false);
    }

    public void setWorkerGPUAffinity(boolean isAffinityEnabled) {
        this.config.setProperty("compss.worker.gpu_affinity", isAffinityEnabled);
    }

    public boolean isWorkerGPUAffinityEnabled() {
        return this.config.getBoolean("compss.worker.gpu_affinity", false);
    }

    public boolean isGraph() {
        return this.config.getBoolean("compss.graph", false);
    }

    public void setGraph(boolean graph) {
        this.config.setProperty("compss.graph", graph);
    }

    public int getTracing() {
        return this.config.getInt("compss.tracing", 0);
    }

    public void setTracing(int tracing) {
        this.config.setProperty("compss.tracing", tracing);
    }

    public String getCustomExtraeFile() {
        return this.config.getString("compss.extrae.file", "null");
    }

    public void setCustomExtraeFile(String extraeFilePath) {
        this.config.setProperty("compss.extrae.file", extraeFilePath);
    }

    public String getCustomExtraeFilePython() {
        return this.config.getString("compss.extrae.file.python", "null");
    }

    public void setCustomExtraeFilePython(String extraeFilePathPython) {
        this.config.setProperty("compss.extrae.file.python", extraeFilePathPython);
    }

    public long getMonitorInterval() {
        return this.config.getLong("compss.monitor", 0L);
    }

    public void setMonitorInterval(long seconds) {
        this.config.setProperty("compss.monitor", seconds);
    }

    public String getLang() {
        return this.config.getString("compss.lang", COMPSsConstants.Lang.JAVA.name());
    }

    public void setLang(String lang) {
        this.config.setProperty("compss.lang", lang);
    }

    public String getWorkerCP() {
        return this.config.getString("compss.worker.cp");
    }

    public void setWorkerCP(String classpath) {
        this.config.setProperty("compss.worker.cp", classpath);
    }

    public String getServiceName() {
        return this.config.getString("compss.serviceName");
    }

    public void setServiceName(String serviceName) {
        this.config.setProperty("compss.serviceName", serviceName);
    }

    public String getWorkerJVMOpts() {
        return this.config.getString("compss.worker.jvm_opts");
    }

    public void setWorkerJVMOpts(String jvmOpts) {
        this.config.setProperty("compss.worker.jvm_opts", jvmOpts);
    }

    public void save() throws ConfigurationException {
        this.config.save();
    }

    public boolean isToFile() {
        return this.config.getBoolean("compss.to.file", false);
    }

    public String getProperty(String propertyName) {
        Object prop = this.config.getProperty(propertyName);
        if (prop != null) {
            return prop.toString();
        }
        return null;
    }
}

