/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.accesses;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import java.util.ArrayList;
import java.util.List;

public class StreamDataAccessesInfo
extends DataAccessesInfo {
    private final List<AbstractTask> streamWriters = new ArrayList<AbstractTask>();

    public StreamDataAccessesInfo(DataType dataType) {
        super(dataType);
    }

    @Override
    public AbstractTask getConstrainingProducer() {
        if (!this.streamWriters.isEmpty()) {
            return this.streamWriters.get(0);
        }
        return null;
    }

    @Override
    public void completedProducer(AbstractTask task) {
        this.streamWriters.remove(task);
    }

    @Override
    public void readValue(Task task, DependencyParameter dp, boolean isConcurrent, GraphHandler gh) {
        int dataId = dp.getDataAccessId().getDataId();
        if (!this.streamWriters.isEmpty()) {
            if (DEBUG) {
                StringBuilder sb = new StringBuilder();
                if (this.streamWriters.size() > 1) {
                    sb.append("Last writers for stream datum ");
                    sb.append(dataId);
                    sb.append(" are tasks ");
                } else {
                    sb.append("Last writer for stream datum ");
                    sb.append(dataId);
                    sb.append(" is task ");
                }
                for (AbstractTask lastWriter : this.streamWriters) {
                    sb.append(lastWriter.getId());
                    sb.append(" ");
                }
                LOGGER.debug(sb.toString());
            }
            for (AbstractTask lastWriter : this.streamWriters) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream dependency between task " + lastWriter.getId() + " and task " + task.getId());
                }
                task.addStreamDataDependency(lastWriter);
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last stream writer for datum " + dataId);
        }
        if (IS_DRAW_GRAPH) {
            gh.drawStreamEdge(task, dp, false);
            gh.checkIfPreviousGroupInGraph(dataId);
        }
    }

    @Override
    public void writeValue(AbstractTask t, DependencyParameter dp, boolean isConcurrent, GraphHandler gh) {
        this.streamWriters.add(t);
        if (IS_DRAW_GRAPH) {
            gh.drawStreamEdge(t, dp, true);
        }
    }

    @Override
    public void mainAccess(RegisterDataAccessRequest rdar, GraphHandler gh, int dataId, int dataVersion) {
        if (IS_DRAW_GRAPH) {
            for (AbstractTask lastWriter : this.streamWriters) {
                gh.addEdgeFromTaskToMain(lastWriter, EdgeType.STREAM_DEPENDENCY, dataId, dataVersion);
            }
        }
    }

    @Override
    public boolean isFinalProducer(Task t) {
        return this.streamWriters.isEmpty();
    }

    @Override
    public String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("streamWriters = [");
        for (AbstractTask t : this.streamWriters) {
            sb.append(t.getId()).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<AbstractTask> getDataWriters() {
        return this.streamWriters;
    }
}

