/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.ReduceTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReduceExecutionAction
extends ExecutionAction {
    private TaskScheduler ts;
    private int reduceIndex = 0;
    private CollectionParameter initialCollection;
    private Map<Resource, List<Parameter>> parametersInResource;
    private List<AllocatableAction> alreadyDoneActions;
    private Map<AllocatableAction, Parameter> partialParameters;
    private boolean finalTaskExecuted;
    private List<Resource> finalInResource;
    private int receivedOriginalParameters = 0;
    private List<Resource> usedResources;
    private Map<Resource, List<AllocatableAction>> executingInResource;

    public ReduceExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, AccessProcessor ap, ReduceTask task, TaskScheduler ts) {
        super(schedulingInformation, orchestrator, ap, task);
        if (this.parametersInResource == null) {
            this.parametersInResource = new HashMap<Resource, List<Parameter>>();
        }
        this.ts = ts;
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        this.initialCollection = (CollectionParameter)finalParameters.get(0);
        this.partialParameters = new HashMap<AllocatableAction, Parameter>();
        this.finalTaskExecuted = false;
        this.usedResources = new ArrayList<Resource>();
        LOGGER.debug("Creating new Reduce execution action");
        this.executingInResource = new HashMap<Resource, List<AllocatableAction>>();
        this.finalInResource = new ArrayList<Resource>();
        if (this.alreadyDoneActions != null) {
            this.alreadyDonePredecessors();
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Parameter p : task.getFreeParams()) {
            if (p instanceof CollectionParameter || p instanceof FileParameter && ((FileParameter)p).getOriginalName().startsWith("reduce")) continue;
            params.add(p);
        }
        this.addNonDependentParam(params);
    }

    private void addNonDependentParam(List<Parameter> params) {
        for (Parameter p : params) {
            Resource r = null;
            if (p instanceof DependencyParameter) {
                r = this.getParameterLocation((DependencyParameter)p);
                if (r == null) {
                    r = this.assignResourceToFreeParam();
                }
            } else {
                r = this.assignResourceToFreeParam();
            }
            if (r == null) continue;
            this.parametersInResource.get(r).add(p);
            if (!this.usedResources.contains(r)) {
                this.usedResources.add(r);
            }
            ++this.receivedOriginalParameters;
            this.addReduceTaskParameters(r);
        }
    }

    private Resource assignResourceToFreeParam() {
        Resource r = null;
        HashSet<Resource> hosts = new HashSet<Resource>();
        for (ResourceScheduler<? extends WorkerResourceDescription> rs : this.ts.getWorkers()) {
            hosts.add(rs.getResource());
        }
        r = this.getBestHost(r, hosts);
        return r;
    }

    private Resource getParameterLocation(DependencyParameter dp) {
        LogicalData dataLD;
        DataInstanceId dId = null;
        switch (dp.getDirection()) {
            case IN_DELETE: 
            case IN: 
            case CONCURRENT: {
                RAccessId raId = (RAccessId)dp.getDataAccessId();
                dId = raId.getReadDataInstance();
                break;
            }
            case COMMUTATIVE: 
            case INOUT: {
                RWAccessId rwaId = (RWAccessId)dp.getDataAccessId();
                dId = rwaId.getReadDataInstance();
                break;
            }
        }
        Resource maxResource = null;
        if (dId != null && (dataLD = Comm.getData(dId.getRenaming())) != null) {
            Set<Resource> hosts = dataLD.getAllHosts();
            maxResource = this.getBestHost(maxResource, hosts);
        }
        return maxResource;
    }

    private Resource getBestHost(Resource maxResource, Set<Resource> hosts) {
        if (!hosts.isEmpty()) {
            maxResource = hosts.iterator().next();
            for (Resource host : hosts) {
                this.checkAndRegisterResource(host);
                if (this.parametersInResource.get(maxResource).size() >= this.parametersInResource.get(host).size()) continue;
                maxResource = host;
            }
        }
        if (DEBUG) {
            LOGGER.debug("Chosen host to run the reduce: " + (maxResource != null ? maxResource.toString() : "null"));
        }
        return maxResource;
    }

    @Override
    public void addAlreadyDoneAction(AllocatableAction finishedAction) {
        LOGGER.debug("Registering parameter of an already done action");
        if (this.alreadyDoneActions == null) {
            this.alreadyDoneActions = new ArrayList<AllocatableAction>();
        }
        this.alreadyDoneActions.add(finishedAction);
    }

    private void alreadyDonePredecessors() {
        for (AllocatableAction a : this.alreadyDoneActions) {
            this.registerPredecessorDone(a);
        }
    }

    @Override
    protected void dataPredecessorDone(AllocatableAction finishedAction) {
        this.registerPredecessorDone(finishedAction);
        super.dataPredecessorDone(finishedAction);
    }

    public void registerPredecessorDone(AllocatableAction finishedAction) {
        Parameter param;
        Worker<? extends WorkerResourceDescription> resource = finishedAction.getAssignedResource().getResource();
        this.checkAndRegisterResource(resource);
        Task finishedTask = ((ExecutionAction)finishedAction).getTask();
        boolean partial = false;
        if (!finishedTask.getTaskDescription().getName().equals(this.task.getTaskDescription().getName())) {
            param = this.getTask().getDependencyParameters(finishedTask);
            ++this.receivedOriginalParameters;
        } else {
            partial = true;
            param = this.partialParameters.get(finishedAction);
            List<AllocatableAction> actions = this.executingInResource.get(resource);
            actions.remove(finishedAction);
        }
        this.parametersInResource.get(resource).add(param);
        if (!this.usedResources.contains(resource)) {
            this.usedResources.add(resource);
        }
        if (partial) {
            this.partialParameters.remove(finishedAction);
        }
        this.addReduceTaskParameters(resource);
        ((ExecutionAction)finishedAction).getTask().releaseDataDependents();
    }

    private void checkAndRegisterResource(Resource resource) {
        if (!this.parametersInResource.containsKey(resource)) {
            ArrayList parameters = new ArrayList();
            this.parametersInResource.put(resource, parameters);
        }
    }

    private void addReduceTaskParameters(Resource resource) {
        List<Parameter> params = this.parametersInResource.get(resource);
        if (!this.finalTaskExecuted) {
            if (params.size() >= this.getChunkSize()) {
                this.launchReduceAction(resource, params);
                ++this.reduceIndex;
                this.parametersInResource.put(resource, new ArrayList());
            }
            if (this.noMoreOriginalReductionParamsPending()) {
                List<AllocatableAction> actions = this.executingInResource.get(resource);
                if (actions == null || actions.isEmpty()) {
                    this.finalTaskInResource(resource);
                }
                if (this.mustLaunchFinalTasks()) {
                    this.launchFinalTasks();
                }
            }
        }
    }

    private void launchFinalTasks() {
        ArrayList<Parameter> finalParams = new ArrayList<Parameter>();
        this.finalTaskExecuted = true;
        for (Resource resource : this.parametersInResource.keySet()) {
            if (this.finalInResource.contains(resource)) continue;
            this.finalTaskInResource(resource);
        }
        for (Map.Entry entry : this.parametersInResource.entrySet()) {
            finalParams.addAll((Collection)entry.getValue());
        }
        this.setFinalExecutionParameters(finalParams);
        this.finalTaskExecuted = true;
    }

    private int getChunkSize() {
        return ((ReduceTask)this.task).getChunkSize();
    }

    private boolean mustLaunchFinalTasks() {
        return this.partialParameters.size() == 0 && this.usedResources.size() > 1 || this.usedResources.size() == 1 && this.partialParameters.size() + this.parametersInResource.get(this.usedResources.get(0)).size() == this.getChunkSize();
    }

    private boolean noMoreOriginalReductionParamsPending() {
        return this.initialCollection != null && this.receivedOriginalParameters == this.initialCollection.getParameters().size();
    }

    private void finalTaskInResource(Resource resource) {
        List<Parameter> params = this.parametersInResource.get(resource);
        if (params.size() > 1) {
            this.launchReduceAction(resource, params);
            ++this.reduceIndex;
            this.parametersInResource.put(resource, new ArrayList());
            this.finalInResource.add(resource);
        }
    }

    private void setFinalExecutionParameters(List<Parameter> params) {
        LOGGER.debug("Adding final reduce task for task " + this.task.toString());
        ReduceTask t = (ReduceTask)this.task;
        ArrayList<Parameter> partialsIn = new ArrayList<Parameter>(this.partialParameters.values());
        for (Parameter p : params) {
            partialsIn.add(p);
        }
        CollectionParameter cPartial = t.getFinalCollection();
        cPartial.setParameters(partialsIn);
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(0, cPartial);
    }

    private void launchReduceAction(Resource resource, List<Parameter> params) {
        LOGGER.debug("Adding intermediate reduce task for task " + this.task.getId());
        ReduceTask t = (ReduceTask)this.task;
        CollectionParameter cp = t.getIntermediateCollections().get(this.reduceIndex);
        cp.setParameters(params);
        ArrayList<Parameter> taskP = new ArrayList<Parameter>();
        taskP.add(cp);
        Parameter result = t.getIntermediateOutParameters().get(0);
        t.setPartialOutUsed(result);
        Parameter partialIn = t.getIntermediateInParameters().get(0);
        t.setPartialInUsed(partialIn);
        taskP.add(result);
        TaskDescription td = this.task.getTaskDescription();
        Task partialTask = new Task(this.task.getApplication(), td.getLang(), td.getName(), td.hasPriority(), td.getNumNodes(), td.isReduction(), td.isReplicated(), td.isDistributed(), td.hasTargetObject(), td.getNumReturns(), taskP, this.task.getTaskMonitor(), td.getOnFailure(), td.getTimeOut());
        ResourceScheduler<? extends WorkerResourceDescription> partialReduceScheduler = this.ts.getWorkers().iterator().next();
        for (ResourceScheduler<? extends WorkerResourceDescription> rs : this.ts.getWorkers()) {
            if (rs.getResource() != resource) continue;
            partialReduceScheduler = rs;
            break;
        }
        ExecutionAction partialReduceAction = new ExecutionAction(this.ts.generateSchedulingInformation(partialReduceScheduler, td.getParameters(), td.getCoreElement().getCoreId()), this.orchestrator, this.ap, partialTask);
        this.addDataPredecessor(partialReduceAction);
        this.partialParameters.put(partialReduceAction, partialIn);
        this.ts.newAllocatableAction(partialReduceAction);
        this.addExecutingToResource(partialReduceAction, resource);
    }

    private void addExecutingToResource(AllocatableAction partialReduceAction, Resource resource) {
        List<Object> actions;
        if (!this.executingInResource.containsKey(resource)) {
            actions = new ArrayList();
            this.executingInResource.put(resource, actions);
        }
        actions = this.executingInResource.get(resource);
        actions.add(partialReduceAction);
    }

    @Override
    protected void doCompleted() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(0, this.initialCollection);
        ((ReduceTask)this.task).clearPartials();
        super.doCompleted();
    }

    @Override
    protected void doFailed() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(0, this.initialCollection);
        super.doFailed();
    }

    @Override
    protected void doCanceled() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(0, this.initialCollection);
        super.doCanceled();
    }

    @Override
    protected void doFailIgnored() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(0, this.initialCollection);
        super.doFailIgnored();
    }
}

