/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.ActionNotWaitingException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceScheduler<T extends WorkerResourceDescription> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final List<AllocatableAction> running = new LinkedList<AllocatableAction>();
    protected final PriorityQueue<AllocatableAction> blocked = new PriorityQueue<AllocatableAction>(20, new Comparator<AllocatableAction>(){

        @Override
        public int compare(AllocatableAction a1, AllocatableAction a2) {
            Score score1 = ResourceScheduler.this.generateBlockedScore(a1);
            Score score2 = ResourceScheduler.this.generateBlockedScore(a2);
            return score1.compareTo(score2);
        }
    });
    protected final Worker<T> myWorker;
    private final List<ResourceUpdate<T>> pendingModifications;
    private Profile[][] profiles;
    private boolean removed = false;

    public ResourceScheduler(Worker<T> w, JSONObject defaultResource, JSONObject defaultImplementations) {
        JSONObject resMap;
        this.myWorker = w;
        this.pendingModifications = new LinkedList<ResourceUpdate<T>>();
        if (defaultResource != null) {
            try {
                resMap = defaultResource.getJSONObject("implementations");
            }
            catch (JSONException je) {
                resMap = null;
            }
        } else {
            resMap = null;
        }
        this.profiles = this.loadProfiles(resMap, defaultImplementations);
    }

    public final String getName() {
        return this.myWorker.getName();
    }

    public final Worker<T> getResource() {
        return this.myWorker;
    }

    public final List<Integer> getExecutableCores() {
        return this.myWorker.getExecutableCores();
    }

    public final List<Implementation>[] getExecutableImpls() {
        return this.myWorker.getExecutableImpls();
    }

    public final List<Implementation> getExecutableImpls(int coreId) {
        return this.myWorker.getExecutableImpls(coreId);
    }

    public final void pendingModification(ResourceUpdate<T> modification) {
        this.pendingModifications.add(modification);
    }

    public final boolean hasPendingModifications() {
        return !this.pendingModifications.isEmpty();
    }

    public final List<ResourceUpdate<T>> getPendingModifications() {
        return this.pendingModifications;
    }

    public final void completedModification(ResourceUpdate<T> modification) {
        this.pendingModifications.remove(modification);
    }

    protected final Profile[][] loadProfiles(JSONObject resMap, JSONObject implMap) {
        int coreCount = CoreManager.getCoreCount();
        Profile[][] profiles = new Profile[coreCount][];
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            List<Implementation> impls = ce.getImplementations();
            int implCount = impls.size();
            profiles[coreId] = new Profile[implCount];
            for (Implementation impl : impls) {
                String signature = impl.getSignature();
                JSONObject jsonImpl = null;
                if (resMap != null) {
                    try {
                        jsonImpl = resMap.getJSONObject(signature);
                        profiles[coreId][impl.getImplementationId().intValue()] = this.generateProfileForImplementation(impl, jsonImpl);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (profiles[coreId][impl.getImplementationId()] != null) continue;
                if (implMap != null) {
                    try {
                        jsonImpl = implMap.getJSONObject(signature);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                profiles[coreId][impl.getImplementationId().intValue()] = this.generateProfileForImplementation(impl, jsonImpl);
                profiles[coreId][impl.getImplementationId()].clearExecutionCount();
            }
        }
        return profiles;
    }

    public void updatedCoreElements(int newCoreCount, JSONObject resourceJSON) {
        JSONObject implMap;
        int oldCoreCount = this.profiles.length;
        Profile[][] profiles = new Profile[newCoreCount][];
        if (resourceJSON != null) {
            try {
                implMap = resourceJSON.getJSONObject("implementations");
            }
            catch (JSONException je) {
                implMap = null;
            }
        } else {
            implMap = null;
        }
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            int oldImplCount = 0;
            if (coreId < oldCoreCount) {
                oldImplCount = this.profiles[coreId].length;
            }
            List<Implementation> impls = ce.getImplementations();
            int newImplCount = impls.size();
            profiles[coreId] = new Profile[newImplCount];
            for (Implementation impl : impls) {
                JSONObject jsonImpl;
                int implId = impl.getImplementationId();
                if (implId < oldImplCount) {
                    profiles[coreId][implId] = this.profiles[coreId][implId];
                    continue;
                }
                if (implMap != null) {
                    try {
                        jsonImpl = implMap.getJSONObject(impl.getSignature());
                    }
                    catch (JSONException je) {
                        jsonImpl = null;
                    }
                } else {
                    jsonImpl = null;
                }
                profiles[coreId][implId] = this.generateProfileForImplementation(impl, jsonImpl);
            }
        }
        this.profiles = profiles;
    }

    public Profile generateProfileForImplementation(Implementation impl, JSONObject jsonImpl) {
        return new Profile(jsonImpl);
    }

    public <R extends WorkerResourceDescription> Profile generateProfileForRun(AllocatableAction action) {
        return new Profile();
    }

    public final Profile getProfile(int coreId, int implId) {
        return this.profiles[coreId][implId];
    }

    public final Profile getProfile(Implementation impl) {
        if (impl != null && impl.getCoreId() != null) {
            return this.getProfile(impl.getCoreId(), impl.getImplementationId());
        }
        return null;
    }

    public final void profiledExecution(Implementation impl, Profile profile) {
        if (impl != null) {
            int coreId = impl.getCoreId();
            int implId = impl.getImplementationId();
            this.profiles[coreId][implId].accumulate(profile);
        }
    }

    public final int getNumTasks(int coreId) {
        int taskCount = -1;
        if (coreId < this.profiles.length) {
            taskCount = 0;
            for (AllocatableAction aa : this.getHostedActions()) {
                Integer cId;
                if (aa == null || (cId = aa.getCoreId()) == null || cId != coreId) continue;
                ++taskCount;
            }
        }
        return taskCount;
    }

    public final boolean canRunSomething() {
        return this.myWorker.canRunSomething();
    }

    public final AllocatableAction[] getHostedActions() {
        return this.running.toArray(new AllocatableAction[this.running.size()]);
    }

    public final void hostAction(AllocatableAction action) {
        LOGGER.debug("[ResourceScheduler] Host action " + action);
        this.running.add(action);
    }

    public final void unhostAction(AllocatableAction action) {
        LOGGER.debug("[ResourceScheduler] Unhost action " + action + " on resource " + this.getName());
        this.running.remove(action);
    }

    public final void waitOnResource(AllocatableAction action) {
        LOGGER.debug("[ResourceScheduler] Block action " + action + " on resource " + this.getName());
        if (!this.removed) {
            this.blocked.add(action);
        } else {
            LOGGER.warn("[ResourceScheduler] Blocked action " + action + " on removed resource " + this.getName() + ". Trying to reschedule... ");
            try {
                this.unscheduleAction(action);
                action.schedule(this.generateBlockedScore(action));
            }
            catch (Exception e) {
                ErrorManager.error("Error rescheduling action to a removed resource", e);
            }
        }
    }

    public final boolean hasBlockedActions() {
        return !this.blocked.isEmpty();
    }

    public PriorityQueue<AllocatableAction> getBlockedActions() {
        return this.blocked;
    }

    public final AllocatableAction getFirstBlocked() {
        return this.blocked.peek();
    }

    public final void removeFirstBlocked() {
        this.blocked.poll();
    }

    public final void tryToLaunchBlockedActions() {
        LOGGER.debug("[ResourceScheduler] Try to launch blocked actions on resource " + this.getName());
        while (this.hasBlockedActions()) {
            AllocatableAction firstBlocked = this.getFirstBlocked();
            Implementation selectedImplementation = firstBlocked.getAssignedImplementation();
            if (firstBlocked.isToReserveResources() && !this.myWorker.canRunNow(selectedImplementation.getRequirements())) break;
            try {
                firstBlocked.resumeExecution();
                this.removeFirstBlocked();
            }
            catch (ActionNotWaitingException actionNotWaitingException) {}
        }
    }

    public void scheduleAction(AllocatableAction action) {
        LOGGER.debug("[ResourceScheduler] Schedule action " + action + " on resource " + this.getName());
    }

    public List<AllocatableAction> unscheduleAction(AllocatableAction action) throws ActionNotFoundException {
        if (DEBUG) {
            LOGGER.debug("[ResourceScheduler] Unschedule action " + action + " on resource scheduler for " + this.getName() + " No new actions have been released.");
        }
        action.assignResource(null);
        return new LinkedList<AllocatableAction>();
    }

    public final void cancelAction(AllocatableAction action) throws ActionNotFoundException {
        LOGGER.debug("[ResourceScheduler] Cancel action " + action + " on resource " + this.getName());
        this.blocked.remove(action);
        this.unscheduleAction(action);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        LOGGER.debug("[ResourceScheduler] Generate blocked score for action " + action);
        return new Score(action.getPriority(), action.getGroupPriority(), 0L, 0L, 0L);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long waitingScore = -this.blocked.size();
        long resourceScore = (long)action.getSchedulingInfo().getScore(this.myWorker);
        if (this.myWorker == Comm.getAppHost()) {
            ++resourceScore;
        }
        return new Score(priority, groupId, resourceScore, waitingScore, 0L);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        long priority = resourceScore.getPriority();
        long groupId = action.getGroupPriority();
        long resource = resourceScore.getResourceScore();
        if (!this.myWorker.canRunNow(impl.getRequirements())) {
            resource -= Integer.MAX_VALUE;
        }
        long waitingScore = resourceScore.getWaitingScore();
        long implScore = -this.getProfile(impl).getAverageExecutionTime();
        return new Score(priority, groupId, resource, waitingScore, implScore);
    }

    public void clear() {
        LOGGER.debug("[ResourceScheduler] Clear resource scheduler " + this.getName());
        this.running.clear();
        this.blocked.clear();
        this.pendingModifications.clear();
        this.myWorker.releaseAllResources();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        HashMap<String, JSONObject> implsMap = new HashMap<String, JSONObject>();
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            for (Implementation impl : ce.getImplementations()) {
                int implId = impl.getImplementationId();
                JSONObject implProfile = this.profiles[coreId][implId].toJSONObject();
                implsMap.put(impl.getSignature(), implProfile);
            }
        }
        jsonObject.put("implementations", implsMap);
        return jsonObject;
    }

    public JSONObject updateJSON(JSONObject oldResource) {
        JSONObject difference = new JSONObject();
        JSONObject implsDiff = new JSONObject();
        difference.put("implementations", implsDiff);
        JSONObject implsMap = oldResource.getJSONObject("implementations");
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            for (Implementation impl : ce.getImplementations()) {
                int implId = impl.getImplementationId();
                String signature = impl.getSignature();
                if (implsMap.has(signature)) {
                    JSONObject implJSON = implsMap.getJSONObject(signature);
                    JSONObject diff = this.profiles[coreId][implId].updateJSON(implJSON);
                    implsDiff.put(signature, diff);
                    continue;
                }
                JSONObject implProfile = this.profiles[coreId][implId].toJSONObject();
                implsMap.put(signature, implProfile);
                implsDiff.put(signature, implProfile);
            }
        }
        return difference;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String toString() {
        try {
            return "ResourceScheduler@" + this.getName();
        }
        catch (NullPointerException ne) {
            return super.toString();
        }
    }
}

