/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ServiceDefinition
implements ImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 4;
    private String namespace;
    private String serviceName;
    private String operation;
    private String port;

    public ServiceDefinition() {
    }

    public ServiceDefinition(String namespace, String serviceName, String operation, String port) {
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.operation = operation;
        this.port = port;
    }

    public ServiceDefinition(String[] implTypeArgs, int offset) {
        this.namespace = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.operation = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.port = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SERVICE Definition \n");
        sb.append("\t Namespace: ").append(this.namespace).append("\n");
        sb.append("\t Service name: ").append(this.serviceName).append("\n");
        sb.append("\t Operation: ").append(this.operation).append("\n");
        sb.append("\t Port: ").append(this.port).append("\n");
        return sb.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SERVICE;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.namespace = (String)in.readObject();
        this.serviceName = (String)in.readObject();
        this.operation = (String)in.readObject();
        this.port = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.namespace);
        out.writeObject(this.serviceName);
        out.writeObject(this.operation);
        out.writeObject(this.port);
    }

    @Override
    public String toShortFormat() {
        return " Service in namespace " + this.namespace + " with name " + this.serviceName + " on port " + this.port + "and operation " + this.operation;
    }

    public String getOperation() {
        return this.operation;
    }
}

