/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import es.bsc.compss.worker.COMPSsException;
import java.util.concurrent.Semaphore;

public class BarrierRequest
extends APRequest
implements Barrier {
    private final Semaphore sem;
    private final Application app;
    private boolean released;
    private boolean stalled;

    public BarrierRequest(Application app, Semaphore sem) {
        this.app = app;
        this.sem = sem;
        this.released = false;
        this.stalled = false;
    }

    public Application getApp() {
        return this.app;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        ta.barrier(this);
        BarrierRequest barrierRequest = this;
        synchronized (barrierRequest) {
            if (!this.released) {
                this.app.stalled();
                this.stalled = true;
            }
        }
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.WAIT_FOR_ALL_TASKS;
    }

    @Override
    public void setException(COMPSsException exception) {
    }

    @Override
    public COMPSsException getException() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        BarrierRequest barrierRequest = this;
        synchronized (barrierRequest) {
            this.released = true;
            if (this.stalled) {
                this.app.readyToContinue(this.sem);
            } else {
                this.sem.release();
            }
        }
    }
}

