/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import java.io.File;
import java.util.concurrent.Semaphore;

public class DeleteFileRequest
extends APRequest {
    private final Application app;
    private final DataLocation loc;
    private final Semaphore sem;
    private boolean noReuse;

    public DeleteFileRequest(Application app, DataLocation loc, Semaphore sem, boolean noReuse) {
        this.app = app;
        this.loc = loc;
        this.sem = sem;
        this.noReuse = noReuse;
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        LOGGER.info("[DeleteFileRequest] Notify data delete " + this.loc.getPath() + " to DIP...");
        FileInfo fileInfo = (FileInfo)dip.deleteData(this.app, this.loc, this.noReuse);
        if (fileInfo == null) {
            String filePath = this.loc.getURIs().get(0).getPath();
            File f = new File(filePath);
            if (f.exists()) {
                if (f.delete()) {
                    LOGGER.info("[DeleteFileRequest] File " + filePath + " deleted.");
                } else {
                    LOGGER.error("[DeleteFileRequest] Error on deleting file " + filePath);
                }
            }
        } else {
            LOGGER.info("[DeleteFileRequest] Deleting Data in Task Analyser");
            ta.deleteData(fileInfo);
        }
        this.sem.release();
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.DELETE_FILE;
    }
}

