/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.TaskListener;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import java.util.concurrent.Semaphore;

public class RegisterDataAccessRequest
extends APRequest
implements TaskListener {
    private final AccessParams accessParams;
    private DataAccessId accessId;
    private final AccessParams.AccessMode accessMode;
    private int pendingOperation = 0;
    private final Semaphore sem;

    public RegisterDataAccessRequest(AccessParams access, AccessParams.AccessMode accessMode) {
        this.accessParams = access;
        this.accessMode = accessMode;
        this.sem = new Semaphore(0);
    }

    public AccessParams getAccessParams() {
        return this.accessParams;
    }

    public AccessParams.AccessMode getTaskAccessMode() {
        return this.accessMode;
    }

    public DataAccessId getAccessId() {
        return this.accessId;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        this.accessId = ta.processMainAccess(this);
        if (this.pendingOperation == 0) {
            if (DEBUG) {
                int dataId = this.accessId.getDataId();
                LOGGER.debug("Data " + dataId + " available for main access");
            }
            this.sem.release();
        } else {
            Application app = this.accessParams.getApp();
            app.stalled();
        }
    }

    public void waitForCompletion() {
        this.sem.acquireUninterruptibly();
    }

    public void addPendingOperation() {
        ++this.pendingOperation;
    }

    @Override
    public void taskFinished() {
        --this.pendingOperation;
        if (this.pendingOperation == 0) {
            if (DEBUG) {
                int dataId = this.accessId.getDataId();
                LOGGER.debug("Data " + dataId + " available for main access");
            }
            Application app = this.accessParams.getApp();
            app.readyToContinue(this.sem);
        }
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.REGISTER_DATA_ACCESS;
    }
}

