/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.ServiceResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.ServiceConfiguration;

public class ServiceWorker
extends Worker<ServiceResourceDescription> {
    private String wsdl;

    public ServiceWorker(String wsdl, ServiceResourceDescription description, ServiceConfiguration conf) {
        super(wsdl, description, conf, null);
        this.wsdl = wsdl;
    }

    public ServiceWorker(ServiceWorker sw) {
        super(sw);
        this.wsdl = sw.getWsdl();
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public String getServiceName() {
        return ((ServiceResourceDescription)this.description).getServiceName();
    }

    public String getNamespace() {
        return ((ServiceResourceDescription)this.description).getNamespace();
    }

    public String getPort() {
        return ((ServiceResourceDescription)this.description).getPort();
    }

    @Override
    public String getName() {
        return this.wsdl;
    }

    @Override
    public void retrieveTracingAndDebugData() {
    }

    @Override
    public void disableExecution() {
    }

    @Override
    public Integer fitCount(Implementation impl) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean hasAvailable(ServiceResourceDescription consumption) {
        return true;
    }

    @Override
    public boolean hasAvailableSlots() {
        return true;
    }

    @Override
    public ServiceResourceDescription reserveResource(ServiceResourceDescription consumption) {
        return consumption;
    }

    @Override
    public void releaseResource(ServiceResourceDescription consumption) {
    }

    @Override
    public void releaseAllResources() {
        super.resetUsedTaskCounts();
    }

    @Override
    public ResourceType getType() {
        return ResourceType.SERVICE;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<TotalComputingUnits></TotalComputingUnits>").append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case SERVICE: {
                return this.getName().compareTo(t.getName());
            }
            case WORKER: {
                return -1;
            }
            case HTTP: 
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation implementation) {
        switch (implementation.getTaskType()) {
            case SERVICE: {
                ServiceResourceDescription s = (ServiceResourceDescription)implementation.getRequirements();
                return ((ServiceResourceDescription)this.description).getNamespace().compareTo(s.getNamespace()) == 0 && ((ServiceResourceDescription)this.description).getServiceName().compareTo(s.getServiceName()) == 0 && ((ServiceResourceDescription)this.description).getPort().compareTo(s.getPort()) == 0;
            }
        }
        return false;
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = SERVICE").append("\n");
        return sb.toString();
    }

    public ServiceWorker getSchedulingCopy() {
        return new ServiceWorker(this);
    }
}

