/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.WorkloadState;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceOptimizer
extends Thread {
    protected static final Logger RESOURCES_LOGGER = LogManager.getLogger("es.bsc.compss.Resources");
    protected static final Logger RUNTIME_LOGGER = LogManager.getLogger("es.bsc.compss.Components.ResourceManager");
    protected static final boolean DEBUG = RUNTIME_LOGGER.isDebugEnabled();
    private static final String WARN_NO_RESOURCE_MATCHES = "WARN: No resource matches the constraints";
    private static final String WARN_NO_COMPATIBLE_TYPE = "WARN: Cannot find any compatible instanceType";
    private static final String WARN_NO_COMPATIBLE_IMAGE = "WARN: Cannot find any compatible Image";
    private static final String WARN_NO_VALID_INSTANCE = "WARN: Cannot find a containing/contained instanceType";
    private static final String WARN_NO_MORE_INSTANCES = "WARN: Cloud Provider cannot host more instances";
    private static final String WARN_NO_POSIBLE_INCREASE = "WARN: Cloud Provider cannot increase resources";
    private static final String WARN_EXCEPTION_TURN_ON = "WARN: Connector exception on turn on resource";
    private static final int INITIAL_SLEEP = 1000;
    private static final int SLEEP_TIME = 2000;
    private static final int EVERYTHING_BLOCKED_INTERVAL_TIME = 20000;
    private static final int EVERYTHING_BLOCKED_MAX_RETRIES = 3;
    private static final String ERROR_OPT_RES = "Error optimizing resources.";
    private static final String PERSISTENT_BLOCK_ERR = "Unschedulable tasks detected.\nCOMPSs has found tasks with constraints that cannot be fulfilled.\nShutting down COMPSs now...";
    private static boolean cleanUp;
    private static boolean redo;
    protected final TaskScheduler ts;
    private boolean running;
    private int everythingBlockedRetryCount = -1;
    private long lastPotentialBlockedCheck = System.currentTimeMillis();
    private Map<CloudInstanceTypeDescription, CloudTypeProfile> defaultProfiles;

    public ResourceOptimizer(TaskScheduler ts) {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Initializing Resource Optimizer");
        }
        this.setName("ResourceOptimizer");
        this.ts = ts;
        redo = false;
        this.defaultProfiles = new HashMap<CloudInstanceTypeDescription, CloudTypeProfile>();
        for (CloudProvider cp : ResourceManager.getAvailableCloudProviders()) {
            for (CloudInstanceTypeDescription citd : cp.getAllTypes()) {
                JSONObject citdJSON = ts.getJSONForCloudInstanceTypeDescription(cp, citd);
                JSONObject implsJSON = ts.getJSONForImplementations();
                CloudTypeProfile prof = this.generateCloudTypeProfile(citdJSON, implsJSON);
                this.defaultProfiles.put(citd, prof);
                RUNTIME_LOGGER.debug("[ResourceOptimizer] JSONProfile for " + citd.getName() + " --> " + citdJSON);
            }
        }
        RUNTIME_LOGGER.info("[Resource Optimizer] Initialization finished");
    }

    protected CloudTypeProfile generateCloudTypeProfile(JSONObject citdJSON, JSONObject implsJSON) {
        return new CloudTypeProfile(citdJSON, implsJSON);
    }

    protected CloudTypeProfile getCloudTypeProfile(CloudInstanceTypeDescription citd) {
        return this.defaultProfiles.get(citd);
    }

    public void coreElementsUpdated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.running = true;
        if (ResourceManager.useCloud()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (ResourceManager.useCloud()) {
            RUNTIME_LOGGER.info("[Resource Optimizer] Checking initial creations");
            this.initialCreations();
        }
        while (this.running) {
            try {
                this.doOperations();
                this.periodicRemoveObsoletes();
                this.periodicCheckWorkers();
                try {
                    ResourceOptimizer e = this;
                    synchronized (e) {
                        if (this.running) {
                            this.wait(2000L);
                        }
                    }
                }
                catch (InterruptedException e) {
                }
            }
            catch (Exception e) {
                RUNTIME_LOGGER.error(ERROR_OPT_RES, (Throwable)e);
            }
        }
    }

    private void doOperations() {
        do {
            int blockedTasks;
            boolean potentialBlock;
            redo = false;
            if (ResourceManager.useCloud() && this.isAutomaticScalingEnabled() && !this.ts.isExternalAdaptationEnabled()) {
                if (DEBUG) {
                    RUNTIME_LOGGER.debug("[Resource Optimizer] Applying automatic scaling operations");
                }
                WorkloadState workload = this.ts.getWorkload();
                this.applyPolicies(workload);
            }
            if (DEBUG) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Handling potential blocks");
            }
            boolean bl = potentialBlock = (blockedTasks = this.ts.getNumberOfBlockedActions()) > 0;
            if (ResourceManager.useCloud()) {
                int vmsBeingCreated = ResourceManager.getPendingCreationRequests().size();
                potentialBlock = potentialBlock && vmsBeingCreated == 0;
            }
            this.handlePotentialBlock(potentialBlock);
        } while (redo);
    }

    private boolean isAutomaticScalingEnabled() {
        for (CloudProvider cp : ResourceManager.getAvailableCloudProviders()) {
            if (!cp.isAutomaticScalingEnabled()) continue;
            return true;
        }
        return false;
    }

    private void periodicRemoveObsoletes() {
        List<Worker<? extends WorkerResourceDescription>> workers = ResourceManager.getAllWorkers();
        for (Worker<? extends WorkerResourceDescription> w : workers) {
            List<MultiURI> obsoletes = w.pollObsoletes();
            if (obsoletes.size() <= 0) continue;
            w.getNode().removeObsoletes(obsoletes);
        }
    }

    private void periodicCheckWorkers() {
        List<Worker<? extends WorkerResourceDescription>> workers = ResourceManager.getAllWorkers();
        for (Worker<? extends WorkerResourceDescription> w : workers) {
            if (!w.isLost()) {
                w.getNode().verifyNodeIsRunning();
                continue;
            }
            RUNTIME_LOGGER.debug(" Node is lost, skipping ping: " + w.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void optimizeNow() {
        ResourceOptimizer resourceOptimizer = this;
        synchronized (resourceOptimizer) {
            this.notify();
            redo = true;
        }
    }

    public void cleanUp() {
        cleanUp = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        ResourceOptimizer resourceOptimizer = this;
        synchronized (resourceOptimizer) {
            this.running = false;
            this.notify();
            cleanUp = true;
        }
        RESOURCES_LOGGER.info(this.ts.getWorkload());
    }

    public final void handlePotentialBlock(boolean potentialBlock) {
        if (potentialBlock) {
            if (System.currentTimeMillis() - this.lastPotentialBlockedCheck > 20000L) {
                this.lastPotentialBlockedCheck = System.currentTimeMillis();
                ++this.everythingBlockedRetryCount;
                if (this.everythingBlockedRetryCount > 0) {
                    if (this.everythingBlockedRetryCount < 3) {
                        int retriesLeft = 3 - this.everythingBlockedRetryCount;
                        ErrorManager.warn("No task could be scheduled to any of the available resources.\nThis could end up blocking COMPSs. Will check it again in 20 seconds.\nPossible causes: \n    -Network problems: non-reachable nodes, sshd service not started, etc.\n    -There isn't any computing resource that fits the defined tasks constraints.\nIf this happens " + retriesLeft + " more time" + (retriesLeft > 1 ? "s" : "") + ", the runtime will shutdown.");
                    } else {
                        ErrorManager.error(PERSISTENT_BLOCK_ERR);
                    }
                }
            }
        } else {
            this.everythingBlockedRetryCount = 0;
            this.lastPotentialBlockedCheck = System.currentTimeMillis();
        }
    }

    protected void initialCreations() {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Requesting VMs related to registered coreElements");
        }
        int ceFilledVms = ResourceOptimizer.addBasicNodes();
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Requested " + ceFilledVms + " coreElement-related VMs");
        }
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Requesting VMs to fulfill initialVMs property");
        }
        int extraVms = ResourceOptimizer.addExtraNodes(ceFilledVms);
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Requested " + extraVms + " extra VMs");
        }
    }

    public static int addBasicNodes() {
        int coreCount = CoreManager.getCoreCount();
        List<ConstraintsCore>[] unfulfilledConstraints = ResourceOptimizer.getUnfulfilledConstraints();
        int unfulfilledConstraintsCores = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (unfulfilledConstraints[coreId].size() <= 0) continue;
            unfulfilledConstraintsCores += unfulfilledConstraints[coreId].size();
            break;
        }
        if (unfulfilledConstraintsCores == 0) {
            return 0;
        }
        Map<String, List<ConstraintsCore>> arch2Constraints = ResourceOptimizer.classifyArchitectures(unfulfilledConstraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        ResourceOptimizer.reassignUnassignedConstraints(arch2Constraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        int createdCount = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            while (!unfulfilledConstraints[coreId].isEmpty()) {
                ConstraintsCore cc = unfulfilledConstraints[coreId].remove(0);
                cc.confirmed();
                ResourceCreationRequest rcr = ResourceOptimizer.askForResources(cc.desc, false);
                if (rcr == null) continue;
                rcr.print(RESOURCES_LOGGER, DEBUG);
                ++createdCount;
            }
        }
        if (DEBUG) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [\n\tIn order to be able to execute all cores, Resource Manager has asked for " + createdCount + " Cloud resources\n]");
        }
        return createdCount;
    }

    private static List<ConstraintsCore>[] getUnfulfilledConstraints() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] unfulfilledConstraints = new LinkedList[coreCount];
        int[] maxSimTasks = ResourceManager.getTotalSlots();
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            unfulfilledConstraints[coreId] = new LinkedList();
            if (maxSimTasks[coreId] != 0) continue;
            List<Implementation> impls = ce.getImplementations();
            for (Implementation impl : impls) {
                if (impl.getTaskType() != TaskType.METHOD) continue;
                MethodResourceDescription requirements = (MethodResourceDescription)impl.getRequirements();
                CloudMethodResourceDescription cd = new CloudMethodResourceDescription(requirements);
                ConstraintsCore cc = new ConstraintsCore(cd, coreId, unfulfilledConstraints[coreId]);
                unfulfilledConstraints[coreId].add(cc);
            }
        }
        return unfulfilledConstraints;
    }

    private static Map<String, List<ConstraintsCore>> classifyArchitectures(List<ConstraintsCore>[] constraints) {
        HashMap<String, List<ConstraintsCore>> archs = new HashMap<String, List<ConstraintsCore>>();
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            if (constraints[coreId] == null) continue;
            for (ConstraintsCore cc : constraints[coreId]) {
                List<String> runnableArchitectures = cc.desc.getArchitectures();
                for (String arch : runnableArchitectures) {
                    LinkedList<ConstraintsCore> archConstr = (LinkedList<ConstraintsCore>)archs.get(arch);
                    if (archConstr == null) {
                        archConstr = new LinkedList<ConstraintsCore>();
                        archs.put(arch, archConstr);
                    }
                    archConstr.add(cc);
                }
            }
        }
        return archs;
    }

    private static void reduceArchitecturesConstraints(Map<String, List<ConstraintsCore>> arch2Ctrs) {
        for (List<ConstraintsCore> arch : arch2Ctrs.values()) {
            ConstraintsCore[] ctrs = new ConstraintsCore[arch.size()];
            int i = 0;
            for (ConstraintsCore cc : arch) {
                ctrs[i++] = cc;
            }
            Integer[] mergedTo = new Integer[arch.size()];
            for (i = 0; i < ctrs.length; ++i) {
                if (mergedTo[i] != null) continue;
                String os = ctrs[i].desc.getOperatingSystemType();
                for (int j = i + 1; j < ctrs.length; ++j) {
                    if (mergedTo[j] != null || os.compareTo(ctrs[j].desc.getOperatingSystemType()) != 0 && os.compareTo("[unassigned]") != 0 && ctrs[j].desc.getOperatingSystemType().compareTo("[unassigned]") != 0) continue;
                    mergedTo[j] = i;
                    ctrs[i].join(ctrs[j]);
                    arch.remove(ctrs[j]);
                }
            }
        }
    }

    private static void reassignUnassignedConstraints(Map<String, List<ConstraintsCore>> arch2Ctrs) {
        List<ConstraintsCore> unassignedList = arch2Ctrs.get("[unassigned]");
        if (unassignedList == null) {
            return;
        }
        if (arch2Ctrs.size() == 1) {
            return;
        }
        if (arch2Ctrs.size() == 2) {
            for (Map.Entry<String, List<ConstraintsCore>> ctrs : arch2Ctrs.entrySet()) {
                if (((String)ctrs.getKey()).compareTo("[unassigned]") == 0) continue;
                ((List)ctrs.getValue()).addAll(unassignedList);
                return;
            }
        }
        LinkedList assignedList = new LinkedList();
        for (Map.Entry entry : arch2Ctrs.entrySet()) {
            if (((String)entry.getKey()).compareTo("[unassigned]") == 0) continue;
            assignedList.addAll((Collection)entry.getValue());
        }
        while (!unassignedList.isEmpty()) {
            ConstraintsCore unassigned = unassignedList.remove(0);
            CloudMethodResourceDescription cloudMethodResourceDescription = unassigned.desc;
            String bestArch = "[unassigned]";
            Float bestDifference = Float.valueOf(Float.MAX_VALUE);
            for (ConstraintsCore assigned : assignedList) {
                List<String> availArchs;
                CloudMethodResourceDescription option = assigned.desc;
                float difference = cloudMethodResourceDescription.difference(option);
                if (bestDifference.floatValue() < 0.0f) {
                    if (!(difference < 0.0f) || !(difference > bestDifference.floatValue())) continue;
                    availArchs = option.getArchitectures();
                    if (availArchs != null && !availArchs.isEmpty()) {
                        bestArch = availArchs.get(0);
                    }
                    bestDifference = Float.valueOf(difference);
                    continue;
                }
                if (!(difference < bestDifference.floatValue())) continue;
                availArchs = option.getArchitectures();
                if (availArchs != null && !availArchs.isEmpty()) {
                    bestArch = availArchs.get(0);
                }
                bestDifference = Float.valueOf(difference);
            }
            List<Processor> procs = unassigned.desc.getProcessors();
            if (procs == null) {
                procs = new LinkedList<Processor>();
            }
            if (!procs.isEmpty()) {
                procs.get(0).setArchitecture(bestArch);
            } else {
                Processor p = new Processor();
                p.setArchitecture(bestArch);
                procs.add(p);
            }
            arch2Ctrs.get(bestArch).add(unassigned);
        }
    }

    public static int addExtraNodes(int alreadyCreated) {
        int initialVMsCount = ResourceManager.getInitialCloudVMs();
        int vmCount = initialVMsCount - alreadyCreated;
        if (vmCount <= 0) {
            return 0;
        }
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Adding " + vmCount + " extra VMs for initialVM property...");
            RESOURCES_LOGGER.debug("DEBUG_MSG = [\n\tALREADY_CREATED_INSTANCES = " + alreadyCreated + "\n\tMAXIMUM_NEW_PETITIONS = " + vmCount + "\n]");
        }
        ResourceManager.requestResources(vmCount, null);
        return vmCount;
    }

    protected void applyPolicies(WorkloadState workload) {
        long creationTime;
        int currentCloudVMCount = ResourceManager.getCurrentVMCount();
        Integer maxNumberOfVMs = ResourceManager.getMaxCloudVMs();
        Integer minNumberOfVMs = ResourceManager.getMinCloudVMs();
        try {
            creationTime = ResourceManager.getNextCreationTime();
        }
        catch (Exception ex) {
            creationTime = 120000L;
        }
        if (creationTime < 30000L) {
            creationTime = 30000L;
        }
        int coreCount = workload.getCoreCount();
        int noResourceCount = workload.getNoResourceCount();
        int[] noResourceCounts = workload.getNoResourceCounts();
        long[] minCoreTime = new long[coreCount];
        long[] meanCoreTime = new long[coreCount];
        long[] maxCoreTime = new long[coreCount];
        long[] minRemainingCoreTime = new long[coreCount];
        long[] meanRemainingCoreTime = new long[coreCount];
        long[] maxRemainingCoreTime = new long[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            minCoreTime[coreId] = Math.min(workload.getCoreMinTime(coreId), creationTime);
            meanCoreTime[coreId] = Math.min(workload.getCoreMeanTime(coreId), creationTime);
            maxCoreTime[coreId] = Math.min(workload.getCoreMaxTime(coreId), creationTime);
            long meanRunningCoreTime = workload.getRunningCoreMeanTime(coreId);
            minRemainingCoreTime[coreId] = minCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(minCoreTime[coreId] - meanRunningCoreTime, creationTime);
            meanRemainingCoreTime[coreId] = meanCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(meanCoreTime[coreId] - meanRunningCoreTime, creationTime);
            maxRemainingCoreTime[coreId] = maxCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(maxCoreTime[coreId] - meanRunningCoreTime, creationTime);
        }
        long[] runningMinCoreTime = new long[coreCount];
        long[] runningMeanCoreTime = new long[coreCount];
        long[] runningMaxCoreTime = new long[coreCount];
        long[] readyMinCoreTime = new long[coreCount];
        long[] readyMeanCoreTime = new long[coreCount];
        long[] readyMaxCoreTime = new long[coreCount];
        long[] pendingMinCoreTime = new long[coreCount];
        long[] pendingMeanCoreTime = new long[coreCount];
        long[] pendingMaxCoreTime = new long[coreCount];
        int[] realSlots = ResourceManager.getAvailableSlots();
        int[] totalSlots = ResourceManager.getTotalSlots();
        int[] runningCounts = workload.getRunningTaskCounts();
        int[] readyCounts = workload.getReadyCounts();
        int[] pendingCounts = new int[coreCount];
        long totalPendingTasks = 0L;
        int maxConcurrentTasks = 0;
        for (int i = 0; i < coreCount; ++i) {
            runningMinCoreTime[i] = minRemainingCoreTime[i] * (long)runningCounts[i];
            readyMinCoreTime[i] = runningMinCoreTime[i] + minCoreTime[i] * (long)readyCounts[i];
            pendingMinCoreTime[i] = readyMinCoreTime[i] + minCoreTime[i] * (long)pendingCounts[i];
            runningMeanCoreTime[i] = meanRemainingCoreTime[i] * (long)runningCounts[i];
            readyMeanCoreTime[i] = runningMeanCoreTime[i] + meanCoreTime[i] * (long)readyCounts[i];
            pendingMeanCoreTime[i] = readyMeanCoreTime[i] + meanCoreTime[i] * (long)pendingCounts[i];
            runningMaxCoreTime[i] = maxRemainingCoreTime[i] * (long)runningCounts[i];
            readyMaxCoreTime[i] = runningMaxCoreTime[i] + maxCoreTime[i] * (long)readyCounts[i];
            pendingMaxCoreTime[i] = readyMaxCoreTime[i] + maxCoreTime[i] * (long)pendingCounts[i];
            totalPendingTasks += (long)pendingCounts[i];
            if (runningCounts[i] <= 0 && readyCounts[i] <= 0 || realSlots[i] <= maxConcurrentTasks) continue;
            maxConcurrentTasks = realSlots[i];
        }
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Applying VM optimization policies (currentVMs: " + currentCloudVMCount + " maxVMs: " + maxNumberOfVMs + " minVMs: " + minNumberOfVMs + ")");
        }
        if (!cleanUp) {
            List<Integer> requiredVMs = this.checkNeededMachines(noResourceCount, noResourceCounts, totalSlots);
            if (!requiredVMs.isEmpty()) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Required VMs. Mandatory Increase");
                float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                for (Integer coreId : requiredVMs) {
                    creationRecommendations[coreId.intValue()] = Math.max(creationRecommendations[coreId], 1.0f);
                }
                this.mandatoryIncrease(creationRecommendations, requiredVMs);
                return;
            }
            if (minNumberOfVMs != null && minNumberOfVMs > currentCloudVMCount) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count smaller than minimum VMs (" + minNumberOfVMs + "). Mandatory Increase");
                float[] creationRecommendations = this.orderCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                this.mandatoryIncrease(creationRecommendations, new LinkedList<Integer>());
                return;
            }
            if (maxNumberOfVMs != null && maxNumberOfVMs < currentCloudVMCount) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count bigger than maximum VMs (" + maxNumberOfVMs + "). Mandatory reduction");
                float[] destroyRecommendations = this.deleteRecommendations(coreCount, 2000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
                this.mandatoryReduction(destroyRecommendations);
                return;
            }
        }
        if ((maxNumberOfVMs == null || maxNumberOfVMs > currentCloudVMCount) && workload.getReadyCount() > 1) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count smaller than maximum VMs (" + maxNumberOfVMs + ")");
            float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
            if (this.optionalIncrease(creationRecommendations)) {
                return;
            }
        }
        if ((minNumberOfVMs == null || minNumberOfVMs < currentCloudVMCount) && totalPendingTasks <= (long)(workload.getReadyCount() + workload.getRunningTaskCount()) && workload.getReadyCount() + workload.getRunningTaskCount() <= maxConcurrentTasks) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count bigger than minimum VMs (" + minNumberOfVMs + ")");
            float[] destroyRecommendations = this.deleteRecommendations(coreCount, 2000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
            if (this.optionalReduction(destroyRecommendations)) {
                return;
            }
        }
    }

    private void mandatoryIncrease(float[] creationRecommendations, List<Integer> requiredVMs) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        boolean[] required = new boolean[creationRecommendations.length];
        for (int coreId : requiredVMs) {
            required[coreId] = true;
        }
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            CoreElement ce = CoreManager.getCore(coreId);
            for (Implementation impl : ce.getImplementations()) {
                if (impl.getTaskType() == TaskType.SERVICE) continue;
                MethodResourceDescription constraints = ((AbstractMethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription(constraints, creationRecommendations[coreId], false);
                pq.add(v);
            }
        }
        ResourceOptimizer.requestOneCreation(pq, true);
    }

    private boolean optionalIncrease(float[] creationRecommendations) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            if (!(creationRecommendations[coreId] > 1.0f)) continue;
            CoreElement ce = CoreManager.getCore(coreId);
            for (Implementation impl : ce.getImplementations()) {
                if (impl.getTaskType() == TaskType.SERVICE) continue;
                MethodResourceDescription constraints = ((AbstractMethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription(constraints, creationRecommendations[coreId], false);
                pq.add(v);
            }
        }
        ResourceCreationRequest rcr = ResourceOptimizer.requestOneCreation(pq, false);
        return rcr != null;
    }

    private boolean optionalReduction(float[] destroyRecommendations) {
        ReductionOption nonCriticalSolution;
        List<DynamicMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations);
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Searching for best destruction");
        }
        if ((nonCriticalSolution = this.getBestDestruction(nonCritical, destroyRecommendations)) == null) {
            if (DEBUG) {
                RUNTIME_LOGGER.warn("[Resource Optimizer] No solution found");
            }
            return false;
        }
        CloudMethodWorker res = (CloudMethodWorker)nonCriticalSolution.getResource();
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Best resource to remove is " + nonCriticalSolution.getName() + "and record is [" + nonCriticalSolution.getUndesiredCEsAffected() + "," + nonCriticalSolution.getUndesiredSlotsAffected() + "," + nonCriticalSolution.getDesiredSlotsAffected() + "]");
        }
        if (nonCriticalSolution.getUndesiredSlotsAffected() > 0.0f && res.getUsedCPUTaskCount() > 0) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Optional destroy recommendation not applied");
            return false;
        }
        RUNTIME_LOGGER.debug("[Resource Optimizer] Optional destroy recommendation applied");
        nonCriticalSolution.apply();
        return true;
    }

    private void mandatoryReduction(float[] destroyRecommendations) {
        boolean criticalIsBetter;
        List<DynamicMethodWorker> critical = this.trimReductionOptions(ResourceManager.getCriticalDynamicResources(), destroyRecommendations);
        List<DynamicMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations);
        ReductionOption criticalSolution = this.getBestDestruction(critical, destroyRecommendations);
        ReductionOption nonCriticalSolution = this.getBestDestruction(nonCritical, destroyRecommendations);
        if (criticalSolution == null) {
            if (nonCriticalSolution == null) {
                return;
            }
            criticalIsBetter = false;
        } else if (nonCriticalSolution == null) {
            criticalIsBetter = true;
        } else {
            criticalIsBetter = false;
            if (nonCriticalSolution.getUndesiredCEsAffected() == criticalSolution.getUndesiredCEsAffected()) {
                if (nonCriticalSolution.getUndesiredSlotsAffected() == criticalSolution.getUndesiredSlotsAffected()) {
                    if (nonCriticalSolution.getDesiredSlotsAffected() < criticalSolution.getDesiredSlotsAffected()) {
                        criticalIsBetter = true;
                    }
                } else if (nonCriticalSolution.getUndesiredSlotsAffected() > criticalSolution.getUndesiredSlotsAffected()) {
                    criticalIsBetter = true;
                }
            } else if (nonCriticalSolution.getUndesiredCEsAffected() > criticalSolution.getUndesiredCEsAffected()) {
                criticalIsBetter = true;
            }
        }
        if (criticalIsBetter) {
            criticalSolution.apply();
        } else {
            if (nonCriticalSolution == null) {
                return;
            }
            nonCriticalSolution.apply();
        }
    }

    private List<DynamicMethodWorker> trimReductionOptions(Collection<DynamicMethodWorker> options, float[] recommendations) {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] * Trimming reduction options");
        }
        LinkedList<DynamicMethodWorker> resources = new LinkedList<DynamicMethodWorker>();
        for (DynamicMethodWorker resource : options) {
            boolean add;
            boolean aggressive = false;
            boolean bl = add = !aggressive;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("\t Evaluating " + resource.getName() + ". Default reduction is " + add);
            }
            List<Integer> executableCores = resource.getExecutableCores();
            for (int coreId : executableCores) {
                if (!aggressive && recommendations[coreId] < 1.0f) {
                    if (DEBUG) {
                        RUNTIME_LOGGER.debug("\t\tVM not removed because of not agressive and recomendations < 1 (" + recommendations[coreId] + ")");
                    }
                    add = false;
                    break;
                }
                if (!aggressive || !(recommendations[coreId] > 0.0f)) continue;
                if (DEBUG) {
                    RUNTIME_LOGGER.debug("\t\tVM removed because of agressive and recomendations > 0 (" + recommendations[coreId] + ")");
                }
                add = true;
                break;
            }
            if (!add) continue;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("\t\tVM added to candidate to remove.");
            }
            resources.add(resource);
        }
        return resources;
    }

    private static ResourceCreationRequest requestOneCreation(PriorityQueue<ValueResourceDescription> pq, boolean include) {
        ValueResourceDescription v;
        while ((v = pq.poll()) != null) {
            ResourceCreationRequest rcr = ResourceOptimizer.askForResources(v.value < 1.0f ? 1 : (int)v.value, v.constraints, include);
            if (rcr == null) continue;
            rcr.print(RESOURCES_LOGGER, DEBUG);
            return rcr;
        }
        return null;
    }

    private List<Integer> checkNeededMachines(int noResourceCount, int[] noResourceCountPerCore, int[] slotCountPerCore) {
        LinkedList<Integer> needed = new LinkedList<Integer>();
        if (noResourceCount == 0) {
            return needed;
        }
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            if (noResourceCountPerCore[i] <= 0 || slotCountPerCore[i] != 0) continue;
            needed.add(i);
        }
        return needed;
    }

    private float[] recommendCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long totalTime;
            long embraceableLoad = totalTime = (long)totalSlots[coreId] * creationTime;
            long remainingLoad = aggregatedMeanCoreTime[coreId] - embraceableLoad;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] * Calculating increase recomendations");
                RUNTIME_LOGGER.debug("\tRemaining load = " + aggregatedMeanCoreTime[coreId] + "-( " + totalSlots[coreId] + " * " + creationTime + " ) = " + remainingLoad);
            }
            if (remainingLoad > 0L) {
                creations[coreId] = (int)(remainingLoad / creationTime);
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("\tRecomended slots = " + creations[coreId] + " ( " + remainingLoad + " / " + creationTime + " )");
                continue;
            }
            creations[coreId] = 0.0f;
        }
        return creations;
    }

    private float[] orderCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        int maxI = 0;
        float maxRatio = 0.0f;
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            float ratio;
            if (aggregatedMeanCoreTime[i] <= 0L || totalSlots[i] <= 0 || !((ratio = (float)(aggregatedMeanCoreTime[i] / (long)totalSlots[i])) > maxRatio)) continue;
            maxI = i;
            maxRatio = ratio;
        }
        creations[maxI] = 1.0f;
        return creations;
    }

    private float[] deleteRecommendations(int coreCount, long limitTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] * Delete Recomendations calculations:\n\tcoreCount: " + coreCount + " limitTime: " + limitTime);
        }
        float[] destructions = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long embraceableLoad = limitTime * (long)realSlots[coreId];
            if (embraceableLoad == 0L) {
                destructions[coreId] = 0.0f;
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad);
                RUNTIME_LOGGER.debug("\tdestructions [ " + coreId + "] = 0");
                continue;
            }
            if (aggregatedMinCoreTime[coreId] > 0L) {
                double unusedTime = (double)embraceableLoad / 2.0 - (double)aggregatedMeanCoreTime[coreId];
                destructions[coreId] = (float)(unusedTime / (double)limitTime);
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad);
                RUNTIME_LOGGER.debug("\tunused [ " + coreId + "] =  ( " + embraceableLoad + " / 2) - " + aggregatedMeanCoreTime[coreId] + " = " + unusedTime);
                RUNTIME_LOGGER.debug("\tdestructions [ " + coreId + "] = " + destructions[coreId]);
                continue;
            }
            destructions[coreId] = embraceableLoad / limitTime;
        }
        return destructions;
    }

    public ResourceCreationRequest askForResources(CloudProvider cp, String instanceName, String imageName) {
        CloudMethodResourceDescription constraints = cp.getResourceDescription(instanceName, imageName);
        if (constraints == null) {
            RUNTIME_LOGGER.warn(WARN_EXCEPTION_TURN_ON);
            return null;
        }
        return cp.requestResourceCreation(constraints, null);
    }

    public static ResourceCreationRequest askForResources(MethodResourceDescription requirements, boolean contained) {
        return ResourceOptimizer.askForResources(1, requirements, contained);
    }

    public static ResourceCreationRequest askForResources(Integer amount, MethodResourceDescription requirements, boolean contained) {
        CloudProvider bestProvider = null;
        CloudMethodResourceDescription bestConstraints = null;
        Float bestValue = Float.valueOf(Float.MAX_VALUE);
        for (CloudProvider cp : ResourceManager.getAvailableCloudProviders()) {
            CloudMethodResourceDescription rc = ResourceOptimizer.getBestIncreaseOnProvider(cp, amount, requirements, contained);
            if (rc != null && rc.getValue().floatValue() < bestValue.floatValue()) {
                bestProvider = cp;
                bestConstraints = rc;
                bestValue = rc.getValue();
                continue;
            }
            if (rc != null && bestConstraints == null) {
                bestProvider = cp;
                bestConstraints = rc;
                bestValue = rc.getValue();
                continue;
            }
            RUNTIME_LOGGER.warn("WARN: Cloud Provider cannot increase resources (" + cp.getName() + ")");
        }
        if (bestConstraints == null) {
            RUNTIME_LOGGER.warn(WARN_NO_RESOURCE_MATCHES);
            return null;
        }
        return bestProvider.requestResourceCreation(bestConstraints, null);
    }

    public static CloudMethodResourceDescription getBestIncreaseOnProvider(CloudProvider cp, Integer amount, MethodResourceDescription requirements, boolean contained) {
        RUNTIME_LOGGER.debug("[Resource Optimizer] Getting best increase in provider " + cp.getName());
        if (!cp.canHostMoreInstances()) {
            RUNTIME_LOGGER.warn(WARN_NO_MORE_INSTANCES);
            return null;
        }
        List<CloudInstanceTypeDescription> instances = cp.getCompatibleTypes(requirements);
        RUNTIME_LOGGER.debug("[Resource Optimizer] There are " + instances.size() + " instances compatible.");
        if (instances.isEmpty()) {
            RUNTIME_LOGGER.warn(WARN_NO_COMPATIBLE_TYPE);
            return null;
        }
        CloudMethodResourceDescription result = null;
        CloudInstanceTypeDescription type = null;
        type = contained ? ResourceOptimizer.selectContainedInstance(instances, requirements, amount) : ResourceOptimizer.selectContainingInstance(instances, requirements, amount);
        if (type != null) {
            List<CloudImageDescription> images = cp.getCompatibleImages(requirements);
            RUNTIME_LOGGER.debug("[Resource Optimizer] There are " + images.size() + " images compatible.");
            if (!images.isEmpty()) {
                CloudImageDescription image = images.get(0);
                result = new CloudMethodResourceDescription(type, image);
                result.setValue(cp.getInstanceCostPerHour(result));
            } else {
                RUNTIME_LOGGER.warn(WARN_NO_COMPATIBLE_IMAGE);
            }
        } else {
            RUNTIME_LOGGER.warn(WARN_NO_VALID_INSTANCE);
        }
        return result;
    }

    private static CloudInstanceTypeDescription selectContainingInstance(List<CloudInstanceTypeDescription> instances, MethodResourceDescription constraints, int amount) {
        CloudInstanceTypeDescription result = null;
        MethodResourceDescription bestDescription = null;
        float bestDistance = -2.1474836E9f;
        for (CloudInstanceTypeDescription type : instances) {
            MethodResourceDescription rd = type.getResourceDescription();
            int slots = rd.canHostSimultaneously(constraints);
            float distance = slots - amount;
            RUNTIME_LOGGER.debug("[Resource Optimizer] Can host: slots = " + slots + " amount = " + amount + " distance = " + distance + " bestDistance = " + bestDistance);
            if ((double)distance > 0.0) continue;
            if (distance > bestDistance) {
                result = type;
                bestDescription = type.getResourceDescription();
                bestDistance = distance;
                continue;
            }
            if (distance != bestDistance || bestDescription == null || bestDescription.getValue() == null || rd.getValue() == null || !(bestDescription.getValue().floatValue() > rd.getValue().floatValue())) continue;
            result = type;
            bestDescription = type.getResourceDescription();
            bestDistance = distance;
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private static CloudInstanceTypeDescription selectContainedInstance(List<CloudInstanceTypeDescription> instances, MethodResourceDescription constraints, int amount) {
        CloudInstanceTypeDescription bestType = null;
        MethodResourceDescription bestDescription = null;
        float bestDistance = 2.1474836E9f;
        for (CloudInstanceTypeDescription type : instances) {
            MethodResourceDescription rd = type.getResourceDescription();
            int slots = rd.canHostSimultaneously(constraints);
            float distance = slots - amount;
            RUNTIME_LOGGER.debug("[Resource Optimizer] Can host: slots = " + slots + " amount = " + amount + " distance = " + distance + " bestDistance = " + bestDistance);
            if ((double)distance < 0.0) continue;
            if (distance < bestDistance) {
                bestType = type;
                bestDescription = type.getResourceDescription();
                bestDistance = distance;
                continue;
            }
            if (distance != bestDistance || bestDescription == null || bestDescription.getValue() == null || rd.getValue() == null || !(bestDescription.getValue().floatValue() > rd.getValue().floatValue())) continue;
            bestType = type;
            bestDescription = type.getResourceDescription();
            bestDistance = distance;
        }
        if (bestType == null) {
            return null;
        }
        return bestType;
    }

    private ReductionOption getBestDestruction(Collection<DynamicMethodWorker> resourceSet, float[] destroyRecommendations) {
        float bestUndesiredCEs = Float.MAX_VALUE;
        float bestUndesiredSlots = Float.MAX_VALUE;
        float bestDesiredSlots = Float.MAX_VALUE;
        ReductionOption bestOption = null;
        for (DynamicMethodWorker res : resourceSet) {
            List<ReductionOption> reductions = this.getPossibleReductions(res, destroyRecommendations);
            for (ReductionOption option : reductions) {
                if (DEBUG) {
                    RUNTIME_LOGGER.debug("Type: " + option.getName() + " value 0: " + option.getUndesiredCEsAffected() + " (" + bestUndesiredCEs + ")  value 1: " + option.getUndesiredSlotsAffected() + " (" + bestUndesiredSlots + ")  value 2: " + option.getDesiredSlotsAffected() + " (" + bestDesiredSlots + ")");
                }
                if (bestUndesiredCEs == option.getUndesiredCEsAffected()) {
                    if (bestUndesiredSlots == option.getUndesiredSlotsAffected()) {
                        if (!(bestDesiredSlots < option.getDesiredSlotsAffected())) continue;
                        bestOption = option;
                        continue;
                    }
                    if (!(bestUndesiredSlots > option.getUndesiredSlotsAffected())) continue;
                    bestOption = option;
                    continue;
                }
                if (!(bestUndesiredCEs > option.getUndesiredCEsAffected())) continue;
                bestOption = option;
            }
        }
        if (bestOption != null) {
            return bestOption;
        }
        RUNTIME_LOGGER.warn("Best resource to remove not found");
        return null;
    }

    private List<ReductionOption> getPossibleReductions(DynamicMethodWorker res, float[] recommendedSlots) {
        LinkedList<ReductionOption> reductions = new LinkedList<ReductionOption>();
        MethodResourceDescription description = res.getDescription();
        if (res instanceof CloudMethodWorker) {
            List<CloudInstanceTypeDescription> types = ((CloudMethodResourceDescription)description).getPossibleReductions();
            for (CloudInstanceTypeDescription type : types) {
                CloudReductionOption option = new CloudReductionOption(type, res);
                int[] reducedSlots = type.getSlotsCore();
                for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                    if (!res.canRun(coreId)) continue;
                    if (recommendedSlots[coreId] < 1.0f && reducedSlots[coreId] > 0) {
                        option.undesiredCEAffected();
                        option.undesiredSlotsAffected(reducedSlots[coreId]);
                        continue;
                    }
                    float dif = (float)reducedSlots[coreId] - recommendedSlots[coreId];
                    if (dif < 0.0f) {
                        option.desiredSlotsAffected(reducedSlots[coreId]);
                        continue;
                    }
                    option.desiredSlotsAffected(recommendedSlots[coreId]);
                    option.undesiredSlotsAffected(dif);
                }
                reductions.add(option);
            }
        } else {
            ReductionOption option = new ReductionOption(res);
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                int[] reducedSlots = res.getSimultaneousTasks();
                if (reducedSlots[coreId] <= 0) continue;
                if (recommendedSlots[coreId] < 1.0f && reducedSlots[coreId] > 0) {
                    option.undesiredCEAffected();
                    option.undesiredSlotsAffected(reducedSlots[coreId]);
                    continue;
                }
                float dif = (float)reducedSlots[coreId] - recommendedSlots[coreId];
                if (dif < 0.0f) {
                    option.desiredSlotsAffected(reducedSlots[coreId]);
                    continue;
                }
                option.desiredSlotsAffected(recommendedSlots[coreId]);
                option.undesiredSlotsAffected(dif);
            }
            reductions.add(option);
        }
        return reductions;
    }

    private static class ValueResourceDescription
    implements Comparable<ValueResourceDescription> {
        private final MethodResourceDescription constraints;
        private final float value;
        private final boolean prioritary;

        public ValueResourceDescription(MethodResourceDescription constraints, float value, boolean prioritary) {
            this.constraints = constraints;
            this.value = value;
            this.prioritary = prioritary;
        }

        @Override
        public int compareTo(ValueResourceDescription o) {
            if (this.prioritary && !o.prioritary) {
                return 1;
            }
            if (!this.prioritary && o.prioritary) {
                return -1;
            }
            float dif = this.value - o.value;
            if (dif > 0.0f) {
                return 1;
            }
            if (dif < 0.0f) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.value + (this.prioritary ? "!" : "") + this.constraints;
        }
    }

    private static class ConstraintsCore {
        private CloudMethodResourceDescription desc;
        private List<ConstraintsCore>[] cores;

        public ConstraintsCore(CloudMethodResourceDescription desc, int core, List<ConstraintsCore> coreList) {
            this.desc = desc;
            this.cores = new LinkedList[CoreManager.getCoreCount()];
            this.cores[core] = coreList;
        }

        public void join(ConstraintsCore c2) {
            this.desc.increase(c2.desc);
            c2.desc = this.desc;
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] != null) {
                    if (c2.cores[coreId] != null) {
                        this.cores[coreId].remove(c2);
                        continue;
                    }
                    c2.cores[coreId] = this.cores[coreId];
                    continue;
                }
                this.cores[coreId] = c2.cores[coreId];
            }
        }

        public void confirmed() {
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] == null) continue;
                this.cores[coreId].clear();
            }
        }

        public String toString() {
            LinkedList<Integer> cores = new LinkedList<Integer>();
            for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
                if (this.cores[i] == null) continue;
                cores.add(i);
            }
            return this.desc.toString() + " meets constraints for cores " + cores;
        }
    }

    protected class CloudTypeProfile {
        private Profile[][] implProfiles;

        public CloudTypeProfile(JSONObject typeJSON, JSONObject implsJSON) {
            this.implProfiles = this.loadProfiles(typeJSON, implsJSON);
        }

        public Profile getImplProfiles(int coreId, int implId) {
            return this.implProfiles[coreId][implId];
        }

        private final Profile[][] loadProfiles(JSONObject resMap, JSONObject implMap) {
            int coreCount = CoreManager.getCoreCount();
            Profile[][] profiles = new Profile[coreCount][];
            for (CoreElement ce : CoreManager.getAllCores()) {
                int coreId = ce.getCoreId();
                List<Implementation> impls = ce.getImplementations();
                int implCount = impls.size();
                profiles[coreId] = new Profile[implCount];
                for (Implementation impl : impls) {
                    String signature = impl.getSignature();
                    JSONObject jsonImpl = null;
                    if (resMap != null) {
                        try {
                            jsonImpl = resMap.getJSONObject(signature);
                            profiles[coreId][impl.getImplementationId().intValue()] = this.generateProfileForImplementation(impl, jsonImpl);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (profiles[coreId][impl.getImplementationId()] != null) continue;
                    if (implMap != null) {
                        try {
                            jsonImpl = implMap.getJSONObject(signature);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    profiles[coreId][impl.getImplementationId().intValue()] = this.generateProfileForImplementation(impl, jsonImpl);
                    profiles[coreId][impl.getImplementationId()].clearExecutionCount();
                }
            }
            return profiles;
        }

        protected Profile generateProfileForImplementation(Implementation impl, JSONObject jsonImpl) {
            return new Profile(jsonImpl);
        }
    }

    private class CloudReductionOption
    extends ReductionOption {
        private final CloudInstanceTypeDescription type;

        public CloudReductionOption(CloudInstanceTypeDescription type, Resource res) {
            super(res);
            this.type = type;
        }

        @Override
        public String getName() {
            return this.type.getName() + "@" + super.getName();
        }

        @Override
        public void apply() {
            CloudMethodWorker res = (CloudMethodWorker)this.getResource();
            CloudMethodResourceDescription cmrd = res.getDescription();
            CloudImageDescription cid = cmrd.getImage();
            CloudMethodResourceDescription finalDescription = new CloudMethodResourceDescription(this.type, cid);
            finalDescription.setName(res.getName());
            ResourceManager.requestWorkerReduction(res, finalDescription);
        }
    }

    private class ReductionOption {
        private final Resource res;
        private float undesiredCEsAffected = 0.0f;
        private float undesiredSlotsAffected = 0.0f;
        private float desiredSlotsAffected = 0.0f;

        public ReductionOption(Resource res) {
            this.res = res;
        }

        public void undesiredCEAffected() {
            this.undesiredCEsAffected += 1.0f;
        }

        public void undesiredSlotsAffected(float slots) {
            this.undesiredSlotsAffected += slots;
        }

        public void desiredSlotsAffected(float slots) {
            this.desiredSlotsAffected += slots;
        }

        public float getUndesiredCEsAffected() {
            return this.undesiredCEsAffected;
        }

        public float getUndesiredSlotsAffected() {
            return this.undesiredSlotsAffected;
        }

        public float getDesiredSlotsAffected() {
            return this.desiredSlotsAffected;
        }

        public String getName() {
            return this.res.getName();
        }

        public void apply() {
            ResourceManager.requestWholeWorkerReduction((DynamicMethodWorker)this.res);
        }

        public Resource getResource() {
            return this.res;
        }
    }
}

