/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.InvalidSchedulingException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.scheduler.types.WorkloadState;
import es.bsc.compss.scheduler.types.allocatableactions.BusyWorkerAction;
import es.bsc.compss.scheduler.types.allocatableactions.ReduceWorkerAction;
import es.bsc.compss.scheduler.types.allocatableactions.StartWorkerAction;
import es.bsc.compss.scheduler.types.allocatableactions.StopWorkerAction;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.updates.IdleResources;
import es.bsc.compss.types.resources.updates.PerformedReduction;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.ActionSet;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ExternalAdaptationManager;
import es.bsc.compss.util.JSONStateManager;
import es.bsc.compss.util.ResourceOptimizer;
import es.bsc.compss.util.SchedulingOptimizer;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class TaskScheduler {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private ActionOrchestrator orchestrator;
    protected final WorkersMap workers;
    private final ActionSet blockedActions;
    private int[] readyCounts;
    private final ResourceOptimizer ro;
    private final SchedulingOptimizer<TaskScheduler> so;
    private final boolean externalAdaptation;
    private final ExternalAdaptationManager extAdaptationManager;
    protected final JSONStateManager jsm;
    private Map<Integer, LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>> distributedTasksResources;
    private Profile[][] offVMsProfiles;
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();

    public TaskScheduler() {
        String enableAdaptStr = System.getProperty("compss.external.adaptation");
        this.externalAdaptation = enableAdaptStr != null && !enableAdaptStr.isEmpty() ? Boolean.parseBoolean(enableAdaptStr) : false;
        this.workers = new WorkersMap();
        this.jsm = new JSONStateManager();
        this.blockedActions = new ActionSet();
        int coreCount = CoreManager.getCoreCount();
        this.readyCounts = new int[coreCount];
        this.offVMsProfiles = new Profile[coreCount][];
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            int implCount = ce.getImplementationsCount();
            Profile[] implProfiles = new Profile[implCount];
            for (Implementation impl : ce.getImplementations()) {
                int implId = impl.getImplementationId();
                implProfiles[implId] = this.generateProfile(null);
            }
            this.offVMsProfiles[coreId] = implProfiles;
        }
        this.distributedTasksResources = new HashMap<Integer, LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>>();
        this.so = this.generateSchedulingOptimizer();
        this.so.start();
        this.ro = this.generateResourceOptimizer();
        this.ro.start();
        if (this.externalAdaptation) {
            this.extAdaptationManager = this.generateExternalAdaptationManager();
            this.extAdaptationManager.start();
        } else {
            this.extAdaptationManager = null;
        }
    }

    public final void setOrchestrator(ActionOrchestrator orchestrator) {
        this.orchestrator = orchestrator;
    }

    public final ActionOrchestrator getOrchestrator() {
        return this.orchestrator;
    }

    public final void shutdown() {
        this.customSchedulerShutdown();
        this.ro.shutdown();
        this.so.shutdown();
        if (this.externalAdaptation) {
            this.extAdaptationManager.shutdown();
        }
        try {
            this.updateState();
            this.jsm.write();
        }
        catch (Exception e) {
            LOGGER.error(e);
        }
    }

    protected void customSchedulerShutdown() {
    }

    public ResourceOptimizer generateResourceOptimizer() {
        return new ResourceOptimizer(this);
    }

    public ExternalAdaptationManager generateExternalAdaptationManager() {
        return new ExternalAdaptationManager();
    }

    public <T extends TaskScheduler> SchedulingOptimizer<T> generateSchedulingOptimizer() {
        return new SchedulingOptimizer<TaskScheduler>(this);
    }

    public Profile generateProfile(JSONObject json) {
        return new Profile(json);
    }

    public <T extends WorkerResourceDescription> ResourceScheduler<T> generateSchedulerForResource(Worker<T> w, JSONObject defaultResources, JSONObject defaultImplementations) {
        return new ResourceScheduler<T>(w, defaultResources, defaultImplementations);
    }

    public <T extends WorkerResourceDescription> SchedulingInformation generateSchedulingInformation(ResourceScheduler<T> rs, List<Parameter> params, Integer coreId) {
        return new SchedulingInformation(rs);
    }

    public Score generateActionScore(AllocatableAction action) {
        return new Score(action.getPriority(), action.getGroupPriority(), 0L, 0L, 0L);
    }

    public final void coreElementsUpdated() {
        int coreId;
        LOGGER.info("[TaskScheduler] Update core elements");
        int newCoreCount = CoreManager.getCoreCount();
        int oldCoreCount = this.offVMsProfiles.length;
        SchedulingInformation.updateCoreCount(newCoreCount);
        this.blockedActions.updateCoreCount(newCoreCount);
        int[] readyCounts = new int[newCoreCount];
        System.arraycopy(this.readyCounts, 0, readyCounts, 0, oldCoreCount);
        this.readyCounts = readyCounts;
        Profile[][] offVMsProfiles = new Profile[newCoreCount][];
        for (coreId = 0; coreId < oldCoreCount; ++coreId) {
            int oldImplCount = this.offVMsProfiles[coreId].length;
            CoreElement ce = CoreManager.getCore(coreId);
            int implCount = ce.getImplementationsCount();
            if (oldImplCount != implCount) {
                Profile[] implProfiles = new Profile[implCount];
                System.arraycopy(this.offVMsProfiles[coreId], 0, implProfiles, 0, oldImplCount);
                for (int implId = oldImplCount; implId < implCount; ++implId) {
                    implProfiles[implId] = this.generateProfile(null);
                }
                offVMsProfiles[coreId] = implProfiles;
                continue;
            }
            offVMsProfiles[coreId] = this.offVMsProfiles[coreId];
        }
        while (coreId < newCoreCount) {
            CoreElement ce = CoreManager.getCore(coreId);
            int implCount = ce.getImplementationsCount();
            Profile[] implProfiles = new Profile[implCount];
            for (int implId = 0; implId < implCount; ++implId) {
                implProfiles[implId] = this.generateProfile(null);
            }
            offVMsProfiles[coreId] = implProfiles;
            ++coreId;
        }
        this.offVMsProfiles = offVMsProfiles;
        for (ResourceScheduler rs : this.workers.values()) {
            rs.updatedCoreElements(newCoreCount, this.jsm.getJSONForResource(rs.getResource()));
            SchedulingInformation.changesOnWorker(rs);
        }
        this.ro.coreElementsUpdated();
        this.customCoreElementsUpdated();
    }

    public void customCoreElementsUpdated() {
    }

    protected void addToReady(AllocatableAction action) {
        LOGGER.debug("[TaskScheduler] Add action " + action + " to ready count");
        Integer coreId = action.getCoreId();
        if (coreId != null) {
            if (Tracer.isActivated()) {
                Tracer.emitEvent(TraceEvent.READY_COUNT);
            }
            int n = coreId;
            this.readyCounts[n] = this.readyCounts[n] + 1;
        }
    }

    protected void removeFromReady(AllocatableAction action) {
        Integer coreId;
        LOGGER.info("[TaskScheduler] Remove action " + action + " from ready count");
        if (action.getImplementations() != null && action.getImplementations().length > 0 && (coreId = action.getImplementations()[0].getCoreId()) != null) {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.READY_COUNT);
            }
            int n = coreId;
            this.readyCounts[n] = this.readyCounts[n] - 1;
        }
    }

    public void addToBlocked(AllocatableAction action) {
        LOGGER.warn("[TaskScheduler] Blocked Action: " + action);
        this.blockedActions.addAction(action);
    }

    public void newAllocatableAction(AllocatableAction action) {
        LOGGER.info("[TaskScheduler] Registering new AllocatableAction " + action);
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            this.addToReady(action);
        }
        Score actionScore = this.generateActionScore(action);
        try {
            this.scheduleAction(action, actionScore);
            this.tryToLaunch(action);
        }
        catch (BlockedActionException bae) {
            if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
                this.removeFromReady(action);
            }
            this.addToBlocked(action);
        }
    }

    public final void cancelAllocatableAction(AllocatableAction action) {
        action.cancel();
    }

    public final void actionRunning(AllocatableAction action) {
        LOGGER.info("[TaskScheduler] Action running " + action);
        List<AllocatableAction> freeActions = action.executionStarted();
        if (freeActions != null && freeActions.size() > 0) {
            for (AllocatableAction fAction : freeActions) {
                this.addToReady(fAction);
            }
            LinkedList<AllocatableAction> blockedCandidates = new LinkedList<AllocatableAction>();
            this.handleDependencyFreeActions(freeActions, new LinkedList<AllocatableAction>(), blockedCandidates, action.getAssignedResource());
            for (AllocatableAction aa : blockedCandidates) {
                if (!aa.hasDataPredecessors() && !aa.hasStreamProducers()) {
                    this.removeFromReady(aa);
                }
                this.addToBlocked(aa);
            }
        }
    }

    public final void actionCompleted(AllocatableAction action) {
        List<AllocatableAction> resourceFree;
        LOGGER.info("[TaskScheduler] Action completed " + action);
        this.removeFromReady(action);
        ResourceScheduler<? extends WorkerResourceDescription> resource = action.getAssignedResource();
        try {
            resourceFree = resource.unscheduleAction(action);
        }
        catch (ActionNotFoundException ex) {
            resourceFree = new LinkedList<AllocatableAction>();
        }
        action.relaseResourcesAndLaunchBlockedActions();
        this.workerLoadUpdate(resource);
        List<AllocatableAction> dataFreeActions = action.completed();
        for (AllocatableAction dataFreeAction : dataFreeActions) {
            this.addToReady(dataFreeAction);
        }
        LinkedList<AllocatableAction> blockedCandidates = new LinkedList<AllocatableAction>();
        this.handleDependencyFreeActions(dataFreeActions, resourceFree, blockedCandidates, resource);
        for (AllocatableAction aa : blockedCandidates) {
            if (!aa.hasDataPredecessors() && !aa.hasStreamProducers()) {
                this.removeFromReady(aa);
            }
            this.addToBlocked(aa);
        }
    }

    public final void exceptionOnAction(AllocatableAction action, COMPSsException e) {
        List<AllocatableAction> resourceFree;
        LOGGER.info("[TaskScheduler] Exception on action " + action);
        this.removeFromReady(action);
        ResourceScheduler<? extends WorkerResourceDescription> resource = action.getAssignedResource();
        try {
            resourceFree = resource.unscheduleAction(action);
        }
        catch (ActionNotFoundException ex) {
            resourceFree = new LinkedList<AllocatableAction>();
        }
        List<AllocatableAction> dataFreeActions = action.exception(e);
        for (AllocatableAction dataFreeAction : dataFreeActions) {
            this.addToReady(dataFreeAction);
        }
        this.workerLoadUpdate(resource);
        LinkedList<AllocatableAction> blockedCandidates = new LinkedList<AllocatableAction>();
        this.handleDependencyFreeActions(dataFreeActions, resourceFree, blockedCandidates, resource);
        for (AllocatableAction aa : blockedCandidates) {
            if (!aa.hasDataPredecessors() && !aa.hasStreamProducers()) {
                this.removeFromReady(aa);
            }
            this.addToBlocked(aa);
        }
    }

    public final void errorOnAction(AllocatableAction action) {
        LOGGER.warn("[TaskScheduler] Error on action " + action);
        LinkedList<AllocatableAction> resourceFree = new LinkedList<AllocatableAction>();
        List<Object> dataFreeActions = new LinkedList();
        ResourceScheduler<? extends WorkerResourceDescription> resource = action.getAssignedResource();
        boolean failed = false;
        try {
            if (action.isCancelling()) {
                action.cancel();
            } else {
                action.error();
            }
        }
        catch (FailedActionException fae) {
            failed = true;
            this.removeFromReady(action);
            if (action.getOnFailure() != OnFailure.IGNORE) {
                for (AllocatableAction allocatableAction : action.failed()) {
                    try {
                        ResourceScheduler<? extends WorkerResourceDescription> failedResource = allocatableAction.getAssignedResource();
                        if (failedResource == null) continue;
                        resourceFree.addAll(failedResource.unscheduleAction(allocatableAction));
                    }
                    catch (ActionNotFoundException actionNotFoundException) {}
                }
            } else {
                dataFreeActions = action.ignoredFailure();
                for (AllocatableAction allocatableAction : dataFreeActions) {
                    this.addToReady(allocatableAction);
                }
            }
        }
        try {
            resourceFree.addAll(resource.unscheduleAction(action));
        }
        catch (ActionNotFoundException fae) {
            // empty catch block
        }
        this.workerLoadUpdate(resource);
        if (action.getOnFailure() == OnFailure.RETRY && !failed) {
            if (DEBUG) {
                LOGGER.debug("Adding action " + action + " to data Free actions.");
            }
            dataFreeActions.add(action);
        }
        LinkedList<AllocatableAction> blockedCandidates = new LinkedList<AllocatableAction>();
        if (action.getOnFailure() != OnFailure.CANCEL_SUCCESSORS && !action.isCancelled()) {
            this.handleDependencyFreeActions(dataFreeActions, resourceFree, blockedCandidates, resource);
            for (AllocatableAction allocatableAction : blockedCandidates) {
                if (!allocatableAction.hasDataPredecessors() && !allocatableAction.hasStreamProducers()) {
                    this.removeFromReady(allocatableAction);
                }
                this.addToBlocked(allocatableAction);
            }
        }
    }

    protected final void tryToLaunch(AllocatableAction action) {
        try {
            LOGGER.debug("[TaskScheduler] Trying to launch " + action);
            action.tryToLaunch();
        }
        catch (InvalidSchedulingException ise) {
            LinkedList<AllocatableAction> resourceFree = new LinkedList<AllocatableAction>();
            ResourceScheduler<? extends WorkerResourceDescription> resource = action.getAssignedResource();
            try {
                resourceFree.addAll(resource.unscheduleAction(action));
            }
            catch (ActionNotFoundException actionNotFoundException) {
                // empty catch block
            }
            Score actionScore = this.generateActionScore(action);
            try {
                this.scheduleAction(action, actionScore);
            }
            catch (BlockedActionException bae) {
                this.addToBlocked(action);
            }
        }
    }

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        LOGGER.debug("[TaskScheduler] Schedule action " + action);
        try {
            action.schedule(actionScore);
        }
        catch (UnassignedActionException ure) {
            this.lostAllocatableAction(action);
        }
    }

    protected <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        ObjectValue<AllocatableAction> obj;
        Score actionScore;
        LOGGER.debug("[TaskScheduler] Handling dependency free actions on resource " + resource.getName());
        PriorityQueue<ObjectValue<AllocatableAction>> executableActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction freeAction : dataFreeActions) {
            actionScore = this.generateActionScore(freeAction);
            obj = new ObjectValue<AllocatableAction>(freeAction, actionScore);
            executableActions.add(obj);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            obj = new ObjectValue<AllocatableAction>(freeAction, actionScore = this.generateActionScore(freeAction));
            if (executableActions.contains(obj)) continue;
            executableActions.add(obj);
        }
        while (!executableActions.isEmpty()) {
            ObjectValue obj2 = (ObjectValue)executableActions.poll();
            Score score = obj2.getScore();
            AllocatableAction freeAction = (AllocatableAction)obj2.getObject();
            if (freeAction.getAssignedResource() != null) {
                if (freeAction.getAssignedImplementation() != null) {
                    this.tryToLaunch(freeAction);
                    continue;
                }
                try {
                    freeAction.schedule(freeAction.getAssignedResource(), score);
                }
                catch (UnassignedActionException uae) {
                    if (freeAction.getCompatibleWorkers().isEmpty()) {
                        this.addToBlocked(freeAction);
                        continue;
                    }
                    this.lostAllocatableAction(freeAction);
                }
                continue;
            }
            List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleWorkers = freeAction.getCompatibleWorkers();
            if (compatibleWorkers.isEmpty()) {
                this.addToBlocked(freeAction);
                continue;
            }
            List<ResourceScheduler<? extends WorkerResourceDescription>> hostWorkers = freeAction.getExecutingResources();
            if (hostWorkers.containsAll(compatibleWorkers)) {
                this.addToBlocked(freeAction);
                continue;
            }
            this.lostAllocatableAction(freeAction);
        }
    }

    protected void lostAllocatableAction(AllocatableAction action) {
        StringBuilder info = new StringBuilder("Scheduler has lost track of action ");
        info.append(action.toString());
        ErrorManager.fatal(info.toString());
    }

    protected <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
        LOGGER.info("[TaskScheduler] Update load on worker " + resource.getName());
    }

    public final <T extends WorkerResourceDescription> void updateWorker(Worker<T> worker, ResourceUpdate<T> rs) {
        ResourceScheduler ui = this.workers.get(worker);
        if (ui == null) {
            ui = this.addWorker(worker, this.jsm.getJSONForResource(worker), this.jsm.getJSONForImplementations());
            this.startWorker(ui);
            this.workerDetected(ui);
        }
        if (rs.checkCompleted()) {
            this.completedResourceUpdate(ui, rs);
        } else {
            this.pendingResourceUpdate(ui, rs);
        }
    }

    public final <T extends WorkerResourceDescription> void restartWorker(Worker<T> worker, ResourceUpdate<T> ru) {
        ResourceScheduler rs = this.workers.get(worker);
        this.workerStoppedToBeRestarted(worker, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends WorkerResourceDescription> ResourceScheduler<T> addWorker(Worker<T> worker, JSONObject jsonResource, JSONObject jsonImpls) {
        ResourceScheduler<T> ui = this.generateSchedulerForResource(worker, jsonResource, jsonImpls);
        WorkersMap workersMap = this.workers;
        synchronized (workersMap) {
            this.workers.put(worker, ui);
        }
        return ui;
    }

    private <T extends WorkerResourceDescription> void startWorker(ResourceScheduler<T> ui) {
        StartWorkerAction<T> action = new StartWorkerAction<T>(this.generateSchedulingInformation(ui, null, null), ui, this);
        try {
            action.schedule(ui, (Score)null);
            action.tryToLaunch();
        }
        catch (InvalidSchedulingException | UnassignedActionException e) {
            LOGGER.warn(" StartWorkerAction failed: " + e);
            LOGGER.warn(" Failed ResourceScheduler: " + ui.getName());
        }
    }

    private <T extends WorkerResourceDescription> void pendingResourceUpdate(ResourceScheduler<T> worker, ResourceUpdate<T> modification) {
        switch (modification.getType()) {
            case INCREASE: {
                break;
            }
            case REDUCE: {
                this.reduceWorkerResources(worker, modification);
                break;
            }
            case BUSY: {
                this.busyWorkerResources(worker, modification);
                break;
            }
        }
    }

    private <T extends WorkerResourceDescription> void reduceWorkerResources(ResourceScheduler<T> worker, ResourceUpdate<T> modification) {
        worker.pendingModification(modification);
        SchedulingInformation schedInfo = this.generateSchedulingInformation(worker, null, null);
        ReduceWorkerAction<T> action = new ReduceWorkerAction<T>(schedInfo, worker, this, modification);
        try {
            action.schedule(worker, (Score)null);
            action.tryToLaunch();
        }
        catch (InvalidSchedulingException | UnassignedActionException e) {
            LOGGER.error(" Error while reducing the worker..");
        }
    }

    private <T extends WorkerResourceDescription> void busyWorkerResources(ResourceScheduler<T> worker, ResourceUpdate<T> modification) {
        SchedulingInformation schedInfo = this.generateSchedulingInformation(worker, null, null);
        BusyWorkerAction<T> action = new BusyWorkerAction<T>(schedInfo, worker, this, modification);
        try {
            action.schedule(worker, (Score)null);
            action.tryToLaunch();
        }
        catch (InvalidSchedulingException | UnassignedActionException e) {
            LOGGER.error(" Error while reserving resources on the worker..");
        }
    }

    private <T extends WorkerResourceDescription> void completedResourceUpdate(ResourceScheduler<T> worker, ResourceUpdate<T> modification) {
        worker.completedModification(modification);
        SchedulingInformation.changesOnWorker(worker);
        switch (modification.getType()) {
            case INCREASE: {
                this.increasedWorkerResources(worker, modification);
                break;
            }
            case REDUCE: {
                this.reducedWorkerResources(worker, (PerformedReduction)modification);
                break;
            }
            case IDLE: {
                this.idleWorkerResources(worker, (IdleResources)modification);
                break;
            }
        }
    }

    private <T extends WorkerResourceDescription> void increasedWorkerResources(ResourceScheduler<T> worker, ResourceUpdate<T> modification) {
        if (!worker.getExecutableCores().isEmpty()) {
            List<AllocatableAction> unblockedActions = this.blockedActions.removeAllCompatibleActions(worker.getResource());
            for (AllocatableAction action : unblockedActions) {
                if (action.hasDataPredecessors() || action.hasStreamProducers()) continue;
                this.addToReady(action);
            }
            LinkedList<AllocatableAction> blockedActions = new LinkedList<AllocatableAction>();
            this.workerFeaturesUpdate(worker, (WorkerResourceDescription)modification.getModification(), unblockedActions, blockedActions);
        }
    }

    private <T extends WorkerResourceDescription> void reducedWorkerResources(ResourceScheduler<T> worker, PerformedReduction<T> modification) {
        LinkedList<AllocatableAction> unblockedActions = new LinkedList<AllocatableAction>();
        LinkedList<AllocatableAction> blockedActions = new LinkedList<AllocatableAction>();
        this.workerFeaturesUpdate(worker, (WorkerResourceDescription)modification.getModification(), unblockedActions, blockedActions);
        for (AllocatableAction action : blockedActions) {
            if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
                this.removeFromReady(action);
            }
            this.addToBlocked(action);
        }
        LOGGER.info("Resources for worker " + worker.getName() + " have been reduced");
        DynamicMethodWorker dynamicWorker = (DynamicMethodWorker)worker.getResource();
        if (dynamicWorker.shouldBeStopped()) {
            AllocatableAction action;
            LOGGER.info("Starting stop process for worker " + worker.getName());
            this.workerStopped(worker);
            action = new StopWorkerAction(this.generateSchedulingInformation(worker, null, null), worker, this, modification);
            try {
                ((StopWorkerAction)action).schedule(worker, (Score)null);
                action.tryToLaunch();
            }
            catch (InvalidSchedulingException | UnassignedActionException e) {
                LOGGER.error("WARN: Stop action has been blocked or unassigned. It should not happen!");
            }
        } else {
            dynamicWorker.destroyResources((WorkerResourceDescription)modification.getModification());
        }
    }

    private <T extends WorkerResourceDescription> void idleWorkerResources(ResourceScheduler<T> worker, IdleResources<T> modification) {
        LOGGER.debug("Releasing idle resources in the worker  " + worker.getName());
        worker.getResource().endTask((WorkerResourceDescription)modification.getModification());
        worker.tryToLaunchBlockedActions();
        this.workerLoadUpdate(worker);
        LinkedList<AllocatableAction> blockedCandidates = new LinkedList<AllocatableAction>();
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        LinkedList<AllocatableAction> resourceFree = new LinkedList<AllocatableAction>();
        this.handleDependencyFreeActions(dataFreeActions, resourceFree, blockedCandidates, worker);
        for (AllocatableAction aa : blockedCandidates) {
            if (!aa.hasDataPredecessors() && !aa.hasStreamProducers()) {
                this.removeFromReady(aa);
            }
            this.addToBlocked(aa);
        }
    }

    private <T extends WorkerResourceDescription> void workerStopped(ResourceScheduler<T> resource) {
        AllocatableAction[] allocatableActionArray;
        ResourceScheduler<T> workerRS = resource;
        Worker<T> workerResource = workerRS.getResource();
        this.workers.remove(workerResource);
        for (CoreElement coreElement : CoreManager.getAllCores()) {
            int coreId = coreElement.getCoreId();
            for (Implementation impl : coreElement.getImplementations()) {
                int implId = impl.getImplementationId();
                LOGGER.debug("Removed Workers profile for CoreId: " + coreId + ", ImplId: " + implId + " before removing:" + this.offVMsProfiles[coreId][implId]);
                Profile p = resource.getProfile(coreId, implId);
                if (p != null) {
                    LOGGER.info(" Accumulating worker profile data for CoreId: " + coreId + ", ImplId: " + implId + " in removed workers profile");
                    this.offVMsProfiles[coreId][implId].accumulate(p);
                }
                LOGGER.debug("Removed Workers profile for CoreId: " + coreId + ", ImplId: " + implId + " after removing:" + this.offVMsProfiles[coreId][implId]);
            }
        }
        ArrayList<AllocatableAction> blockedOnResource = new ArrayList<AllocatableAction>(resource.getBlockedActions());
        for (AllocatableAction action : blockedOnResource) {
            action.abortExecution();
            try {
                resource.unscheduleAction(action);
            }
            catch (ActionNotFoundException ex) {
                continue;
            }
            Score actionScore = this.generateActionScore(action);
            try {
                this.scheduleAction(action, actionScore);
                this.tryToLaunch(action);
            }
            catch (BlockedActionException bae) {
                if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
                    this.removeFromReady(action);
                }
                this.addToBlocked(action);
            }
        }
        for (AllocatableAction action : allocatableActionArray = resource.getHostedActions()) {
            action.abortExecution();
            try {
                resource.unscheduleAction(action);
            }
            catch (ActionNotFoundException ex) {
                continue;
            }
            Score actionScore = this.generateActionScore(action);
            try {
                this.scheduleAction(action, actionScore);
                this.tryToLaunch(action);
            }
            catch (BlockedActionException bae) {
                if (!action.hasDataPredecessors()) {
                    this.removeFromReady(action);
                }
                this.addToBlocked(action);
            }
        }
        resource.setRemoved(true);
        this.workerRemoved(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends WorkerResourceDescription> void workerStoppedToBeRestarted(Worker<T> worker, ResourceScheduler<T> resource) {
        this.removeResource(resource);
        ArrayList<AllocatableAction> blockedOnResource = new ArrayList<AllocatableAction>(resource.getBlockedActions());
        AllocatableAction[] runningOnResource = resource.getHostedActions();
        for (AllocatableAction action : blockedOnResource) {
            action.abortExecution();
            try {
                resource.unscheduleAction(action);
            }
            catch (ActionNotFoundException actionNotFoundException) {}
        }
        for (AllocatableAction allocatableAction : runningOnResource) {
            allocatableAction.abortExecution();
            try {
                resource.unscheduleAction(allocatableAction);
            }
            catch (ActionNotFoundException actionNotFoundException) {
                // empty catch block
            }
        }
        resource.setRemoved(false);
        resource.getResource().startingNode();
        this.startWorker(resource);
        this.workerDetected(resource);
        WorkersMap workersMap = this.workers;
        synchronized (workersMap) {
            this.workers.put(worker, resource);
        }
        for (AllocatableAction action : blockedOnResource) {
            Score actionScore = this.generateActionScore(action);
            try {
                this.scheduleAction(action, actionScore);
                this.tryToLaunch(action);
            }
            catch (BlockedActionException blockedActionException) {
                if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
                    this.removeFromReady(action);
                }
                this.addToBlocked(action);
            }
        }
        for (AllocatableAction allocatableAction : runningOnResource) {
            Score actionScore = this.generateActionScore(allocatableAction);
            try {
                this.scheduleAction(allocatableAction, actionScore);
                this.tryToLaunch(allocatableAction);
            }
            catch (BlockedActionException bae) {
                if (!allocatableAction.hasDataPredecessors()) {
                    this.removeFromReady(allocatableAction);
                }
                this.addToBlocked(allocatableAction);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void workerDetected(ResourceScheduler<T> resource) {
    }

    protected <T extends WorkerResourceDescription> void workerRemoved(ResourceScheduler<T> resource) {
        LOGGER.info("[TaskScheduler] Remove worker " + resource.getName());
    }

    protected <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        LOGGER.info("[TaskScheduler] Updated features on worker " + worker.getName());
        PriorityQueue<ObjectValue<AllocatableAction>> sortedCompatibleActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction action : unblockedActions) {
            ObjectValue<AllocatableAction> obj = new ObjectValue<AllocatableAction>(action, this.generateActionScore(action));
            sortedCompatibleActions.add(obj);
        }
        while (!sortedCompatibleActions.isEmpty()) {
            ObjectValue obj = (ObjectValue)sortedCompatibleActions.poll();
            Score actionScore = obj.getScore();
            AllocatableAction action = (AllocatableAction)obj.getObject();
            if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
                this.addToReady(action);
            }
            try {
                this.scheduleAction(action, actionScore);
                this.tryToLaunch(action);
            }
            catch (BlockedActionException bae) {
                if (!action.hasDataPredecessors()) {
                    this.removeFromReady(action);
                }
                this.addToBlocked(action);
            }
        }
    }

    public final Collection<ResourceScheduler<? extends WorkerResourceDescription>> getWorkers() {
        LOGGER.info("[TaskScheduler] Get all worker resource schedulers");
        return this.workers.values();
    }

    public final List<AllocatableAction> getBlockedActions() {
        LOGGER.info("[TaskScheduler] Get Blocked Actions");
        return this.blockedActions.getAllActions();
    }

    public final int getNumberOfBlockedActions() {
        return this.blockedActions.getNumberTotalActions();
    }

    public final <T extends WorkerResourceDescription> AllocatableAction[] getHostedActions(Worker<T> worker) {
        LOGGER.info("[TaskScheduler] Get Hosted actions on worker " + worker.getName());
        ResourceScheduler ui = this.workers.get(worker);
        if (ui != null) {
            return ui.getHostedActions();
        }
        return new AllocatableAction[0];
    }

    public final <T extends WorkerResourceDescription> PriorityQueue<AllocatableAction> getBlockedActionsOnResource(Worker<T> worker) {
        LOGGER.info("[TaskScheduler] Get Blocked actions on worker " + worker.getName());
        ResourceScheduler ui = this.workers.get(worker);
        if (ui != null) {
            return ui.getBlockedActions();
        }
        return new PriorityQueue<AllocatableAction>();
    }

    public Collection<AllocatableAction> getUnassignedActions() {
        return new LinkedList<AllocatableAction>();
    }

    public void upgradeAction(AllocatableAction action) {
        LOGGER.info("No upgrade required by default for " + action);
    }

    public <T extends WorkerResourceDescription> void removeResource(ResourceScheduler<T> resource) {
        ResourceScheduler<T> workerRS = resource;
        Worker<T> workerResource = workerRS.getResource();
        this.workers.remove(workerResource);
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId = ce.getCoreId();
            for (Implementation impl : ce.getImplementations()) {
                int implId = impl.getImplementationId();
                LOGGER.debug("Removed Workers profile for CoreId: " + coreId + ", ImplId: " + implId + " before removing:" + this.offVMsProfiles[coreId][implId]);
                Profile p = resource.getProfile(coreId, implId);
                if (p != null) {
                    LOGGER.info(" Accumulating worker profile data for CoreId: " + coreId + ", ImplId: " + implId + " in removed workers profile");
                    this.offVMsProfiles[coreId][implId].accumulate(p);
                }
                LOGGER.debug("Removed Workers profile for CoreId: " + coreId + ", ImplId: " + implId + " after removing:" + this.offVMsProfiles[coreId][implId]);
            }
        }
        resource.setRemoved(true);
        this.workerRemoved(resource);
    }

    public final WorkloadState getWorkload() {
        WorkloadState ws = this.generateWorkloadState();
        this.updateWorkloadState(ws);
        return ws;
    }

    protected WorkloadState generateWorkloadState() {
        return new WorkloadState();
    }

    protected void updateWorkloadState(WorkloadState state) {
        LOGGER.info("[TaskScheduler] Get workload state");
        int coreCount = CoreManager.getCoreCount();
        Profile[] coreProfile = new Profile[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            coreProfile[coreId] = new Profile();
        }
        for (ResourceScheduler ui : this.workers.values()) {
            if (ui == null) continue;
            List<Implementation>[] impls = ui.getExecutableImpls();
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                for (Implementation impl : impls[coreId]) {
                    coreProfile[coreId].accumulate(ui.getProfile(impl));
                }
            }
            AllocatableAction[] runningActions = ui.getHostedActions();
            long now = System.currentTimeMillis();
            for (AllocatableAction running : runningActions) {
                Integer coreId;
                if (running.getImplementations().length <= 0 || (coreId = running.getImplementations()[0].getCoreId()) == null) continue;
                state.registerRunning(coreId, now - running.getStartTime());
            }
        }
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            state.registerNoResources(coreId, this.blockedActions.getActionCounts()[coreId]);
            state.registerReady(coreId, this.readyCounts[coreId]);
            state.registerTimes(coreId, coreProfile[coreId].getMinExecutionTime(), coreProfile[coreId].getAverageExecutionTime(), coreProfile[coreId].getMaxExecutionTime());
        }
    }

    public final void getTaskSummary(Logger logger) {
        boolean isPhantomSignature;
        String signature;
        LOGGER.info("[TaskScheduler] Get task summary");
        int coreCount = CoreManager.getCoreCount();
        Profile[] coreGlobalProfiles = new Profile[coreCount];
        for (int i = 0; i < coreCount; ++i) {
            coreGlobalProfiles[i] = new Profile();
        }
        HashMap<String, Profile[]> coreProfilesPerWorker = new HashMap<String, Profile[]>();
        for (ResourceScheduler resourceScheduler : this.workers.values()) {
            if (resourceScheduler == null) continue;
            Profile[] coreProfiles = new Profile[coreCount];
            for (int i = 0; i < coreCount; ++i) {
                coreProfiles[i] = new Profile();
            }
            for (CoreElement ce : CoreManager.getAllCores()) {
                int coreId = ce.getCoreId();
                for (Implementation implementation : ce.getImplementations()) {
                    signature = implementation.getSignature();
                    isPhantomSignature = signature.endsWith(")");
                    if (isPhantomSignature) continue;
                    coreGlobalProfiles[coreId].accumulate(resourceScheduler.getProfile(implementation));
                    coreProfiles[coreId].accumulate(resourceScheduler.getProfile(implementation));
                }
            }
            coreProfilesPerWorker.put(resourceScheduler.getName(), coreProfiles);
        }
        logger.warn("------- COMPSs Task Execution Summary per Worker ------");
        for (Map.Entry entry : coreProfilesPerWorker.entrySet()) {
            String workerName = (String)entry.getKey();
            Profile[] workerCoreProfiles = (Profile[])entry.getValue();
            logger.warn("--- Summary for COMPSs Worker " + workerName);
            long totalExecutedTasksInWorker = 0L;
            for (Map.Entry entry2 : CoreManager.getSignaturesToCeAndImpls().entrySet()) {
                signature = (String)entry2.getKey();
                isPhantomSignature = signature.endsWith(")");
                if (isPhantomSignature) continue;
                int coreId = (Integer)entry2.getValue();
                long executionCount = workerCoreProfiles[coreId].getExecutionCount();
                totalExecutedTasksInWorker += executionCount;
                String info = executionCount + " " + signature + " tasks have been executed";
                logger.warn(info);
            }
            logger.warn("--- Total executed tasks in COMPSs Worker " + workerName + ": " + totalExecutedTasksInWorker);
        }
        logger.warn("-------------------------------------------------------");
        logger.warn("");
        logger.warn("------------ COMPSs Task Execution Summary ------------");
        long totalExecutedTasks = 0L;
        for (Map.Entry<String, Integer> entry : CoreManager.getSignaturesToCeAndImpls().entrySet()) {
            String signature2 = entry.getKey();
            boolean isPhantomSignature2 = signature2.endsWith(")");
            if (isPhantomSignature2) continue;
            int coreId = entry.getValue();
            long l = coreGlobalProfiles[coreId].getExecutionCount();
            totalExecutedTasks += l;
            String info = l + " " + signature2 + " tasks have been executed";
            logger.warn(info);
        }
        logger.warn("Total executed tasks: " + totalExecutedTasks);
        logger.warn("-------------------------------------------------------");
    }

    public final <T extends WorkerResourceDescription> String getRunningActionMonitorData(Worker<T> worker, String prefix) {
        LOGGER.info("[TaskScheduler] Get running actions monitoring data");
        StringBuilder runningActions = new StringBuilder();
        ResourceScheduler ui = this.workers.get(worker);
        if (ui != null) {
            AllocatableAction[] hostedActions;
            for (AllocatableAction action : hostedActions = ui.getHostedActions()) {
                runningActions.append(prefix);
                runningActions.append("<Action>").append(action.toString()).append("</Action>");
                runningActions.append("\n");
            }
        } else {
            LOGGER.info("[TaskScheduler] Worker is not in the list");
        }
        return runningActions.toString();
    }

    public final String getCoresMonitoringData(String prefix) {
        int implId;
        int coreId;
        LOGGER.info("[TaskScheduler] Get cores monitoring data");
        int coreCount = CoreManager.getCoreCount();
        Profile[][] implementationsProfile = new Profile[coreCount][];
        for (CoreElement ce : CoreManager.getAllCores()) {
            int coreId2 = ce.getCoreId();
            int implsCount = ce.getImplementationsCount();
            implementationsProfile[coreId2] = new Profile[implsCount];
            for (int implId2 = 0; implId2 < implsCount; ++implId2) {
                implementationsProfile[coreId2][implId2] = new Profile();
                implementationsProfile[coreId2][implId2].accumulate(this.offVMsProfiles[coreId2][implId2]);
            }
        }
        for (ResourceScheduler ui : this.workers.values()) {
            if (ui == null) continue;
            List<Implementation>[] runningCoreImpls = ui.getExecutableImpls();
            for (coreId = 0; coreId < coreCount; ++coreId) {
                for (Implementation impl : runningCoreImpls[coreId]) {
                    implId = impl.getImplementationId();
                    implementationsProfile[coreId][implId].accumulate(ui.getProfile(impl));
                }
            }
        }
        StringBuilder coresInfo = new StringBuilder();
        coresInfo.append(prefix).append("<CoresInfo>").append("\n");
        for (CoreElement ce : CoreManager.getAllCores()) {
            coreId = ce.getCoreId();
            coresInfo.append(prefix).append("\t").append("<Core id=\"").append(coreId).append("\"").append(">").append("\n");
            for (Implementation impl : ce.getImplementations()) {
                implId = impl.getImplementationId();
                String signature = impl.getSignature();
                coresInfo.append(prefix).append("\t\t").append("<Impl id=\"").append(implId).append("\"").append(">").append("\n");
                coresInfo.append(prefix).append("\t\t\t").append("<Signature>").append(signature).append("</Signature>").append("\n");
                coresInfo.append(prefix).append("\t\t\t").append("<MeanExecutionTime>").append(implementationsProfile[coreId][implId].getAverageExecutionTime()).append("</MeanExecutionTime>").append("\n");
                coresInfo.append(prefix).append("\t\t\t").append("<MinExecutionTime>").append(implementationsProfile[coreId][implId].getMinExecutionTime()).append("</MinExecutionTime>").append("\n");
                coresInfo.append(prefix).append("\t\t\t").append("<MaxExecutionTime>").append(implementationsProfile[coreId][implId].getMaxExecutionTime()).append("</MaxExecutionTime>").append("\n");
                coresInfo.append(prefix).append("\t\t\t").append("<ExecutedCount>").append(implementationsProfile[coreId][implId].getExecutionCount()).append("</ExecutedCount>").append("\n");
                coresInfo.append(prefix).append("\t\t").append("</Impl>").append("\n");
            }
            coresInfo.append(prefix).append("\t").append("</Core>").append("\n");
        }
        coresInfo.append(prefix).append("</CoresInfo>").append("\n");
        return coresInfo.toString();
    }

    public void updateState() {
        for (ResourceScheduler rs : this.workers.values()) {
            JSONObject oldResource = this.jsm.getJSONForResource(rs.getResource());
            if (oldResource == null) {
                this.jsm.addResourceJSON(rs);
                continue;
            }
            this.updateResourceJSON(rs);
        }
    }

    public void updateResourceJSON(ResourceScheduler<? extends WorkerResourceDescription> rs) {
        JSONObject difference = this.jsm.updateResourceJSON(rs);
        JSONObject implsdiff = difference.getJSONObject("implementations");
        for (CoreElement ce : CoreManager.getAllCores()) {
            for (Implementation impl : ce.getImplementations()) {
                JSONObject implJSON = this.jsm.getJSONForImplementation(impl);
                Profile p = this.generateProfile(implsdiff.getJSONObject(impl.getSignature()));
                if (implJSON == null) {
                    this.jsm.addImplementationJSON(impl, p);
                    continue;
                }
                this.jsm.accumulateImplementationJSON(impl, p);
            }
        }
    }

    public boolean isExternalAdaptationEnabled() {
        return this.externalAdaptation;
    }

    public JSONObject getJSONForCloudInstanceTypeDescription(CloudProvider cp, CloudInstanceTypeDescription ctid) {
        return this.jsm.getJSONForCloudInstanceTypeDescription(cp, ctid);
    }

    public JSONObject getJSONForImplementations() {
        return this.jsm.getJSONForImplementations();
    }

    public ResourceScheduler<? extends WorkerResourceDescription> getNextResourForDistributed(int coreId) {
        LinkedList resourceList = this.distributedTasksResources.computeIfAbsent(coreId, resources -> new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>(this.getWorkers()));
        ResourceScheduler res = (ResourceScheduler)resourceList.poll();
        resourceList.add(res);
        return res;
    }

    protected class WorkersMap {
        private final Map<Resource, ResourceScheduler<? extends WorkerResourceDescription>> map = new HashMap<Resource, ResourceScheduler<? extends WorkerResourceDescription>>();

        public <T extends WorkerResourceDescription> void put(Resource w, ResourceScheduler<T> rs) {
            this.map.put(w, rs);
        }

        public <T extends WorkerResourceDescription> ResourceScheduler<T> get(Resource w) {
            return this.map.get(w);
        }

        private <T extends WorkerResourceDescription> void remove(Resource resource) {
            this.map.remove(resource);
        }

        private Collection<ResourceScheduler<? extends WorkerResourceDescription>> values() {
            return this.map.values();
        }
    }
}

