/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.schedulinginformation;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.types.LocationScoreMonitor;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.DictCollectionParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataLocality
extends SchedulingInformation {
    public <T extends WorkerResourceDescription> DataLocality(ResourceScheduler<T> enforcedTargetResource, List<Parameter> params, Integer coreId) {
        super(enforcedTargetResource);
        if (enforcedTargetResource == null && coreId != null && params != null) {
            this.registerLocalityScoreMonitoring(params);
        }
    }

    private void registerLocalityScoreMonitoring(List<Parameter> params) {
        for (Parameter p : params) {
            this.registerLocalityScoreMonitoring(p);
        }
    }

    private void registerLocalityScoreMonitoring(Parameter p) {
        if (p.isPotentialDependency() && p.getDirection() != Direction.OUT) {
            switch (p.getType()) {
                case COLLECTION_T: {
                    CollectionParameter cp = (CollectionParameter)p;
                    this.registerLocalityScoreMonitoring(cp.getParameters());
                    break;
                }
                case DICT_COLLECTION_T: {
                    DictCollectionParameter dcp = (DictCollectionParameter)p;
                    for (Map.Entry<Parameter, Parameter> entry : dcp.getParameters().entrySet()) {
                        this.registerLocalityScoreMonitoring(entry.getKey());
                        this.registerLocalityScoreMonitoring(entry.getValue());
                    }
                    break;
                }
                default: {
                    LogicalData dataLD;
                    DependencyParameter dp = (DependencyParameter)p;
                    DataInstanceId dId = null;
                    switch (dp.getDirection()) {
                        case IN: 
                        case IN_DELETE: 
                        case CONCURRENT: {
                            RAccessId raId = (RAccessId)dp.getDataAccessId();
                            dId = raId.getReadDataInstance();
                            break;
                        }
                        case COMMUTATIVE: 
                        case INOUT: {
                            RWAccessId rwaId = (RWAccessId)dp.getDataAccessId();
                            dId = rwaId.getReadDataInstance();
                            break;
                        }
                        case OUT: {
                            return;
                        }
                    }
                    if (dId == null || (dataLD = dId.getData()) == null) break;
                    Set<Resource> hosts = dataLD.getAllHosts();
                    this.increasePreregisteredScores(hosts, p.getWeight());
                    LocationScoreMonitor monitor = new LocationScoreMonitor(this, p.getWeight());
                    dataLD.registerLocationMonitor(monitor);
                }
            }
        }
    }
}

