/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.Task;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskGroup
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    private final String name;
    private Application app;
    private final List<Task> tasks;
    private boolean closed;
    private boolean barrierSet;
    private Barrier barrier;
    private boolean barrierDrawn;

    public TaskGroup(String groupName, Application app) {
        this.name = groupName;
        this.app = app;
        this.tasks = new LinkedList<Task>();
        this.closed = false;
        this.barrierSet = false;
        this.barrier = new PendingBarrier();
        this.barrierDrawn = false;
    }

    public String getName() {
        return this.name;
    }

    public Application getApp() {
        return this.app;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
        this.barrier.setGraphSource(task.getId());
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public int getLastTaskId() {
        return this.barrier.getGraphSource();
    }

    public boolean hasPendingTasks() {
        return !this.tasks.isEmpty();
    }

    public void removeTask(Task t) {
        this.tasks.remove(t);
    }

    public void registerBarrier(Barrier request) {
        LOGGER.debug("Added barrier for group " + this.name);
        int currentGraphSource = this.barrier.getGraphSource();
        COMPSsException currentException = this.barrier.getException();
        request.setException(currentException);
        request.setGraphSource(currentGraphSource);
        if (this.hasPendingTasks()) {
            this.barrierSet = true;
            this.barrier = request;
        } else {
            this.barrierSet = false;
            this.barrier = new PendingBarrier();
            request.release();
        }
    }

    @Override
    public void close() throws Exception {
    }

    public boolean hasException() {
        return this.barrier.getException() != null;
    }

    public COMPSsException getException() {
        return this.barrier.getException();
    }

    public void setException(COMPSsException e) {
        LOGGER.debug("Exception set for group " + this.name);
        this.barrier.setException(e);
    }

    public boolean hasBarrier() {
        return this.barrierSet;
    }

    public void releaseBarrier() {
        this.barrierSet = false;
        this.barrier.release();
    }

    public void setClosed() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private class PendingBarrier
    implements Barrier {
        private COMPSsException exception;
        private int graphSource = Integer.MIN_VALUE;

        private PendingBarrier() {
        }

        @Override
        public void setException(COMPSsException exception) {
            this.exception = exception;
        }

        @Override
        public COMPSsException getException() {
            return this.exception;
        }

        @Override
        public void release() {
        }

        @Override
        public int getGraphSource() {
            return this.graphSource;
        }

        @Override
        public void setGraphSource(int id) {
            this.graphSource = id;
        }
    }
}

