/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class IsObjectHereRequest
extends APRequest {
    private final int code;
    private final Semaphore sem;
    private boolean response;

    public IsObjectHereRequest(int code, Semaphore sem) {
        this.code = code;
        this.sem = sem;
    }

    public int getCode() {
        return this.code;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public boolean getResponse() {
        return this.response;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        DataInstanceId dId = dip.getLastDataAccess(this.code);
        this.response = dip.isHere(dId);
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.IS_OBJECT_HERE;
    }
}

