/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class WaitForDataReadyToDeleteRequest
extends APRequest {
    private final Application app;
    private final DataLocation loc;
    private final Semaphore sem;
    private final Semaphore semWait;
    private int nPermits;

    public WaitForDataReadyToDeleteRequest(Application app, DataLocation loc, Semaphore sem, Semaphore semWait) {
        this.app = app;
        this.loc = loc;
        this.sem = sem;
        this.semWait = semWait;
        this.nPermits = 0;
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    public int getNumPermits() {
        return this.nPermits;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        LOGGER.info("[WaitForDataReadyToDelete] Notifying waiting data " + this.loc.getPath() + "to DIP...");
        this.nPermits = dip.waitForDataReadyToDelete(this.app, this.loc, this.semWait);
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DELETE_FILE;
    }
}

