/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class TransferObjectRequest
extends APRequest {
    private final DataAccessId daId;
    private final Semaphore sem;
    private Object response;
    private LogicalData target;

    public TransferObjectRequest(DataAccessId daId, Semaphore sem) {
        this.daId = daId;
        this.sem = sem;
    }

    public DataAccessId getDaId() {
        return this.daId;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public Object getResponse() {
        return this.response;
    }

    public LogicalData getTargetData() {
        return this.target;
    }

    public void setTargetData(LogicalData ld) {
        this.target = ld;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        dip.transferObjectValue(this);
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.TRANSFER_OBJECT;
    }
}

