/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.ResourceManager;
import java.util.concurrent.Semaphore;

public class MonitoringDataRequest
extends TDRequest {
    private final Semaphore sem;
    private String response;

    public MonitoringDataRequest(Semaphore sem) {
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public String getResponse() {
        return this.response;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        String prefix = "\t";
        StringBuilder monitorData = new StringBuilder();
        monitorData.append(ts.getCoresMonitoringData(prefix));
        monitorData.append(prefix).append("<ResourceInfo>").append("\n");
        monitorData.append(ResourceManager.getPendingRequestsMonitorData(prefix + "\t"));
        for (Worker<? extends WorkerResourceDescription> worker : ResourceManager.getAllWorkers()) {
            monitorData.append(prefix).append("\t").append("<Resource id=\"").append(worker.getName()).append("\">").append("\n");
            monitorData.append(worker.getMonitoringData(prefix + "\t\t"));
            String runnningActions = ts.getRunningActionMonitorData(worker, prefix + "\t\t\t");
            if (runnningActions != null) {
                monitorData.append(prefix).append("\t\t").append("<Status>").append("Running").append("</Status>").append("\n");
                monitorData.append(prefix).append("\t\t").append("<Actions>").append("\n");
                monitorData.append(runnningActions);
                monitorData.append(prefix).append("\t\t").append("</Actions>").append("\n");
            } else {
                monitorData.append(prefix).append("\t\t").append("<Status>").append("On Destroy").append("</Status>").append("\n");
                monitorData.append(prefix).append("\t\t").append("<Actions>").append("</Actions>").append("\n");
            }
            monitorData.append(prefix).append("\t").append("</Resource>").append("\n");
        }
        monitorData.append(prefix).append("</ResourceInfo>").append("\n");
        monitorData.append(prefix).append("<Statistics>").append("\n");
        monitorData.append(prefix).append("\t").append("<Statistic>").append("\n");
        monitorData.append(prefix).append("\t\t").append("<Key>").append("Accumulated Cost").append("</Key>").append("\n");
        monitorData.append(prefix).append("\t\t").append("<Value>").append(ResourceManager.getTotalCost()).append("</Value>").append("\n");
        monitorData.append(prefix).append("\t").append("</Statistic>").append("\n");
        monitorData.append(prefix).append("</Statistics>").append("\n");
        this.response = monitorData.toString();
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.MONITORING_DATA;
    }
}

