/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.exceptions.LangNotDefinedException;
import es.bsc.compss.types.parameter.Parameter;
import java.util.List;

public class SignatureBuilder {
    private static final COMPSsConstants.Lang LANG;

    private SignatureBuilder() {
    }

    public static String getMethodSignature(String declaringClass, String methodName, boolean hasTarget, int numReturns, List<Parameter> parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(methodName).append("(");
        switch (LANG) {
            case JAVA: 
            case C: {
                int numPars = parameters.size();
                if (hasTarget) {
                    --numPars;
                }
                if ((numPars -= numReturns) <= 0) break;
                DataType type = parameters.get(0).getType();
                type = type == DataType.PSCO_T ? DataType.OBJECT_T : type;
                buffer.append((Object)type);
                for (int i = 1; i < numPars; ++i) {
                    type = parameters.get(i).getType();
                    type = type == DataType.PSCO_T ? DataType.OBJECT_T : type;
                    buffer.append(",").append((Object)type);
                }
                break;
            }
            case PYTHON: {
                break;
            }
            case UNKNOWN: {
                throw new LangNotDefinedException();
            }
        }
        buffer.append(")").append(declaringClass);
        return buffer.toString();
    }

    public static String getServiceSignature(String namespace, String serviceName, String portName, String operation, boolean hasTarget, int numReturns, List<Parameter> parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(operation).append("(");
        int numPars = parameters.size();
        if (hasTarget) {
            --numPars;
        }
        if ((numPars -= numReturns) > 0) {
            buffer.append((Object)parameters.get(0).getType());
            for (int i = 1; i < numPars; ++i) {
                buffer.append(",").append((Object)parameters.get(i).getType());
            }
        }
        buffer.append(")").append(namespace).append(',').append(serviceName).append(',').append(portName);
        return buffer.toString();
    }

    public static String getHTTPSignature(String declareMethodFullyQualifiedName, boolean hasTarget, int numReturns, List<Parameter> parameters) {
        COMPSsConstants.Lang lang;
        String langStr = System.getProperty("compss.lang");
        COMPSsConstants.Lang lang2 = lang = langStr == null ? COMPSsConstants.Lang.JAVA : COMPSsConstants.Lang.valueOf(langStr.toUpperCase());
        if (lang == COMPSsConstants.Lang.PYTHON) {
            return declareMethodFullyQualifiedName;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(declareMethodFullyQualifiedName).append("(");
        int numPars = parameters.size();
        if (hasTarget) {
            --numPars;
        }
        if ((numPars -= numReturns) > 0) {
            buffer.append((Object)parameters.get(0).getType());
            for (int i = 1; i < numPars; ++i) {
                buffer.append(",").append((Object)parameters.get(i).getType());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    static {
        COMPSsConstants.Lang l = COMPSsConstants.Lang.JAVA;
        String langProperty = System.getProperty("compss.lang");
        if (langProperty != null) {
            if (langProperty.equalsIgnoreCase("python")) {
                l = COMPSsConstants.Lang.PYTHON;
            } else if (langProperty.equalsIgnoreCase("c")) {
                l = COMPSsConstants.Lang.C;
            }
        }
        LANG = l;
    }
}

