/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.allocatableactions.MultiNodeGroup;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class MultiNodeExecutionAction
extends ExecutionAction {
    private final MultiNodeGroup group;
    private int actionIdInsideGroup = -1;

    public MultiNodeExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, AccessProcessor ap, Task task, MultiNodeGroup group) {
        super(schedulingInformation, orchestrator, ap, task);
        this.group = group;
    }

    @Override
    public long getGroupPriority() {
        return this.group.isAnyActionRunning() ? 0L : 1L;
    }

    @Override
    protected void notifyCompleted() {
        if (this.actionIdInsideGroup == 1) {
            if (DEBUG) {
                LOGGER.debug("Notify completed of " + this + " to orchestrator " + this.orchestrator);
            }
            this.group.actionCompletion();
        }
        if (this.isPending()) {
            this.orchestrator.actionCompletion(this);
        }
    }

    @Override
    protected void notifyError() {
        if (this.actionIdInsideGroup == 1) {
            if (DEBUG) {
                LOGGER.debug("Notify error of " + this + " to orchestrator " + this.orchestrator);
            }
            this.group.actionError();
            this.orchestrator.actionError(this);
        } else if (this.isRunning()) {
            LOGGER.debug("Notify slave " + this + " to orchestrator " + this.orchestrator);
            this.orchestrator.actionError(this);
        }
    }

    @Override
    protected void doAction() {
        LOGGER.info("Registering action for task " + this.task.getId());
        this.group.setActionRunning();
        if (this.actionIdInsideGroup == -1) {
            this.actionIdInsideGroup = this.group.registerProcess(this);
        }
        this.executionErrors = 0;
        if (this.actionIdInsideGroup == 1) {
            LOGGER.info("Action registered as master for task " + this.task.getId() + " with groupId " + this.group.getGroupId());
            super.doAction();
        } else {
            LOGGER.info("Action registered as slave for task " + this.task.getId() + " with groupId " + this.group.getGroupId());
        }
    }

    @Override
    protected List<String> getSlaveNames() {
        return this.group.getSlavesNames();
    }

    @Override
    protected void stopAction() throws Exception {
        if (this.actionIdInsideGroup == 1) {
            LOGGER.info("Task " + this.task.getId() + " starts cancelling MultiNode master running job");
            super.stopAction();
        } else {
            LOGGER.info("Task " + this.task.getId() + " starts cancelling MultiNode slave running job");
        }
    }

    @Override
    protected void doCompleted() {
        if (this.actionIdInsideGroup == 1) {
            super.doCompleted();
        } else {
            this.getAssignedResource().profiledExecution(this.getAssignedImplementation(), this.profile);
            this.task.decreaseExecutionCount();
        }
    }

    @Override
    protected void doFailed() {
        if (this.actionIdInsideGroup == 1) {
            super.doFailed();
        } else {
            this.task.setStatus(TaskState.FAILED);
            this.task.decreaseExecutionCount();
        }
    }

    @Override
    protected void doCanceled() {
        this.group.increaseCancelled();
        if (this.group.isCancelled()) {
            super.doCanceled();
        } else {
            this.task.setStatus(TaskState.CANCELED);
            this.task.decreaseExecutionCount();
        }
    }

    @Override
    protected Collection<AllocatableAction> doException(COMPSsException e) {
        if (this.actionIdInsideGroup == 1) {
            return super.doException(e);
        }
        this.task.setStatus(TaskState.FINISHED);
        this.task.decreaseExecutionCount();
        return new LinkedList<AllocatableAction>();
    }

    @Override
    protected void doFailIgnored() {
        if (this.actionIdInsideGroup == 1) {
            super.doFailIgnored();
        } else {
            this.task.setStatus(TaskState.FINISHED);
            this.task.decreaseExecutionCount();
        }
    }

    @Override
    public String toString() {
        return "MultiNodeExecutionAction (Task " + this.task.getId() + ", CE name " + this.task.getTaskDescription().getName() + ") with GroupId = " + this.group.getGroupId();
    }

    public void upgrade() {
        this.orchestrator.actionUpgrade(this);
    }
}

