/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.ExecType;
import es.bsc.compss.types.implementations.HTTPImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.HTTPDefinition;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MpmdMPIDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.implementations.definition.ServiceDefinition;
import es.bsc.compss.types.resources.HTTPResourceDescription;
import es.bsc.compss.types.resources.ServiceResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class ImplementationDescription<T extends WorkerResourceDescription, D extends ImplementationDefinition>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String signature;
    private boolean isLocal;
    private T constraints;
    private D implDefinition;
    private ExecType prolog;
    private ExecType epilog;

    public static final <T extends WorkerResourceDescription, D extends ImplementationDefinition> ImplementationDescription<T, D> defineImplementation(String implType, String implSignature, boolean localProcessing, T implConstraints, ExecType prolog, ExecType epilog, String ... implTypeArgs) throws IllegalArgumentException {
        ImplementationDescription<Object, ImplementationDefinition> id = null;
        if (implType.toUpperCase().compareTo(TaskType.SERVICE.toString()) == 0) {
            if (implTypeArgs.length != 4) {
                throw new IllegalArgumentException("Incorrect parameters for type SERVICE on " + implSignature);
            }
            String namespace = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
            String serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
            String operation = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
            String port = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
            id = new ImplementationDescription<ServiceResourceDescription, ServiceDefinition>(new ServiceDefinition(namespace, serviceName, operation, port), implSignature, localProcessing, new ServiceResourceDescription(serviceName, namespace, port, 1), prolog, epilog);
        } else if (implType.toUpperCase().compareTo(TaskType.HTTP.toString()) == 0) {
            if (implTypeArgs.length != 7) {
                throw new IllegalArgumentException("Incorrect parameters for type HTTP on " + implSignature);
            }
            String serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
            ArrayList<String> servicesList = new ArrayList<String>();
            servicesList.add(serviceName);
            id = new ImplementationDescription<HTTPResourceDescription, HTTPDefinition>(new HTTPDefinition(implTypeArgs, 0), implSignature, localProcessing, new HTTPResourceDescription(servicesList, 1), prolog, epilog);
        } else {
            MethodType mt;
            try {
                mt = MethodType.valueOf(implType);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unrecognised method type " + implType);
            }
            switch (mt) {
                case METHOD: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type METHOD on " + implSignature);
                    }
                    id = new ImplementationDescription<T, MethodDefinition>(new MethodDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case PYTHON_MPI: {
                    if (implTypeArgs.length < 10) {
                        throw new IllegalArgumentException("Incorrect parameters for type PYTHON_MPI on " + implSignature);
                    }
                    PythonMPIDefinition pyMPIDef = new PythonMPIDefinition(implTypeArgs, 0);
                    implConstraints.scaleUpBy(pyMPIDef.getPPN());
                    id = new ImplementationDescription<T, PythonMPIDefinition>(pyMPIDef, implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case CONTAINER: {
                    if (implTypeArgs.length != 7) {
                        throw new IllegalArgumentException("Incorrect parameters for type CONTAINER on " + implSignature);
                    }
                    id = new ImplementationDescription<T, ContainerDefinition>(new ContainerDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case BINARY: {
                    if (implTypeArgs.length != 4) {
                        throw new IllegalArgumentException("Incorrect parameters for type BINARY on " + implSignature);
                    }
                    id = new ImplementationDescription<T, BinaryDefinition>(new BinaryDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case MPI: {
                    if (implTypeArgs.length != 8) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    MPIDefinition mpiDef = new MPIDefinition(implTypeArgs, 0);
                    implConstraints.scaleUpBy(mpiDef.getPPN());
                    id = new ImplementationDescription<T, MPIDefinition>(mpiDef, implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case MPMDMPI: {
                    if (implTypeArgs.length < 5) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPMDMPI on " + implSignature);
                    }
                    MpmdMPIDefinition mpmdDef = new MpmdMPIDefinition(implTypeArgs, 0);
                    implConstraints.scaleUpBy(mpmdDef.getPPN());
                    id = new ImplementationDescription<T, MpmdMPIDefinition>(mpmdDef, implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case COMPSs: {
                    if (implTypeArgs.length != 6) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    id = new ImplementationDescription<T, COMPSsDefinition>(new COMPSsDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case DECAF: {
                    if (implTypeArgs.length != 6) {
                        throw new IllegalArgumentException("Incorrect parameters for type DECAF on " + implSignature);
                    }
                    id = new ImplementationDescription<T, DecafDefinition>(new DecafDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case OMPSS: {
                    if (implTypeArgs.length != 3) {
                        throw new IllegalArgumentException("Incorrect parameters for type OMPSS on " + implSignature);
                    }
                    id = new ImplementationDescription<T, OmpSsDefinition>(new OmpSsDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case OPENCL: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type OPENCL on " + implSignature);
                    }
                    id = new ImplementationDescription<T, OpenCLDefinition>(new OpenCLDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                    break;
                }
                case MULTI_NODE: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type MultiNode on " + implSignature);
                    }
                    id = new ImplementationDescription<T, MultiNodeDefinition>(new MultiNodeDefinition(implTypeArgs, 0), implSignature, localProcessing, implConstraints, prolog, epilog);
                }
            }
        }
        return id;
    }

    public ImplementationDescription() {
    }

    public ImplementationDescription(D implDefinition, String signature, boolean localProcessing, T constraints, ExecType prolog, ExecType epilog) {
        this.signature = signature;
        this.isLocal = localProcessing;
        this.constraints = constraints;
        this.implDefinition = implDefinition;
        this.prolog = prolog;
        this.epilog = epilog;
    }

    public String getSignature() {
        return this.signature;
    }

    public ExecType getProlog() {
        return this.prolog;
    }

    public ExecType getEpilog() {
        return this.epilog;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public T getConstraints() {
        return this.constraints;
    }

    public Implementation getImpl(int coreId, int implId) {
        switch (this.implDefinition.getTaskType()) {
            case METHOD: {
                return new AbstractMethodImplementation((Integer)coreId, (Integer)implId, this);
            }
            case HTTP: {
                return new HTTPImplementation((Integer)coreId, (Integer)implId, this);
            }
        }
        return new ServiceImplementation((Integer)coreId, (Integer)implId, this);
    }

    public D getDefinition() {
        return this.implDefinition;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.signature = (String)in.readObject();
        this.isLocal = in.readBoolean();
        this.constraints = (WorkerResourceDescription)in.readObject();
        this.implDefinition = (ImplementationDefinition)in.readObject();
        this.prolog = (ExecType)in.readObject();
        this.epilog = (ExecType)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.signature);
        out.writeBoolean(this.isLocal);
        out.writeObject(this.constraints);
        out.writeObject(this.implDefinition);
        out.writeObject(this.prolog);
        out.writeObject(this.epilog);
    }

    public String toString() {
        return this.implDefinition.toShortFormat();
    }
}

