/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.io.IOException;
import java.util.concurrent.Semaphore;

public class TransferOpenFileRequest
extends APRequest {
    private final DataAccessId faId;
    private final Semaphore sem;
    private DataLocation location;

    public TransferOpenFileRequest(DataAccessId faId, Semaphore sem) {
        this.faId = faId;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public DataAccessId getFaId() {
        return this.faId;
    }

    public DataLocation getLocation() {
        return this.location;
    }

    public void setLocation(DataLocation location) {
        this.location = location;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        String targetPath;
        String targetName;
        LOGGER.debug("Process TransferOpenFileRequest");
        if (this.faId instanceof WAccessId) {
            WAccessId waId = (WAccessId)this.faId;
            DataInstanceId targetFile = waId.getWrittenDataInstance();
            targetName = targetFile.getRenaming();
            targetPath = Comm.getAppHost().getWorkingDirectory() + targetName;
        } else if (this.faId instanceof RWAccessId) {
            RWAccessId rwaId = (RWAccessId)this.faId;
            targetName = rwaId.getWrittenDataInstance().getRenaming();
            targetPath = Comm.getAppHost().getWorkingDirectory() + targetName;
        } else {
            RAccessId raId = (RAccessId)this.faId;
            targetName = raId.getReadDataInstance().getRenaming();
            targetPath = Comm.getAppHost().getWorkingDirectory() + targetName;
        }
        LOGGER.debug("Openning file " + targetName + " at " + targetPath);
        DataLocation targetLocation = null;
        String pscoId = Comm.getData(targetName).getPscoId();
        if (pscoId != null) {
            try {
                SimpleURI targetURI = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + pscoId);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
            }
            catch (IOException ioe) {
                ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
            }
            Comm.registerLocation(targetName, targetLocation);
            LOGGER.debug("Setting target location to " + targetLocation);
            this.setLocation(targetLocation);
            LOGGER.debug("External object detected. Auto-release");
            Comm.registerLocation(targetName, targetLocation);
            this.sem.release();
        } else {
            try {
                SimpleURI targetURI = new SimpleURI(ProtocolType.FILE_URI.getSchema() + targetPath);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
            }
            catch (IOException ioe) {
                ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
            }
            if (this.faId instanceof WAccessId) {
                LOGGER.debug("Write only mode. Auto-release");
                Comm.registerLocation(targetName, targetLocation);
                LOGGER.debug("Setting target location to " + targetLocation);
                this.setLocation(targetLocation);
                this.sem.release();
            } else if (this.faId instanceof RWAccessId) {
                LOGGER.debug("RW mode. Asking for transfer");
                RWAccessId rwaId = (RWAccessId)this.faId;
                LogicalData srcData = rwaId.getReadDataInstance().getData();
                FileTransferable ft = new FileTransferable(rwaId.isPreserveSourceData());
                Comm.getAppHost().getData(srcData, targetName, (LogicalData)null, (Transferable)ft, (EventListener)new CopyListener(ft, this.sem));
            } else {
                LOGGER.debug("Read only mode. Asking for transfer");
                RAccessId raId = (RAccessId)this.faId;
                LogicalData srcData = raId.getReadDataInstance().getData();
                FileTransferable ft = new FileTransferable();
                Comm.getAppHost().getData(srcData, ft, new CopyListener(ft, this.sem));
            }
        }
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.TRANSFER_OPEN_FILE;
    }

    private class CopyListener
    extends OneOpWithSemListener {
        private final FileTransferable reason;

        public CopyListener(FileTransferable reason, Semaphore sem) {
            super(sem);
            this.reason = reason;
        }

        @Override
        public void notifyEnd(DataOperation fOp) {
            String targetPath = this.reason.getDataTarget();
            try {
                SimpleURI targetURI = new SimpleURI(ProtocolType.FILE_URI.getSchema() + targetPath);
                DataLocation targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
                TransferOpenFileRequest.this.setLocation(targetLocation);
            }
            catch (IOException ioe) {
                ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
            }
            super.notifyEnd(fOp);
        }
    }
}

