/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.DataParams;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.BindingObjectTransferable;
import es.bsc.compss.types.data.operation.DirectoryTransferable;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.ObjectTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.request.ap.TransferBindingObjectRequest;
import es.bsc.compss.types.request.ap.TransferObjectRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.serializers.Serializer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class DataInfoProvider {
    private static final String RES_FILE_TRANSFER_ERR = "Error transferring result files";
    private final TreeMap<Integer, Integer> codeToId = new TreeMap();
    private TreeMap<Integer, DataInfo> idToData = new TreeMap();
    private TreeSet<String> valuesOnMain = new TreeSet();
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public DataInfoProvider() {
        LOGGER.info("Initialization finished");
    }

    public Integer getObjectDataId(int code) {
        return this.codeToId.get(code);
    }

    public void registerObjectDataId(int code, int dataId) {
        this.codeToId.put(code, dataId);
    }

    private DataInfo registerData(DataParams data) {
        DataInfo dInfo = data.createDataInfo(this);
        this.idToData.put(dInfo.getDataId(), dInfo);
        return dInfo;
    }

    public void registerRemoteDataSources(DataParams internalData, String externalData) {
        DataInfo dInfo;
        Integer dId = internalData.getDataId(this);
        if (dId == null) {
            if (DEBUG) {
                LOGGER.debug("Registering Remote data on DIP: " + internalData.getDescription());
            }
            dInfo = this.registerData(internalData);
        } else {
            dInfo = this.idToData.get(dId);
        }
        if (externalData != null && dInfo != null) {
            String existingRename = dInfo.getCurrentDataVersion().getDataInstanceId().getRenaming();
            try {
                Comm.linkData(externalData, existingRename);
            }
            catch (CommException ce) {
                ErrorManager.error("Could not link the newly created data for " + internalData.getDescription() + " with data " + externalData, ce);
            }
        }
    }

    public LogicalData getDataLastVersion(DataParams internalData) {
        DataInfo fileInfo;
        Integer dId = internalData.getDataId(this);
        if (dId != null && (fileInfo = this.idToData.get(dId)) != null) {
            return fileInfo.getCurrentDataVersion().getDataInstanceId().getData();
        }
        return null;
    }

    public DataAccessId registerDataAccess(AccessParams access) {
        DataInfo dInfo;
        Integer dId = access.getDataId(this);
        if (dId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to " + access.getDataDescription());
            }
            dInfo = this.registerData(access.getData());
            access.registeredAsFirstVersionForData(dInfo);
        } else {
            dInfo = this.idToData.get(dId);
            if (dInfo != null) {
                if (DEBUG) {
                    LOGGER.debug("Another access to " + access.getDataDescription());
                }
            } else {
                ErrorManager.warn(access.getDataDescription() + " was accessed but the file information not found. Maybe it has been previously canceled");
                return null;
            }
        }
        DataAccessId daId = this.willAccess(access, dInfo);
        return daId;
    }

    public void finishDataAccess(AccessParams access) {
        Integer dId = access.getDataId(this);
        if (dId == null) {
            LOGGER.warn(access.getDataDescription() + " has not been accessed before");
            return;
        }
        DataInfo dInfo = this.idToData.get(dId);
        DataAccessId daid = this.getAccess(access.getMode(), dInfo);
        if (daid == null) {
            LOGGER.warn(access.getDataDescription() + " has not been accessed before");
            return;
        }
        this.dataHasBeenAccessed(daid);
    }

    private DataAccessId willAccess(AccessParams access, DataInfo di) {
        DataAccessId daId = null;
        switch (access.getMode()) {
            case C: 
            case R: {
                di.willBeRead();
                daId = new RAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: R").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RAccessId)daId).getRVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case W: {
                di.willBeWritten();
                daId = new WAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: W").append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((WAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case CV: 
            case RW: {
                di.willBeRead();
                DataVersion readInstance = di.getCurrentDataVersion();
                di.willBeWritten();
                DataVersion writtenInstance = di.getCurrentDataVersion();
                daId = new RWAccessId(readInstance, writtenInstance);
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: RW").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getRVersionId()).append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
            }
        }
        access.externalRegister();
        return daId;
    }

    private DataAccessId getAccess(AccessParams.AccessMode mode, DataInfo di) {
        DataAccessId daId = null;
        DataVersion currentInstance = di.getCurrentDataVersion();
        if (currentInstance != null) {
            switch (mode) {
                case C: 
                case R: {
                    daId = new RAccessId(currentInstance);
                    break;
                }
                case W: {
                    daId = new WAccessId(di.getCurrentDataVersion());
                    break;
                }
                case CV: 
                case RW: {
                    DataVersion readInstance = di.getPreviousDataVersion();
                    if (readInstance != null) {
                        daId = new RWAccessId(readInstance, currentInstance);
                        break;
                    }
                    LOGGER.warn("Previous instance for data" + di.getDataId() + " is null.");
                }
            }
        } else {
            LOGGER.warn("Current instance for data" + di.getDataId() + " is null.");
        }
        return daId;
    }

    public void dataAccessHasBeenCanceled(DataAccessId dAccId, boolean keepModified) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        if (di != null) {
            boolean deleted = false;
            switch (dAccId.getDirection()) {
                case C: 
                case R: {
                    Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                    deleted = di.canceledReadVersion(rVersionId);
                    break;
                }
                case CV: 
                case RW: {
                    Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                    Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                    if (keepModified) {
                        di.versionHasBeenRead(rVersionId);
                        di.tryRemoveVersion(rVersionId);
                        deleted = di.versionHasBeenWritten(wVersionId);
                        break;
                    }
                    di.canceledReadVersion(rVersionId);
                    deleted = di.canceledWriteVersion(wVersionId);
                    break;
                }
                default: {
                    Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                    deleted = di.canceledWriteVersion(wVersionId);
                }
            }
            if (deleted) {
                this.removeDataFromInternalStructures(di);
            }
        } else {
            LOGGER.debug("Access of Data" + dAccId.getDataId() + " in Mode " + dAccId.getDirection().name() + " can not be cancelled because do not exist in DIP.");
        }
    }

    public void dataHasBeenAccessed(DataAccessId dAccId) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        if (di != null) {
            boolean deleted = false;
            switch (dAccId.getDirection()) {
                case C: 
                case R: {
                    Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                    deleted = di.versionHasBeenRead(rVersionId);
                    break;
                }
                case CV: 
                case RW: {
                    Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                    di.versionHasBeenRead(rVersionId);
                    di.tryRemoveVersion(rVersionId);
                    Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                    deleted = di.versionHasBeenWritten(wVersionId);
                    break;
                }
                default: {
                    Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                    Integer prevVersionId = wVersionId - 1;
                    di.tryRemoveVersion(prevVersionId);
                    deleted = di.versionHasBeenWritten(wVersionId);
                }
            }
            if (deleted) {
                this.removeDataFromInternalStructures(di);
            }
        } else {
            LOGGER.warn("Access of Data" + dAccId.getDataId() + " in Mode " + dAccId.getDirection().name() + "can not be mark as accessed because do not exist in DIP.");
        }
    }

    public boolean alreadyAccessed(Application app, DataLocation loc) {
        LOGGER.debug("Check already accessed: " + loc.getLocationKey());
        String locationKey = loc.getLocationKey();
        Integer fileId = app.getFileDataId(locationKey);
        return fileId != null;
    }

    public String getLastRenaming(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getCurrentDataVersion().getDataInstanceId().getRenaming();
    }

    public DataLocation getOriginalLocation(int fileId) {
        FileInfo info = (FileInfo)this.idToData.get(fileId);
        return info.getOriginalLocation();
    }

    public void setObjectVersionValue(String renaming, Object value) {
        this.valuesOnMain.add(renaming);
        Comm.registerValue(renaming, value);
    }

    public boolean isHere(DataInstanceId dId) {
        return this.valuesOnMain.contains(dId.getRenaming());
    }

    public DataInstanceId getLastDataAccess(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getCurrentDataVersion().getDataInstanceId();
    }

    public List<DataInstanceId> getLastVersions(TreeSet<Integer> dataIds) {
        ArrayList<DataInstanceId> versionIds = new ArrayList<DataInstanceId>(dataIds.size());
        for (Integer dataId : dataIds) {
            DataInfo dataInfo = this.idToData.get(dataId);
            if (dataInfo != null) {
                versionIds.add(dataInfo.getCurrentDataVersion().getDataInstanceId());
                continue;
            }
            versionIds.add(null);
        }
        return versionIds;
    }

    public void unblockDataId(Integer dataId) {
        DataInfo dataInfo = this.idToData.get(dataId);
        dataInfo.unblockDeletions();
    }

    public int waitForDataReadyToDelete(Application app, DataLocation loc, Semaphore semWait) {
        LOGGER.debug("Waiting for data to be ready for deletion: " + loc.getPath());
        String locationKey = loc.getLocationKey();
        Integer dataId = app.getFileDataId(locationKey);
        if (dataId == null) {
            LOGGER.debug("No data id found for this data location" + loc.getPath());
            semWait.release();
            return 0;
        }
        DataInfo dataInfo = this.idToData.get(dataId);
        int nPermits = dataInfo.waitForDataReadyToDelete(semWait);
        return nPermits;
    }

    public DataInfo deleteData(Application app, DataLocation loc, boolean noReuse) {
        LOGGER.debug("Deleting Data location: " + loc.getPath());
        String locationKey = loc.getLocationKey();
        Integer dataId = app.getFileDataId(locationKey);
        if (dataId == null) {
            LOGGER.debug("No data id found for this data location" + loc.getPath());
            return null;
        }
        DataInfo dataInfo = this.idToData.get(dataId);
        app.removeFileData(locationKey);
        if (dataInfo != null) {
            if (dataInfo.delete(noReuse)) {
                this.removeDataFromInternalStructures(dataInfo);
            }
            return dataInfo;
        }
        LOGGER.debug("Data " + loc.getPath() + " already removed or cancelled");
        return null;
    }

    public DataInfo deleteData(Application app, int code, boolean noReuse) {
        Integer id;
        if (DEBUG) {
            LOGGER.debug("Deleting Data associated with code: " + String.valueOf(code));
        }
        if ((id = this.codeToId.get(code)) == null) {
            if (DEBUG) {
                LOGGER.debug("No data id found for data with code " + String.valueOf(code));
            }
            return null;
        }
        DataInfo dataInfo = this.idToData.get(id);
        if (dataInfo != null) {
            if (dataInfo.delete(noReuse)) {
                this.removeDataFromInternalStructures(dataInfo);
            }
            return dataInfo;
        }
        if (DEBUG) {
            LOGGER.debug("No data info found for data with code " + String.valueOf(code));
        }
        return null;
    }

    public DataInfo deleteCollection(Application app, String collectionId, boolean noReuse) {
        DataParams.CollectionData cd = new DataParams.CollectionData(app, collectionId);
        Integer oId = cd.getDataId(this);
        DataInfo dataInfo = this.idToData.get(oId);
        if (dataInfo.delete(noReuse)) {
            this.removeDataFromInternalStructures(dataInfo);
        }
        return dataInfo;
    }

    public void transferObjectValue(TransferObjectRequest toRequest) {
        LogicalData ld;
        Semaphore sem = toRequest.getSemaphore();
        DataAccessId daId = toRequest.getDaId();
        RWAccessId rwaId = (RWAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        if (DEBUG) {
            LOGGER.debug("Requesting getting object " + sourceName);
        }
        if ((ld = rwaId.getReadDataInstance().getData()) == null) {
            ErrorManager.error("Unregistered data " + sourceName);
            return;
        }
        if (ld.isInMemory()) {
            Object value = null;
            if (!rwaId.isPreserveSourceData()) {
                value = ld.getValue();
                ld.removeValue();
            } else {
                try {
                    ld.writeToStorage();
                }
                catch (Exception e) {
                    ErrorManager.error("Exception writing object to file.", e);
                }
                for (DataLocation loc : ld.getLocations()) {
                    if (loc.getProtocol() == ProtocolType.OBJECT_URI) continue;
                    MultiURI mu = loc.getURIInHost(Comm.getAppHost());
                    String path = mu.getPath();
                    try {
                        value = Serializer.deserialize(path);
                        break;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        ErrorManager.error("Exception writing object to file.", e);
                    }
                }
            }
            toRequest.setResponse(value);
            toRequest.setTargetData(ld);
            sem.release();
        } else {
            if (DEBUG) {
                LOGGER.debug("Object " + sourceName + " not in memory. Requesting tranfers to " + Comm.getAppHost().getName());
            }
            DataLocation targetLocation = null;
            String path = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + sourceName;
            try {
                SimpleURI uri = new SimpleURI(path);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
            toRequest.setTargetData(ld);
            Comm.getAppHost().getData(ld, targetLocation, (Transferable)new ObjectTransferable(), (EventListener)new OneOpWithSemListener(sem));
        }
    }

    public LogicalData transferBindingObject(TransferBindingObjectRequest toRequest) {
        DataAccessId daId = toRequest.getDaId();
        RAccessId rwaId = (RAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Requesting getting object " + sourceName);
        }
        LogicalData srcLd = rwaId.getReadDataInstance().getData();
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Logical data for binding object is:" + srcLd);
        }
        if (srcLd == null) {
            ErrorManager.error("Unregistered data " + sourceName);
            return null;
        }
        if (DEBUG) {
            LOGGER.debug("Requesting tranfers binding object " + sourceName + " to " + Comm.getAppHost().getName());
        }
        Semaphore sem = toRequest.getSemaphore();
        BindingObject srcBO = BindingObject.generate(srcLd.getURIs().get(0).getPath());
        BindingObject tgtBO = new BindingObject(sourceName, srcBO.getType(), srcBO.getElements());
        LogicalData tgtLd = srcLd;
        BindingObjectLocation targetLocation = new BindingObjectLocation(Comm.getAppHost(), tgtBO);
        BindingObjectTransferable transfer = new BindingObjectTransferable(toRequest);
        Comm.getAppHost().getData(srcLd, targetLocation, tgtLd, (Transferable)transfer, (EventListener)new OneOpWithSemListener(sem));
        if (DEBUG) {
            LOGGER.debug(" Setting tgtName " + transfer.getDataTarget() + " in " + Comm.getAppHost().getName());
        }
        return srcLd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultFile blockDataAndGetResultFile(int dataId, ResultListener listener) {
        FileInfo fileInfo;
        if (DEBUG) {
            LOGGER.debug("Get Result file for data " + dataId);
        }
        if ((fileInfo = (FileInfo)this.idToData.get(dataId)) != null && fileInfo.hasBeenCanceled()) {
            if (!fileInfo.isCurrentVersionToDelete()) {
                String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
                String origName = splitPath[splitPath.length - 1];
                if (origName.startsWith("compss-serialized-obj_")) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding file " + origName + " as a result");
                    }
                    return null;
                }
                fileInfo.blockDeletions();
                DataInstanceId lastVersion = fileInfo.getCurrentDataVersion().getDataInstanceId();
                ResultFile rf = new ResultFile(lastVersion, fileInfo.getOriginalLocation());
                DataInstanceId fId = rf.getFileInstanceId();
                String renaming = fId.getRenaming();
                while (renaming != null && !Comm.existsData(renaming)) {
                    renaming = DataInstanceId.previousVersionRenaming(renaming);
                }
                if (renaming == null) {
                    LOGGER.error("Error transferring result files: Cannot transfer file " + fId.getRenaming() + " nor any of its previous versions");
                    return null;
                }
                LogicalData data = Comm.getData(renaming);
                for (DataLocation loc : data.getLocations()) {
                    if (!(loc instanceof PersistentLocation)) continue;
                    String pscoId = ((PersistentLocation)loc).getId();
                    if (Tracer.isActivated()) {
                        Tracer.emitEvent(TraceEvent.STORAGE_CONSOLIDATE);
                    }
                    try {
                        StorageItf.consolidateVersion(pscoId);
                    }
                    catch (StorageException e) {
                        LOGGER.error("Cannot consolidate PSCO " + pscoId, (Throwable)e);
                    }
                    finally {
                        if (Tracer.isActivated()) {
                            Tracer.emitEventEnd(TraceEvent.STORAGE_CONSOLIDATE);
                        }
                    }
                    LOGGER.debug("Returned because persistent object");
                    return rf;
                }
                if (rf.getOriginalLocation().getProtocol() == ProtocolType.BINDING_URI) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding data d" + dataId + " as a result beacuse it is a binding object");
                    }
                } else if (rf.getOriginalLocation().getProtocol() == ProtocolType.DIR_URI) {
                    listener.addOperation();
                    Comm.getAppHost().getData(data, rf.getOriginalLocation(), (Transferable)new DirectoryTransferable(), (EventListener)listener);
                } else {
                    listener.addOperation();
                    Comm.getAppHost().getData(data, rf.getOriginalLocation(), (Transferable)new FileTransferable(), (EventListener)listener);
                }
                return rf;
            }
            if (fileInfo.isCurrentVersionToDelete()) {
                if (DEBUG) {
                    String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
                    String origName = splitPath[splitPath.length - 1];
                    LOGGER.debug("Trying to delete file " + origName);
                }
                if (fileInfo.delete(true)) {
                    this.removeDataFromInternalStructures(fileInfo);
                }
            }
        }
        return null;
    }

    public void shutdown() {
    }

    public void removeAllApplicationData(Application app) {
        List<DataInfo> data = app.popAllData();
        for (DataInfo di : data) {
            di.delete(true);
        }
    }

    private void removeDataFromInternalStructures(DataInfo di) {
        int dataId = di.getDataId();
        this.idToData.remove(dataId);
        Application app = di.getGeneratingAppId();
        if (app != null) {
            app.removeData(di);
        }
    }
}

