/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.checkpoint.CheckpointManager;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskListener;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.BindingObjectAccessParams;
import es.bsc.compss.types.data.accessparams.CollectionAccessParams;
import es.bsc.compss.types.data.accessparams.ExternalPSCObjectAccessParams;
import es.bsc.compss.types.data.accessparams.ExternalStreamAccessParams;
import es.bsc.compss.types.data.accessparams.FileAccessParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;
import es.bsc.compss.types.data.accessparams.StreamAccessParams;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectiveParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.DirectoryParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.ExternalStreamParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.parameter.StreamParameter;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser
implements GraphHandler {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final String TASK_CANCELED = "Task canceled: ";
    private DataInfoProvider dip;
    private CheckpointManager cp;
    private GraphGenerator gm;
    private final Map<Integer, DataAccessesInfo> accessesInfo = new TreeMap<Integer, DataAccessesInfo>();
    private final List<String> reduceTasksNames = new ArrayList<String>();
    private static final boolean IS_DRAW_GRAPH = GraphGenerator.isEnabled();
    private int synchronizationId = 0;
    private boolean taskDetectedAfterSync = false;

    public TaskAnalyser() {
        LOGGER.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider dip, CheckpointManager cp) {
        this.dip = dip;
        this.cp = cp;
    }

    public void setGM(GraphGenerator gm) {
        this.gm = gm;
        if (IS_DRAW_GRAPH) {
            this.gm.addSynchroToGraph(0);
        }
    }

    public void processTask(Task currentTask) {
        TaskDescription description = currentTask.getTaskDescription();
        LOGGER.info("New " + description.getType().toString().toLowerCase() + " task: Name:" + description.getName() + "), ID = " + currentTask.getId() + " APP = " + currentTask.getApplication().getId());
        if (IS_DRAW_GRAPH) {
            this.addNewTask(currentTask);
        }
        Application app = currentTask.getApplication();
        app.newTask(currentTask);
        int constrainingParam = -1;
        if (description.isReduction()) {
            this.reduceTasksNames.add(description.getName());
        }
        boolean taskHasEdge = this.processTaskParameters(app, currentTask, constrainingParam);
        this.registerIntermediateParameter(app, currentTask);
        this.markIntermediateParametersToDelete(app, currentTask);
        if (IS_DRAW_GRAPH && !taskHasEdge) {
            this.addEdgeFromMainToTask(currentTask);
        }
        this.cp.newTask(currentTask);
    }

    private boolean processTaskParameters(Application app, Task currentTask, int constrainingParam) {
        List<Parameter> parameters = currentTask.getParameters();
        boolean taskHasEdge = false;
        for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
            boolean isConstraining = paramIdx == constrainingParam;
            Parameter param = parameters.get(paramIdx);
            boolean paramHasEdge = this.registerParameterAccessAndAddDependencies(app, currentTask, param, isConstraining);
            taskHasEdge = taskHasEdge || paramHasEdge;
        }
        return taskHasEdge;
    }

    private void markIntermediateParametersToDelete(Application app, Task task) {
        for (Parameter p : task.getParameterDataToRemove()) {
            this.markParameterToDelete(app, p, true);
        }
    }

    private void registerIntermediateParameter(Application app, Task task) {
        for (Parameter p : task.getIntermediateParameters()) {
            this.registerParameterAccessAndAddDependencies(app, task, p, false);
        }
    }

    private void markParameterToDelete(Application app, Parameter p, boolean noReuse) {
        switch (p.getType()) {
            case DIRECTORY_T: {
                DirectoryParameter dp = (DirectoryParameter)p;
                this.dip.deleteData(app, dp.getLocation(), noReuse);
                break;
            }
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                this.dip.deleteData(app, fp.getLocation(), noReuse);
                break;
            }
            case OBJECT_T: 
            case PSCO_T: {
                ObjectParameter op = (ObjectParameter)p;
                this.dip.deleteData(app, op.getCode(), noReuse);
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter epscop = (ExternalPSCOParameter)p;
                this.dip.deleteData(app, epscop.getCode(), noReuse);
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bindingObjectparam = (BindingObjectParameter)p;
                this.dip.deleteData(app, bindingObjectparam.getCode(), noReuse);
                break;
            }
            case STREAM_T: {
                StreamParameter sp = (StreamParameter)p;
                this.dip.deleteData(app, sp.getCode(), noReuse);
                break;
            }
            case EXTERNAL_STREAM_T: {
                ExternalStreamParameter esp = (ExternalStreamParameter)p;
                this.dip.deleteData(app, esp.getLocation(), noReuse);
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                CollectiveParameter cParam = (CollectiveParameter)p;
                this.dip.deleteCollection(app, cParam.getCollectionId(), true);
                break;
            }
        }
    }

    public void snapshot() {
        this.cp.snapshot();
    }

    public DataAccessId processMainAccess(RegisterDataAccessRequest rdar) {
        DataAccessId daId;
        AccessParams access = rdar.getAccessParams();
        if (DEBUG) {
            LOGGER.debug("Registering access " + access.toString() + " from main code");
        }
        if ((daId = this.dip.registerDataAccess(access)) == null) {
            if (DEBUG) {
                LOGGER.debug("Accessing a canceled data from main code. Returning null");
            }
            return daId;
        }
        if (DEBUG) {
            LOGGER.debug("Registered access to data " + daId.getDataId() + " from main code");
        }
        if (access.getMode() != AccessParams.AccessMode.W) {
            int dataId = daId.getDataId();
            DataInstanceId di = daId.getDirection() == DataAccessId.Direction.R ? ((RAccessId)daId).getReadDataInstance() : ((RWAccessId)daId).getReadDataInstance();
            this.cp.mainAccess(di);
            DataAccessesInfo dai = this.accessesInfo.get(dataId);
            if (dai != null) {
                int dataVersion = 0;
                if (IS_DRAW_GRAPH) {
                    TreeSet<Integer> toPass = new TreeSet<Integer>();
                    toPass.add(dataId);
                    DataInstanceId dii = this.dip.getLastVersions(toPass).get(0);
                    dataVersion = dii.getVersionId();
                }
                dai.mainAccess(rdar, this, dataId, dataVersion);
            }
        }
        return daId;
    }

    public void endTask(AbstractTask aTask, boolean checkpointing) {
        int taskId = aTask.getId();
        long start = System.currentTimeMillis();
        if (aTask instanceof Task) {
            List<TaskListener> listeners;
            Task task = (Task)aTask;
            boolean isFree = task.isFree();
            TaskState taskState = task.getStatus();
            LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
            if (!isFree) {
                LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
                return;
            }
            switch (taskState) {
                case FAILED: {
                    OnFailure onFailure = task.getOnFailure();
                    if (onFailure == OnFailure.RETRY || onFailure == OnFailure.FAIL) {
                        ErrorManager.error(TASK_FAILED + task);
                        return;
                    }
                    if (onFailure != OnFailure.IGNORE && onFailure != OnFailure.CANCEL_SUCCESSORS) break;
                    ErrorManager.warn(TASK_FAILED + task);
                    break;
                }
                case CANCELED: {
                    ErrorManager.warn(TASK_CANCELED + task);
                    break;
                }
            }
            if (DEBUG) {
                LOGGER.debug("Marking accessed parameters for task " + taskId);
            }
            for (Parameter parameter : task.getTaskDescription().getParameters()) {
                this.updateParameterAccess(task, parameter);
                this.updateLastWritters(task, parameter);
            }
            for (Parameter parameter : task.getUnusedIntermediateParameters()) {
                this.updateParameterAccess(task, parameter);
                this.updateLastWritters(task, parameter);
            }
            if (DEBUG) {
                LOGGER.debug("Freeing barriers for task " + taskId);
            }
            if (DEBUG) {
                LOGGER.debug("Releasing waiting tasks for task " + taskId);
            }
            if ((listeners = task.getListeners()) != null) {
                for (TaskListener listener : listeners) {
                    listener.taskFinished();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Checking result file transfers for task " + taskId);
            }
            Application application = task.getApplication();
            application.endTask(task);
            TaskMonitor registeredMonitor = task.getTaskMonitor();
            switch (taskState) {
                case FAILED: {
                    registeredMonitor.onFailure();
                    break;
                }
                case CANCELED: {
                    registeredMonitor.onCancellation();
                    break;
                }
                default: {
                    registeredMonitor.onCompletion();
                }
            }
            this.releaseCommutativeGroups(task);
            if (!checkpointing) {
                if (DEBUG) {
                    LOGGER.debug("Checkpoint saving task " + taskId);
                }
                this.cp.endTask(task);
            }
        }
        if (DEBUG) {
            LOGGER.debug("Releasing data dependant tasks for task " + taskId);
        }
        aTask.releaseDataDependents();
        if (DEBUG) {
            long time = System.currentTimeMillis() - start;
            LOGGER.debug("Task " + taskId + " end message processed in " + time + " ms.");
        }
    }

    public void barrierGroup(BarrierGroupRequest request) {
        Application app = request.getApp();
        String groupName = request.getGroupName();
        app.reachesGroupBarrier(groupName, (Barrier)request);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewGroupBarrierToGraph(request);
            this.gm.commitGraph(false);
        }
    }

    public void barrier(BarrierRequest request) {
        Application app = request.getApp();
        app.reachesBarrier(request);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewBarrier();
            this.gm.commitGraph(false);
        }
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Application app = request.getApp();
        app.endReached(request);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.gm.commitGraph(true);
        }
    }

    public void deleteData(DataInfo dataInfo, boolean applicationDelete) {
        DataAccessesInfo dai;
        int dataId = dataInfo.getDataId();
        LOGGER.info("Deleting data " + dataId);
        if (applicationDelete) {
            this.cp.deletedData(dataInfo);
        }
        if ((dai = this.accessesInfo.remove(dataId)) != null) {
            switch (dai.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    break;
                }
                case FILE_T: {
                    Application.removeWrittenFileIdFromAllApps(dataId);
                    break;
                }
                case PSCO_T: {
                    Application.removeWrittenPSCOIdFromAllApps(dataId);
                    break;
                }
            }
        } else {
            LOGGER.warn("Writters info for data " + dataId + " not found.");
        }
    }

    public Set<Integer> getAndRemoveWrittenFiles(Application app) {
        return app.getWrittenFileIds();
    }

    public void shutdown() {
        if (IS_DRAW_GRAPH) {
            GraphGenerator.removeTemporaryGraph();
        }
        this.cp.shutdown();
    }

    public void setCurrentTaskGroup(Application app, boolean barrier, String groupName) {
        app.stackTaskGroup(groupName);
        if (IS_DRAW_GRAPH) {
            this.gm.addTaskGroupToGraph(groupName);
            LOGGER.debug("Group " + groupName + " added to graph");
        }
    }

    public void closeCurrentTaskGroup(Application app) {
        app.popGroup();
        if (IS_DRAW_GRAPH) {
            this.gm.closeGroupInGraph();
        }
    }

    private void releaseCommutativeGroups(Task task) {
        if (!task.getCommutativeGroupList().isEmpty()) {
            for (CommutativeGroupTask group : task.getCommutativeGroupList()) {
                group.getCommutativeTasks().remove(task);
                group.setStatus(TaskState.FINISHED);
                group.removePredecessor(task);
                if (!group.getPredecessors().isEmpty()) continue;
                group.releaseDataDependents();
                List<TaskListener> listeners = group.getListeners();
                if (listeners != null) {
                    for (TaskListener listener : listeners) {
                        listener.taskFinished();
                    }
                }
                if (!DEBUG) continue;
                LOGGER.debug("Group " + group.getId() + " ended execution");
                LOGGER.debug("Data dependents of group " + group.getCommutativeIdentifier() + " released ");
            }
        }
    }

    private boolean registerParameterAccessAndAddDependencies(Application app, Task currentTask, Parameter p, boolean isConstraining) {
        DataAccessId daId;
        DependencyParameter dp;
        AccessParams.AccessMode am = AccessParams.AccessMode.R;
        switch (p.getDirection()) {
            case IN: 
            case IN_DELETE: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        boolean hasParamEdge = false;
        switch (p.getType()) {
            case DIRECTORY_T: {
                dp = (DirectoryParameter)p;
                daId = this.dip.registerDataAccess(new FileAccessParams(app, am, ((DirectoryParameter)dp).getLocation()));
                break;
            }
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                daId = this.dip.registerDataAccess(new FileAccessParams(app, am, fp.getLocation()));
                break;
            }
            case PSCO_T: {
                ObjectParameter pscop = (ObjectParameter)p;
                pscop.setType(DataType.PSCO_T);
                daId = this.dip.registerDataAccess(new ObjectAccessParams<Object>(app, am, pscop.getValue(), pscop.getCode()));
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter externalPSCOparam = (ExternalPSCOParameter)p;
                externalPSCOparam.setType(DataType.EXTERNAL_PSCO_T);
                String pscoId = externalPSCOparam.getId();
                int code = externalPSCOparam.getCode();
                daId = this.dip.registerDataAccess(new ExternalPSCObjectAccessParams(app, am, pscoId, code));
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bop = (BindingObjectParameter)p;
                bop.setType(DataType.BINDING_OBJECT_T);
                BindingObject bo = bop.getBindingObject();
                daId = this.dip.registerDataAccess(new BindingObjectAccessParams(app, am, bo, bop.getCode()));
                break;
            }
            case OBJECT_T: {
                ObjectParameter op = (ObjectParameter)p;
                if (op.getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
                    op.setType(DataType.PSCO_T);
                }
                daId = this.dip.registerDataAccess(new ObjectAccessParams<Object>(app, am, op.getValue(), op.getCode()));
                break;
            }
            case STREAM_T: {
                StreamParameter sp = (StreamParameter)p;
                daId = this.dip.registerDataAccess(new StreamAccessParams<Object>(app, am, sp.getValue(), sp.getCode()));
                break;
            }
            case EXTERNAL_STREAM_T: {
                ExternalStreamParameter esp = (ExternalStreamParameter)p;
                daId = this.dip.registerDataAccess(new ExternalStreamAccessParams(app, am, esp.getLocation()));
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                CollectiveParameter cp = (CollectiveParameter)p;
                if (IS_DRAW_GRAPH) {
                    this.gm.startGroupingEdges();
                }
                for (Parameter content : cp.getElements()) {
                    boolean hasCollectionParamEdge = this.registerParameterAccessAndAddDependencies(app, currentTask, content, isConstraining);
                    hasParamEdge = hasParamEdge || hasCollectionParamEdge;
                }
                daId = this.dip.registerDataAccess(new CollectionAccessParams(app, am, cp.getCollectionId()));
                if (IS_DRAW_GRAPH) {
                    this.gm.stopGroupingEdges();
                }
                DataInfo ci = this.dip.deleteCollection(app, cp.getCollectionId(), true);
                this.deleteData(ci, false);
                break;
            }
            default: {
                daId = null;
                currentTask.registerFreeParam(p);
            }
        }
        if (daId != null) {
            dp = (DependencyParameter)p;
            dp.setDataAccessId(daId);
            hasParamEdge = this.addDependencies(am, currentTask, isConstraining, dp);
        }
        return hasParamEdge;
    }

    private boolean addDependencies(AccessParams.AccessMode am, Task currentTask, boolean isConstraining, DependencyParameter dp) {
        boolean hasParamEdge = false;
        DataAccessId daId = dp.getDataAccessId();
        int dataId = daId.getDataId();
        DataAccessesInfo dai = this.accessesInfo.get(dataId);
        switch (am) {
            case R: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                break;
            }
            case RW: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                this.registerOutputValues(currentTask, dp, false, dai);
                break;
            }
            case W: {
                this.registerOutputValues(currentTask, dp, false, dai);
                break;
            }
            case C: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, true, dataId, dai, isConstraining);
                this.registerOutputValues(currentTask, dp, true, dai);
                break;
            }
            case CV: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                this.registerOutputValues(currentTask, dp, false, dai);
            }
        }
        return hasParamEdge;
    }

    private boolean checkInputDependency(Task currentTask, DependencyParameter dp, boolean isConcurrent, int dataId, DataAccessesInfo dai, boolean isConstraining) {
        if (DEBUG) {
            LOGGER.debug("Checking READ dependency for datum " + dataId + " and task " + currentTask.getId());
        }
        boolean hasEdge = false;
        if (dai != null) {
            hasEdge = dai.readValue(currentTask, dp, isConcurrent, this);
            if (isConstraining) {
                AbstractTask lastWriter = dai.getConstrainingProducer();
                currentTask.setEnforcingTask((Task)lastWriter);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            currentTask.registerFreeParam(dp);
        }
        return hasEdge;
    }

    private void registerOutputValues(Task currentTask, DependencyParameter dp, boolean isConcurrent, DataAccessesInfo dai) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Application app = currentTask.getApplication();
        if (DEBUG) {
            LOGGER.debug("Checking WRITE dependency for datum " + dataId + " and task " + currentTaskId);
        }
        if (dai == null) {
            dai = DataAccessesInfo.createAccessInfo(dp.getType());
            this.accessesInfo.put(dataId, dai);
        }
        dai.writeValue(currentTask, dp, isConcurrent, this);
        switch (dp.getType()) {
            case DIRECTORY_T: 
            case FILE_T: {
                app.addWrittenFileId(dataId);
                break;
            }
            case PSCO_T: {
                app.addWrittenPSCOId(dataId);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dataId + " is task " + currentTaskId);
        }
    }

    private void updateLastWritters(AbstractTask task, Parameter p) {
        DataType type;
        if (p.isCollective()) {
            CollectiveParameter cParam = (CollectiveParameter)p;
            for (Parameter sp : cParam.getElements()) {
                this.updateLastWritters(task, sp);
            }
        }
        if ((type = p.getType()) == DataType.FILE_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T || type == DataType.DICT_COLLECTION_T) {
            DataAccessesInfo dai;
            DependencyParameter dp = (DependencyParameter)p;
            int dataId = dp.getDataAccessId().getDataId();
            if (DEBUG) {
                int currentTaskId = task.getId();
                LOGGER.debug("Removing writters info for datum " + dataId + " and task " + currentTaskId);
            }
            if ((dai = this.accessesInfo.get(dataId)) != null) {
                switch (dp.getDirection()) {
                    case OUT: 
                    case INOUT: {
                        dai.completedProducer(task, this);
                        break;
                    }
                }
            }
        }
    }

    private void updateParameterAccess(Task t, Parameter p) {
        DataType type;
        if (p.isCollective()) {
            for (Parameter subParam : ((CollectiveParameter)p).getElements()) {
                this.updateParameterAccess(t, subParam);
            }
        }
        if ((type = p.getType()) == DataType.FILE_T || type == DataType.DIRECTORY_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.STREAM_T || type == DataType.EXTERNAL_STREAM_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T || type == DataType.DICT_COLLECTION_T) {
            DependencyParameter dPar = (DependencyParameter)p;
            DataAccessId dAccId = dPar.getDataAccessId();
            if (DEBUG) {
                LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + dPar.getDataTarget());
            }
            if (t.getOnFailure() == OnFailure.CANCEL_SUCCESSORS && t.getStatus() == TaskState.FAILED || t.getStatus() == TaskState.CANCELED) {
                this.dip.dataAccessHasBeenCanceled(dAccId, t.wasSubmited());
            } else {
                this.dip.dataHasBeenAccessed(dAccId);
            }
        }
    }

    private void addMissingCommutativeTasksToGraph() {
        this.gm.closeCommutativeGroups();
    }

    @Override
    public void drawTaskInCommutativeGroup(Task task, CommutativeGroupTask group) {
        this.gm.addTaskToCommutativeGroup(task, group.getCommutativeIdentifier().toString());
    }

    @Override
    public void closeCommutativeTasksGroup(CommutativeGroupTask group) {
        this.gm.closeCommutativeGroup(group.getCommutativeIdentifier().toString());
    }

    @Override
    public void drawStandardEdge(Task consumer, DataAccessId daId, AbstractTask producer) {
        int dataVersion;
        int dataId = daId.getDataId();
        DataAccessId.Direction d = daId.getDirection();
        switch (d) {
            case C: 
            case R: {
                dataVersion = ((RAccessId)daId).getRVersionId();
                break;
            }
            case W: {
                dataVersion = ((WAccessId)daId).getWVersionId();
                break;
            }
            default: {
                dataVersion = ((RWAccessId)daId).getRVersionId();
            }
        }
        if (producer != null && producer != consumer) {
            if (producer instanceof Task) {
                this.addDataEdgeFromTaskToTask((Task)producer, consumer, dataId, dataVersion);
            } else {
                this.addEdgeFromCommutativeToTask(consumer, dataId, dataVersion, (CommutativeGroupTask)producer, true);
            }
        } else {
            this.addDataEdgeFromMainToTask(consumer, dataId, dataVersion);
        }
    }

    @Override
    public void drawStreamEdge(AbstractTask currentTask, Integer dataId, boolean isWrite) {
        String stream = "Stream" + dataId;
        this.addStreamToGraph(stream);
        this.addStreamEdge(currentTask, stream, isWrite);
    }

    private void addNewTask(Task task) {
        task.setSynchronizationId(this.synchronizationId);
        this.taskDetectedAfterSync = true;
        this.addTaskToGraph(task);
    }

    private void addTaskToGraph(Task task) {
        this.gm.addTaskToGraph(task);
    }

    private void addStreamToGraph(String stream) {
        this.gm.addStreamToGraph(stream);
    }

    private void addDataEdgeFromTaskToTask(Task source, Task dest, int dataId, int dataVersion) {
        if (source.getSynchronizationId() == dest.getSynchronizationId()) {
            String src = String.valueOf(source.getId());
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        } else {
            String src = "Synchro" + dest.getSynchronizationId();
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        }
    }

    private void addDataEdgeFromMainToTask(Task dest, int dataId, int dataVersion) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addEdgeFromMainToTask(Task dest) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = "";
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    @Override
    public void addEdgeFromTaskToMain(AbstractTask task, EdgeType edgeType, int dataId, int dataVersion) {
        if (this.taskDetectedAfterSync) {
            this.taskDetectedAfterSync = false;
            int oldSyncId = this.synchronizationId++;
            this.gm.addSynchroToGraph(this.synchronizationId);
            String oldSync = "Synchro" + oldSyncId;
            String currentSync = "Synchro" + this.synchronizationId;
            this.gm.addEdgeToGraph(oldSync, currentSync, edgeType, "");
        }
        String dest = "Synchro" + this.synchronizationId;
        if (task instanceof CommutativeGroupTask && !((CommutativeGroupTask)task).getCommutativeTasks().isEmpty()) {
            CommutativeGroupTask commGroupTask = (CommutativeGroupTask)task;
            String src = String.valueOf(commGroupTask.getCommutativeTasks().get(0).getId());
            String groupId = commGroupTask.getCommutativeIdentifier().toString();
            this.gm.addEdgeToGraphFromGroup(src, dest, String.valueOf(dataId) + "v" + String.valueOf(dataVersion), groupId, "clusterCommutative", edgeType);
        } else {
            String src = String.valueOf(task.getId());
            this.gm.addEdgeToGraph(src, dest, edgeType, String.valueOf(dataId) + "v" + String.valueOf(dataVersion));
        }
    }

    private void addStreamEdge(AbstractTask task, String stream, boolean isWrite) {
        String taskId = String.valueOf(task.getId());
        if (isWrite) {
            this.gm.addEdgeToGraph(taskId, stream, EdgeType.STREAM_DEPENDENCY, "");
        } else {
            this.gm.addEdgeToGraph(stream, taskId, EdgeType.STREAM_DEPENDENCY, "");
        }
    }

    private void addEdgeFromCommutativeToTask(Task dest, int dataId, int dataVersion, CommutativeGroupTask cgt, boolean comToTask) {
        String src = String.valueOf(cgt.getCommutativeTasks().get(0).getId());
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        String comId = cgt.getCommutativeIdentifier().toString();
        if (comToTask) {
            this.gm.addEdgeToGraphFromGroup(src, dst, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        } else {
            this.gm.addEdgeToGraphFromGroup(dst, src, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        }
    }

    private void addNewBarrier() {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        String newSyncStr = "Synchro" + this.synchronizationId;
        this.gm.addBarrierToGraph(this.synchronizationId);
        this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        this.taskDetectedAfterSync = false;
        HashSet<AbstractTask> uniqueWriters = new HashSet<AbstractTask>();
        for (DataAccessesInfo dai : this.accessesInfo.values()) {
            if (dai == null) continue;
            List<AbstractTask> dataWriters = dai.getDataWriters();
            uniqueWriters.addAll(dataWriters);
        }
        for (AbstractTask writer : uniqueWriters) {
            if (writer == null || writer.getSynchronizationId() != oldSync) continue;
            String taskId = String.valueOf(writer.getId());
            this.gm.addEdgeToGraph(taskId, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        }
    }

    private void addNewGroupBarrierToGraph(BarrierGroupRequest barrier) {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        String newSyncStr = "Synchro" + this.synchronizationId;
        this.gm.addBarrierToGraph(this.synchronizationId);
        this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        this.taskDetectedAfterSync = false;
        int groupsLastTaskID = barrier.getGraphSource();
        if (groupsLastTaskID > 0) {
            String src = String.valueOf(groupsLastTaskID);
            String groupName = barrier.getGroupName();
            this.gm.addEdgeToGraphFromGroup(src, newSyncStr, "", groupName, "clusterTasks", EdgeType.USER_DEPENDENCY);
        }
    }
}

