/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.api.ApplicationRunner;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.WallClockTimerTask;
import es.bsc.compss.types.data.DataInfo;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Application {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    private static final Random APP_ID_GENERATOR = new SecureRandom();
    private static final TreeMap<Long, Application> APPLICATIONS = new TreeMap();
    private static final Application NO_APPLICATION = new Application(null, null, null);
    private final Long id;
    private final String parallelismSource;
    private TimerTask wallClockKiller;
    private final ApplicationRunner runner;
    private int totalTaskCount;
    private TreeMap<String, TaskGroup> taskGroups;
    private Stack<TaskGroup> currentTaskGroups;
    private LinkedList<DataInfo> data;
    private final TreeMap<String, Integer> nameToId;
    private final TreeMap<String, Integer> collectionToId;
    private Set<Integer> writtenFileDataIds;
    private Set<Integer> writtenPSCODataIds;

    public static String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Application app : APPLICATIONS.values()) {
            Long appId = app.getId();
            Integer totalTaskCount = app.totalTaskCount;
            TaskGroup appBaseGroup = (TaskGroup)app.currentTaskGroups.firstElement();
            Integer taskCount = appBaseGroup.getTasks().size();
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public static Application registerApplication() {
        return Application.registerApplication(null, null);
    }

    public static Application registerApplication(Long appId) {
        return Application.registerApplication(appId, null, null);
    }

    public static Application registerApplication(String parallelismSource, ApplicationRunner runner) {
        Long appId = APP_ID_GENERATOR.nextLong();
        while (APPLICATIONS.containsKey(appId)) {
            appId = APP_ID_GENERATOR.nextLong();
        }
        return Application.registerApplication(appId, parallelismSource, runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application registerApplication(Long appId, String parallelismSource, ApplicationRunner runner) {
        Application app;
        if (appId == null) {
            LOGGER.error("No application id", (Throwable)new Exception("Application id is null"));
            app = NO_APPLICATION;
        } else {
            TreeMap<Long, Application> treeMap = APPLICATIONS;
            synchronized (treeMap) {
                app = APPLICATIONS.get(appId);
                if (app == null) {
                    app = new Application(appId, parallelismSource, runner);
                    APPLICATIONS.put(appId, app);
                }
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application deregisterApplication(Long appId) {
        Application app;
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            app = APPLICATIONS.remove(appId);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWrittenFileIdFromAllApps(int dataId) {
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            for (Application app : APPLICATIONS.values()) {
                app.removeWrittenFileId(dataId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWrittenPSCOIdFromAllApps(int dataId) {
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            for (Application app : APPLICATIONS.values()) {
                app.removeWrittenPSCOId(dataId);
            }
        }
    }

    private Application(Long appId, String parallelismSource, ApplicationRunner runner) {
        this.id = appId;
        this.parallelismSource = parallelismSource;
        this.runner = runner;
        this.totalTaskCount = 0;
        this.currentTaskGroups = new Stack();
        this.taskGroups = new TreeMap();
        this.stackTaskGroup("App" + appId);
        this.data = new LinkedList();
        this.nameToId = new TreeMap();
        this.collectionToId = new TreeMap();
        this.writtenFileDataIds = new HashSet<Integer>();
        this.writtenPSCODataIds = new HashSet<Integer>();
    }

    public Long getId() {
        return this.id;
    }

    public String getParallelismSource() {
        return this.parallelismSource;
    }

    public final void stackTaskGroup(String groupName) {
        LOGGER.debug("Adding group " + groupName + " to the current groups stack.");
        TaskGroup tg = new TaskGroup(groupName, this);
        this.currentTaskGroups.push(tg);
        this.taskGroups.put(groupName, tg);
    }

    public final void popGroup() {
        TaskGroup tg = this.currentTaskGroups.pop();
        tg.setClosed();
    }

    public Iterable<TaskGroup> getCurrentGroups() {
        return this.currentTaskGroups;
    }

    public TaskGroup getBaseTaskGroup() {
        return (TaskGroup)this.currentTaskGroups.firstElement();
    }

    public TaskGroup getGroup(String groupName) {
        return this.taskGroups.get(groupName);
    }

    public TaskGroup removeGroup(String name) {
        return this.taskGroups.remove(name);
    }

    public void newTask(Task task) {
        ++this.totalTaskCount;
        for (TaskGroup group : this.getCurrentGroups()) {
            task.addTaskGroup(group);
            group.addTask(task);
        }
    }

    public void endTask(Task task) {
        for (TaskGroup group : task.getTaskGroupList()) {
            group.removeTask(task);
            LOGGER.debug("Group " + group.getName() + " released task " + task.getId());
            if (group.hasPendingTasks()) continue;
            LOGGER.debug("All tasks of group " + group.getName() + " have finished execution");
            if (!group.hasBarrier()) continue;
            group.releaseBarrier();
            if (!group.isClosed()) continue;
            this.removeGroup(group.getName());
        }
    }

    public void stalled() {
        if (this.runner != null) {
            this.runner.stalledApplication();
        }
    }

    public void readyToContinue(Semaphore sem) {
        if (this.runner != null) {
            this.runner.readyToContinue(sem);
        } else {
            sem.release();
        }
    }

    private void reachesGroupBarrier(TaskGroup tg, Barrier request) {
        if (tg != null) {
            tg.registerBarrier(request);
        } else {
            request.release();
        }
    }

    public final void reachesGroupBarrier(String groupName, Barrier request) {
        TaskGroup tg = this.getGroup(groupName);
        this.reachesGroupBarrier(tg, request);
    }

    public final void reachesBarrier(Barrier barrier) {
        TaskGroup baseGroup = (TaskGroup)this.currentTaskGroups.firstElement();
        this.reachesGroupBarrier(baseGroup, barrier);
    }

    public final void endReached(Barrier barrier) {
        this.reachesBarrier(barrier);
    }

    public void addData(DataInfo di) {
        this.data.add(di);
    }

    public void removeData(DataInfo di) {
        this.data.remove(di);
    }

    public void registerFileData(String locationKey, DataInfo di) {
        this.nameToId.put(locationKey, di.getDataId());
    }

    public Integer getFileDataId(String locationKey) {
        return this.nameToId.get(locationKey);
    }

    public void removeFileData(String locationKey) {
        this.nameToId.remove(locationKey);
    }

    public void registerCollectionData(String collectionId, DataInfo di) {
        this.collectionToId.put(collectionId, di.getDataId());
    }

    public Integer getCollectionDataId(String collectionId) {
        return this.collectionToId.get(collectionId);
    }

    public void removeCollectionData(String collectionId) {
        this.collectionToId.remove(collectionId);
    }

    public List<DataInfo> popAllData() {
        LinkedList<DataInfo> localData = this.data;
        this.data = new LinkedList();
        return localData;
    }

    public void addWrittenFileId(int dataId) {
        this.writtenFileDataIds.add(dataId);
    }

    public void removeWrittenFileId(int dataId) {
        if (this.writtenFileDataIds.remove(dataId)) {
            LOGGER.info(" Removed data " + dataId + " from written files");
        }
    }

    public Set<Integer> getWrittenFileIds() {
        return this.writtenFileDataIds;
    }

    public void addWrittenPSCOId(int dataId) {
        this.writtenPSCODataIds.add(dataId);
    }

    public void removeWrittenPSCOId(int dataId) {
        if (this.writtenPSCODataIds.remove(dataId)) {
            LOGGER.info(" Removed data " + dataId + " from written pscos");
        }
    }

    public void setTimerTask(WallClockTimerTask wcTimerTask) {
        this.wallClockKiller = wcTimerTask;
    }

    public void cancelTimerTask() {
        if (this.wallClockKiller != null) {
            this.wallClockKiller.cancel();
            this.wallClockKiller = null;
        }
    }
}

