/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessid;

import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;

public class RAccessId
extends DataAccessId {
    private static final long serialVersionUID = 1L;
    private DataVersion readDataVersion;

    public RAccessId() {
    }

    public RAccessId(int dataId, int rVersionId) {
        this.readDataVersion = new DataVersion(dataId, rVersionId);
    }

    public RAccessId(DataVersion rdv) {
        this.readDataVersion = rdv;
    }

    @Override
    public int getDataId() {
        return this.readDataVersion.getDataInstanceId().getDataId();
    }

    @Override
    public DataAccessId.Direction getDirection() {
        return DataAccessId.Direction.R;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.readDataVersion.hasMoreReaders() || this.readDataVersion.getDataInstanceId().getVersionId() == 1;
    }

    @Override
    public boolean isWrite() {
        return false;
    }

    public DataVersion getReadDataVersion() {
        return this.readDataVersion;
    }

    public DataInstanceId getReadDataInstance() {
        return this.readDataVersion.getDataInstanceId();
    }

    public int getRVersionId() {
        return this.readDataVersion.getDataInstanceId().getVersionId();
    }

    public String toString() {
        return "Read data: " + this.readDataVersion.getDataInstanceId() + (this.isPreserveSourceData() ? ", Preserved" : ", Erased");
    }

    @Override
    public boolean isValidVersion() {
        return !this.readDataVersion.hasBeenCancelled();
    }
}

