/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.DataParams;
import es.bsc.compss.types.data.location.DataLocation;

public class FileAccessParams
extends AccessParams {
    private static final long serialVersionUID = 1L;
    private DataLocation loc;

    public FileAccessParams(Application app, AccessParams.AccessMode mode, DataLocation loc) {
        super(new DataParams.FileData(app, loc), mode);
        this.loc = loc;
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerLocation(renaming, this.loc);
        }
    }

    @Override
    public void externalRegister() {
    }

    public String toString() {
        return "[" + this.getApp() + ", " + (Object)((Object)this.mode) + " ," + this.loc + "]";
    }
}

