/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.DataParams;

public class ObjectAccessParams<T>
extends AccessParams {
    private static final long serialVersionUID = 1L;
    private int hashCode;
    private T value;

    public ObjectAccessParams(Application app, AccessParams.AccessMode mode, T value, int hashCode) {
        super(new DataParams.ObjectData(app, hashCode), mode);
        this.value = value;
        this.hashCode = hashCode;
    }

    protected ObjectAccessParams(DataParams.ObjectData data, AccessParams.AccessMode mode, T value, int hashCode) {
        super(data, mode);
        this.value = value;
        this.hashCode = hashCode;
    }

    public T getValue() {
        return this.value;
    }

    public int getCode() {
        return this.hashCode;
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerValue(renaming, this.value);
        }
    }

    @Override
    public void externalRegister() {
    }

    public String toString() {
        return "[" + this.getApp() + ", " + (Object)((Object)this.mode) + " ," + this.hashCode + "]";
    }
}

