/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.DataParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;
import es.bsc.distrostreamlib.api.DistroStream;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.requests.AddStreamWriterRequest;

public class StreamAccessParams<T>
extends ObjectAccessParams<T> {
    private static final long serialVersionUID = 1L;

    public StreamAccessParams(Application app, AccessParams.AccessMode mode, T value, int hashCode) {
        super(new DataParams.StreamData(app, hashCode), mode, value, hashCode);
    }

    protected StreamAccessParams(DataParams.StreamData data, AccessParams.AccessMode mode, T value, int hashCode) {
        super(data, mode, value, hashCode);
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataInstanceId lastDID = dInfo.getCurrentDataVersion().getDataInstanceId();
        String renaming = lastDID.getRenaming();
        Comm.registerValue(renaming, this.getValue());
    }

    @Override
    public void externalRegister() {
        if (this.mode != AccessParams.AccessMode.R) {
            DistroStream ds = (DistroStream)this.getValue();
            String streamId = ds.getId();
            if (DEBUG) {
                LOGGER.debug("Registering writer for stream " + streamId);
            }
            AddStreamWriterRequest req = new AddStreamWriterRequest(streamId);
            DistroStreamClient.request(req);
        }
    }
}

