/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessparams.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class DataGetLastVersionRequest
extends APRequest {
    private final Semaphore sem = new Semaphore(0);
    private final DataParams data;
    private LogicalData response;

    public DataGetLastVersionRequest(DataParams data) {
        this.data = data;
    }

    public LogicalData getData() {
        this.sem.acquireUninterruptibly();
        return this.response;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        this.response = dip.getDataLastVersion(this.data);
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.AP_GET_LAST_DATA;
    }
}

