/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.ObjectInfo;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.tracing.TraceEvent;

public class DeregisterObject
extends APRequest {
    private final Application app;
    private final int hashCode;

    public DeregisterObject(Application app, Object o, int hashcode) {
        this.app = app;
        this.hashCode = o.hashCode();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DEREGISTER_OBJECT;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) throws ShutdownException {
        ObjectInfo objectInfo = (ObjectInfo)dip.deleteData(this.app, this.hashCode, true);
        if (objectInfo == null) {
            LOGGER.info("The object with code: " + String.valueOf(this.hashCode) + " is not used by any task");
            return;
        }
        LOGGER.info("Data of : " + String.valueOf(this.hashCode) + " deleted");
        ta.deleteData(objectInfo, false);
    }
}

