/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.TaskListener;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class RegisterDataAccessRequest
extends APRequest
implements TaskListener {
    private final AccessParams accessParams;
    private DataAccessId accessId;
    private final AccessParams.AccessMode accessMode;
    private int pendingOperation = 0;
    private boolean released = false;
    private final Semaphore sem;

    public RegisterDataAccessRequest(AccessParams access, AccessParams.AccessMode accessMode) {
        this.accessParams = access;
        this.accessMode = accessMode;
        this.sem = new Semaphore(0);
    }

    public AccessParams getAccessParams() {
        return this.accessParams;
    }

    public AccessParams.AccessMode getTaskAccessMode() {
        return this.accessMode;
    }

    public DataAccessId getAccessId() {
        return this.accessId;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        this.accessId = ta.processMainAccess(this);
        if (this.pendingOperation == 0) {
            if (DEBUG) {
                if (this.accessId != null) {
                    int dataId = this.accessId.getDataId();
                    LOGGER.debug("Data " + dataId + " available for main access");
                } else {
                    LOGGER.debug("Accessed data was canceled");
                }
            }
            this.released = true;
            this.sem.release();
        }
        this.sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        this.sem.acquireUninterruptibly();
        boolean stalled = false;
        Application app = this.accessParams.getApp();
        RegisterDataAccessRequest registerDataAccessRequest = this;
        synchronized (registerDataAccessRequest) {
            LOGGER.info("App " + app.getId() + " waits for data to be produced");
            if (!this.released) {
                LOGGER.info("App " + app.getId() + " releases its resources.");
                stalled = true;
                app.stalled();
            }
        }
        LOGGER.info("App " + app.getId() + " awaits for data to be produced.");
        this.sem.acquireUninterruptibly();
        LOGGER.info("App " + app.getId() + " waiting data is produced.");
        if (stalled) {
            LOGGER.info("App " + app.getId() + " waits for resources.");
            app.readyToContinue(this.sem);
            this.sem.acquireUninterruptibly();
            LOGGER.info("App " + app.getId() + " reasources are ready.");
        }
    }

    public void addPendingOperation() {
        ++this.pendingOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskFinished() {
        Application app = this.accessParams.getApp();
        RegisterDataAccessRequest registerDataAccessRequest = this;
        synchronized (registerDataAccessRequest) {
            --this.pendingOperation;
            if (this.pendingOperation == 0) {
                if (DEBUG) {
                    int dataId = this.accessId.getDataId();
                    LOGGER.debug("Data " + dataId + " available for main access");
                }
                this.sem.release();
                this.released = true;
            }
        }
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.REGISTER_DATA_ACCESS;
    }
}

