/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.local;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamURI;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.List;

public class LocalParameter
implements InvocationParam {
    private final Parameter param;
    private final DataType originalType;
    private final boolean preserveSourceData;
    private final boolean writeFinalValue;
    private final String dataMgmtId;
    private final String sourceDataMgmtId;
    private String originalName;
    private String renamedName;
    private Object value;
    private Class<?> valueClass;
    private boolean forwardedResult;

    public LocalParameter() {
        this.param = null;
        this.originalType = null;
        this.preserveSourceData = false;
        this.writeFinalValue = false;
        this.sourceDataMgmtId = null;
        this.dataMgmtId = null;
        this.forwardedResult = false;
    }

    public LocalParameter(Parameter param) {
        DataType type;
        this.param = param;
        this.originalType = type = param.getType();
        switch (type) {
            case FILE_T: 
            case DIRECTORY_T: 
            case OBJECT_T: 
            case COLLECTION_T: 
            case DICT_COLLECTION_T: 
            case STREAM_T: 
            case PSCO_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: 
            case BINDING_OBJECT_T: {
                String pscoId;
                DependencyParameter dPar = (DependencyParameter)param;
                this.value = dPar.getDataTarget();
                this.preserveSourceData = dPar.isSourcePreserved();
                DataAccessId faId = dPar.getDataAccessId();
                if (faId instanceof RWAccessId) {
                    RWAccessId rwaId = (RWAccessId)faId;
                    this.dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
                    this.sourceDataMgmtId = "tmp" + this.dataMgmtId;
                } else if (faId instanceof RAccessId) {
                    RAccessId raId = (RAccessId)faId;
                    this.dataMgmtId = this.sourceDataMgmtId = raId.getReadDataInstance().getRenaming();
                } else {
                    WAccessId waId = (WAccessId)faId;
                    this.sourceDataMgmtId = null;
                    this.dataMgmtId = waId.getWrittenDataInstance().getRenaming();
                }
                if (this.sourceDataMgmtId != null && (pscoId = Comm.getData(this.sourceDataMgmtId).getPscoId()) != null) {
                    if (type.equals((Object)DataType.OBJECT_T)) {
                        param.setType(DataType.PSCO_T);
                    } else if (type.equals((Object)DataType.FILE_T)) {
                        param.setType(DataType.EXTERNAL_PSCO_T);
                    }
                    this.param.setType(param.getType());
                }
                this.writeFinalValue = faId.isWrite();
                this.originalName = dPar.getOriginalName();
                break;
            }
            default: {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                this.value = btParB.getValue();
                this.preserveSourceData = false;
                this.writeFinalValue = false;
                this.sourceDataMgmtId = null;
                this.dataMgmtId = null;
            }
        }
        this.forwardedResult = false;
    }

    @Override
    public String getName() {
        return this.param.getName();
    }

    @Override
    public String getContentType() {
        return this.param.getContentType();
    }

    @Override
    public void setType(DataType type) {
        this.param.setType(type);
    }

    @Override
    public DataType getType() {
        return this.param.getType();
    }

    @Override
    public boolean isCollective() {
        return false;
    }

    public DataType getOriginalType() {
        return this.originalType;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    @Override
    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    @Override
    public String getPrefix() {
        return this.param.getPrefix();
    }

    @Override
    public StdIOStream getStdIOStream() {
        return this.param.getStream();
    }

    @Override
    public double getWeight() {
        return this.param.getWeight();
    }

    @Override
    public boolean isKeepRename() {
        return this.param.isKeepRename();
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public String getRenamedName() {
        return this.renamedName;
    }

    @Override
    public void setRenamedName(String renamedName) {
        this.renamedName = renamedName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public void setValueClass(Class<?> valClass) {
        this.valueClass = valClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    @Override
    public String getSourceDataId() {
        return this.sourceDataMgmtId;
    }

    @Override
    public List<? extends InvocationParamURI> getSources() {
        return null;
    }

    @Override
    public void resultIsForwarded() {
        this.forwardedResult = true;
    }

    @Override
    public boolean isForwardedResult() {
        return this.forwardedResult;
    }

    public Parameter getParam() {
        return this.param;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.getValue() + " " + (this.isPreserveSourceData() ? "PRESERVE" : "VOLATILE") + " " + (this.isWriteFinalValue() ? "WRITE" : "DISMISS") + " originalName " + this.originalName + " renamedName " + this.renamedName + " sourceData " + this.sourceDataMgmtId + " finalData " + this.dataMgmtId;
    }
}

