/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.accesses;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StandardDataAccessesInfo
extends DataAccessesInfo {
    private AbstractTask lastWriter;
    private final List<Task> concurrentReaders = new ArrayList<Task>();

    public StandardDataAccessesInfo(DataType dataType) {
        super(dataType);
    }

    @Override
    public void completedProducer(AbstractTask task, GraphHandler gh) {
        int producerTaskId = task.getId();
        if (this.lastWriter != null && this.lastWriter.getId() == producerTaskId) {
            this.updateLastWriter(null, gh);
        }
    }

    @Override
    public AbstractTask getConstrainingProducer() {
        return this.lastWriter;
    }

    @Override
    public boolean readValue(Task task, DependencyParameter dp, boolean isConcurrent, GraphHandler gh) {
        if (this.concurrentReaders.isEmpty() || isConcurrent) {
            return this.readDependency(task, dp, gh);
        }
        return this.concurrentDependency(task, dp, gh);
    }

    private boolean readDependency(Task task, DependencyParameter dp, GraphHandler gh) {
        int dataId = dp.getDataAccessId().getDataId();
        boolean hasEdge = false;
        if (this.lastWriter != null && this.lastWriter != task) {
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dataId + " is task " + this.lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + this.lastWriter.getId() + " and task " + task.getId());
            }
            if (this.lastWriter instanceof CommutativeGroupTask) {
                CommutativeGroupTask group = (CommutativeGroupTask)this.lastWriter;
                if (dp.getDirection() == Direction.COMMUTATIVE && !group.isClosed()) {
                    Integer coreId = task.getTaskDescription().getCoreElement().getCoreId();
                    CommutativeIdentifier comId = new CommutativeIdentifier(coreId, dataId);
                    if (CommutativeIdentifier.equals(group.getCommutativeIdentifier(), comId)) {
                        AbstractTask predecessor = group.getGroupPredecessor();
                        if (predecessor != null) {
                            task.addDataDependency(predecessor, dp);
                            if (IS_DRAW_GRAPH) {
                                gh.drawStandardEdge(task, group.getGroupPredecessorAccess(), predecessor);
                            }
                            hasEdge = true;
                        }
                        return hasEdge;
                    }
                }
                this.closeCommutativeTasksGroup(group, gh);
            }
            task.addDataDependency(this.lastWriter, dp);
            if (IS_DRAW_GRAPH) {
                gh.drawStandardEdge(task, dp.getDataAccessId(), this.lastWriter);
            }
            hasEdge = true;
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            task.registerFreeParam(dp);
        }
        return hasEdge;
    }

    private boolean concurrentDependency(Task task, DependencyParameter dp, GraphHandler gh) {
        int dataId = dp.getDataAccessId().getDataId();
        if (!this.concurrentReaders.contains(task)) {
            if (DEBUG) {
                LOGGER.debug("There was a concurrent access for datum " + dataId);
                LOGGER.debug("Adding dependency between concurrent list and task " + task.getId());
            }
            for (AbstractTask abstractTask : this.concurrentReaders) {
                task.addDataDependency(abstractTask, dp);
                if (!IS_DRAW_GRAPH) continue;
                gh.drawStandardEdge(task, dp.getDataAccessId(), abstractTask);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            task.registerFreeParam(dp);
        }
        return true;
    }

    @Override
    public void writeValue(Task t, DependencyParameter dp, boolean isConcurrent, GraphHandler gh) {
        if (isConcurrent) {
            this.concurrentReaders.add(t);
        } else {
            int dataId = dp.getDataAccessId().getDataId();
            LOGGER.info("Setting writer for data " + dataId);
            if (dp.getDirection() == Direction.COMMUTATIVE) {
                CommutativeGroupTask prevGroup;
                Integer coreId = t.getTaskDescription().getCoreElement().getCoreId();
                CommutativeIdentifier comId = new CommutativeIdentifier(coreId, dataId);
                CommutativeGroupTask group = null;
                if (this.lastWriter instanceof CommutativeGroupTask && CommutativeIdentifier.equals((prevGroup = (CommutativeGroupTask)this.lastWriter).getCommutativeIdentifier(), comId) && !prevGroup.isClosed()) {
                    group = prevGroup;
                }
                DataAccessId daId = dp.getDataAccessId();
                if (group == null) {
                    Application app = t.getApplication();
                    group = new CommutativeGroupTask(app, comId);
                    group.setGroupPredecessor(this.lastWriter, (RWAccessId)daId);
                }
                group.addAccess((RWAccessId)daId);
                group.addCommutativeTask(t);
                group.addDataDependency(t, dp);
                t.setCommutativeGroup(group, daId);
                dp.setDataAccessId(group.getAccessPlaceHolder());
                if (IS_DRAW_GRAPH) {
                    gh.drawTaskInCommutativeGroup(t, group);
                }
                this.updateLastWriter(group, gh);
            } else {
                this.updateLastWriter(t, gh);
            }
            this.concurrentReaders.clear();
        }
    }

    private void updateLastWriter(AbstractTask newWriter, GraphHandler gh) {
        if (this.lastWriter != newWriter && this.lastWriter instanceof CommutativeGroupTask) {
            CommutativeGroupTask prevGroup = (CommutativeGroupTask)this.lastWriter;
            this.closeCommutativeTasksGroup(prevGroup, gh);
        }
        this.lastWriter = newWriter;
    }

    private void closeCommutativeTasksGroup(CommutativeGroupTask group, GraphHandler gh) {
        if (!group.isClosed()) {
            group.close();
            if (IS_DRAW_GRAPH) {
                gh.closeCommutativeTasksGroup(group);
            }
        }
    }

    @Override
    public void mainAccess(RegisterDataAccessRequest rdar, GraphHandler gh, DataInstanceId accessedData) {
        if (this.lastWriter != null) {
            if (IS_DRAW_GRAPH) {
                gh.addEdgeFromTaskToMain(this.lastWriter, EdgeType.DATA_DEPENDENCY, accessedData);
            }
            if (this.lastWriter.isPending()) {
                this.lastWriter.addListener(rdar);
                rdar.addPendingOperation();
                if (rdar.getTaskAccessMode() == AccessParams.AccessMode.RW) {
                    this.updateLastWriter(null, gh);
                }
            }
        }
        for (AbstractTask abstractTask : this.concurrentReaders) {
            if (IS_DRAW_GRAPH) {
                gh.addEdgeFromTaskToMain(abstractTask, EdgeType.DATA_DEPENDENCY, accessedData);
            }
            if (abstractTask == null || !abstractTask.isPending()) continue;
            abstractTask.addListener(rdar);
            rdar.addPendingOperation();
        }
        this.concurrentReaders.clear();
    }

    @Override
    public boolean isFinalProducer(Task t) {
        return this.concurrentReaders.isEmpty() && this.lastWriter == t;
    }

    @Override
    public String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("concurrentReaders = [");
        for (AbstractTask abstractTask : this.concurrentReaders) {
            sb.append(abstractTask.getId()).append(" ");
        }
        sb.append("], ");
        sb.append("dataWriter = ").append(this.lastWriter != null ? Integer.valueOf(this.lastWriter.getId()) : "null");
        return sb.toString();
    }

    @Override
    public List<AbstractTask> getDataWriters() {
        LinkedList<AbstractTask> writers = new LinkedList<AbstractTask>();
        if (this.lastWriter != null) {
            writers.add(this.lastWriter);
        }
        return writers;
    }
}

