/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;

public class ExternalPSCObjectAccessParams
extends ObjectAccessParams<String, DataParams.ExternalPSCObjectData> {
    private static final long serialVersionUID = 1L;

    public static final ExternalPSCObjectAccessParams constructEPOAP(Application app, Direction dir, String pscoId, int hashCode) {
        return new ExternalPSCObjectAccessParams(app, dir, pscoId, hashCode);
    }

    private ExternalPSCObjectAccessParams(Application app, Direction dir, String pscoId, int hashCode) {
        super(new DataParams.ExternalPSCObjectData(app, hashCode), dir, pscoId);
    }

    public String getPSCOId() {
        return (String)this.getValue();
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataVersion dv = dInfo.getCurrentDataVersion();
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerExternalPSCO(renaming, this.getPSCOId());
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }
}

