/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ExternalPropertyException;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.StreamAccessParams;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.util.ExternalStreamHandler;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.requests.AddStreamWriterRequest;

public class ExternalStreamAccessParams
extends StreamAccessParams<DataLocation, DataParams.ExternalStreamData> {
    private static final long serialVersionUID = 1L;

    public static final ExternalStreamAccessParams constructESAP(Application app, Direction dir, DataLocation location) {
        return new ExternalStreamAccessParams(app, dir, location);
    }

    private ExternalStreamAccessParams(Application app, Direction dir, DataLocation location) {
        super(new DataParams.ExternalStreamData(app, location.hashCode()), dir, location);
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataInstanceId lastDID = dInfo.getCurrentDataVersion().getDataInstanceId();
        String renaming = lastDID.getRenaming();
        Comm.registerLocation(renaming, (DataLocation)this.getValue());
    }

    @Override
    public void externalRegister() {
        DataLocation location = (DataLocation)this.getValue();
        if (this.mode != AccessParams.AccessMode.R) {
            String filePath = location.getURIInHost(Comm.getAppHost()).getPath();
            try {
                String pythonInterpreter = System.getProperty("compss.python.interpreter");
                if (pythonInterpreter == null || pythonInterpreter.isEmpty() || pythonInterpreter.equals("null")) {
                    pythonInterpreter = "python3";
                }
                String streamId = ExternalStreamHandler.getExternalStreamProperty(pythonInterpreter, filePath, "id");
                if (DEBUG) {
                    LOGGER.debug("Registering writer for stream " + streamId);
                }
                AddStreamWriterRequest req = new AddStreamWriterRequest(streamId);
                DistroStreamClient.request(req);
            }
            catch (ExternalPropertyException e) {
                LOGGER.error("ERROR: Cannot retrieve external property. Not adding stream writer", (Throwable)e);
            }
        }
    }
}

