/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.project;

import es.bsc.compss.types.project.ProjectFile;
import es.bsc.compss.types.project.exceptions.InvalidElementException;
import es.bsc.compss.types.project.exceptions.ProjectFileValidationException;
import es.bsc.compss.types.project.jaxb.AdaptorType;
import es.bsc.compss.types.project.jaxb.AdaptorsListType;
import es.bsc.compss.types.project.jaxb.ApplicationType;
import es.bsc.compss.types.project.jaxb.AttachedDiskType;
import es.bsc.compss.types.project.jaxb.AttachedDisksListType;
import es.bsc.compss.types.project.jaxb.BatchType;
import es.bsc.compss.types.project.jaxb.CloudPropertiesType;
import es.bsc.compss.types.project.jaxb.CloudPropertyType;
import es.bsc.compss.types.project.jaxb.CloudProviderType;
import es.bsc.compss.types.project.jaxb.CloudType;
import es.bsc.compss.types.project.jaxb.ClusterNodeType;
import es.bsc.compss.types.project.jaxb.ComputeNodeType;
import es.bsc.compss.types.project.jaxb.ComputingClusterType;
import es.bsc.compss.types.project.jaxb.DataNodeType;
import es.bsc.compss.types.project.jaxb.ExternalAdaptorProperties;
import es.bsc.compss.types.project.jaxb.GOSAdaptorProperties;
import es.bsc.compss.types.project.jaxb.HttpType;
import es.bsc.compss.types.project.jaxb.ImageType;
import es.bsc.compss.types.project.jaxb.ImagesType;
import es.bsc.compss.types.project.jaxb.InstanceTypeType;
import es.bsc.compss.types.project.jaxb.InstanceTypesType;
import es.bsc.compss.types.project.jaxb.InteractiveType;
import es.bsc.compss.types.project.jaxb.MasterNodeType;
import es.bsc.compss.types.project.jaxb.MemoryType;
import es.bsc.compss.types.project.jaxb.NIOAdaptorProperties;
import es.bsc.compss.types.project.jaxb.OSType;
import es.bsc.compss.types.project.jaxb.PackageType;
import es.bsc.compss.types.project.jaxb.PriceType;
import es.bsc.compss.types.project.jaxb.ProcessorType;
import es.bsc.compss.types.project.jaxb.ServiceType;
import es.bsc.compss.types.project.jaxb.SoftwareListType;
import es.bsc.compss.types.project.jaxb.StorageType;
import es.bsc.compss.types.project.jaxb.SubmissionSystemType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.Logger;

public class Validator {
    private ProjectFile pf;
    private Logger logger;

    public Validator(ProjectFile pf, Logger logger) {
        this.logger = logger;
        this.pf = pf;
    }

    public void validate() throws ProjectFileValidationException {
        this.logger.info("Validating <Project> tag");
        List<Object> objList = this.pf.getProject().getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            boolean masterNodeTagFound = false;
            boolean minimumUsableElementFound = false;
            for (Object obj : this.pf.getProject().getMasterNodeOrComputeNodeOrDataNode()) {
                if (obj instanceof MasterNodeType) {
                    masterNodeTagFound = true;
                    minimumUsableElementFound = this.validateMasterNode((MasterNodeType)obj);
                    continue;
                }
                if (obj instanceof ComputeNodeType) {
                    minimumUsableElementFound = true;
                    this.validateComputeNode((ComputeNodeType)obj);
                    continue;
                }
                if (obj instanceof DataNodeType) {
                    this.validateDataNode((DataNodeType)obj);
                    continue;
                }
                if (obj instanceof ServiceType) {
                    minimumUsableElementFound = true;
                    this.validateService((ServiceType)obj);
                    continue;
                }
                if (obj instanceof HttpType) {
                    minimumUsableElementFound = true;
                    this.validateHttpService((HttpType)obj);
                    continue;
                }
                if (obj instanceof CloudType) {
                    minimumUsableElementFound = true;
                    this.validateCloud((CloudType)obj);
                    continue;
                }
                if (obj instanceof ComputingClusterType) {
                    minimumUsableElementFound = true;
                    this.validateComputingCluster((ComputingClusterType)obj);
                    continue;
                }
                throw new InvalidElementException("Project", "Attribute" + obj.getClass(), "Incorrect attribute");
            }
            if (!masterNodeTagFound) {
                throw new ProjectFileValidationException("Doesn't appear any <MasterNode> element");
            }
            if (!minimumUsableElementFound) {
                throw new ProjectFileValidationException("No computational (masterNode, computeNode, service or cloud) resources found");
            }
        } else {
            throw new ProjectFileValidationException("Empty project file");
        }
        this.logger.info("Validation finished");
    }

    public boolean validateMasterNode(MasterNodeType mn) throws InvalidElementException {
        boolean hasComputingPower = false;
        if (mn != null) {
            List<Object> innerElements = mn.getProcessorOrMemoryOrStorage();
            if (innerElements != null) {
                boolean memoryTypeTagFound = false;
                boolean storageTypeTagFound = false;
                boolean osTypeTagFound = false;
                boolean softwareListTypeTagFound = false;
                boolean sharedDisksTagFound = false;
                boolean priceTagFound = false;
                for (Object obj : innerElements) {
                    if (obj instanceof ProcessorType) {
                        ProcessorType p = (ProcessorType)obj;
                        this.validateProcessor(p);
                        hasComputingPower = true;
                        continue;
                    }
                    if (obj instanceof MemoryType) {
                        if (memoryTypeTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        memoryTypeTagFound = true;
                        MemoryType mem = (MemoryType)obj;
                        this.validateMemory(mem);
                        continue;
                    }
                    if (obj instanceof StorageType) {
                        if (storageTypeTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        storageTypeTagFound = true;
                        StorageType sto = (StorageType)obj;
                        this.validateStorage(sto);
                        continue;
                    }
                    if (obj instanceof OSType) {
                        if (osTypeTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        osTypeTagFound = true;
                        OSType os = (OSType)obj;
                        this.validateOS(os);
                        continue;
                    }
                    if (obj instanceof SoftwareListType) {
                        if (softwareListTypeTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        softwareListTypeTagFound = true;
                        SoftwareListType softwares = (SoftwareListType)obj;
                        this.validateSoftwareList(softwares);
                        continue;
                    }
                    if (obj instanceof AttachedDisksListType) {
                        if (sharedDisksTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        sharedDisksTagFound = true;
                        this.validateAttachedDisksList((AttachedDisksListType)obj);
                        continue;
                    }
                    if (obj instanceof PriceType) {
                        if (priceTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        priceTagFound = true;
                        this.validatePrice((PriceType)obj);
                        continue;
                    }
                    throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Incorrect attribute");
                }
            }
        } else {
            throw new InvalidElementException("Project", "Attribute MasterNode", "is null");
        }
        return hasComputingPower;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateComputeNode(ComputeNodeType cn) throws InvalidElementException {
        if (cn == null) throw new InvalidElementException("Project", "Attribute ComputeNode", "is null");
        List<JAXBElement<?>> innerElements = cn.getInstallDirOrWorkingDirOrUser();
        if (innerElements == null) throw new InvalidElementException("Project", "Attribute ComputeNode " + cn.getName(), "has no inner fields");
        boolean installDirTagFound = false;
        boolean workingDirTagFound = false;
        boolean userTagFound = false;
        boolean appTagFound = false;
        boolean lotTagFound = false;
        boolean adaptorsTagFound = false;
        for (JAXBElement<?> element : innerElements) {
            if (element.getName().equals(new QName("InstallDir"))) {
                if (installDirTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                installDirTagFound = true;
                this.validateInstallDir((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("WorkingDir"))) {
                if (workingDirTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                workingDirTagFound = true;
                this.validateWorkingDir((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("User"))) {
                if (userTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                userTagFound = true;
                this.validateUser((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("Application"))) {
                if (appTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                appTagFound = true;
                this.validateApplication((ApplicationType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("LimitOfTasks"))) {
                if (lotTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                lotTagFound = true;
                this.validateLimitOfTasks((Integer)element.getValue());
                continue;
            }
            if (!element.getName().equals(new QName("Adaptors"))) throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Incorrect attribute");
            if (adaptorsTagFound) {
                throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
            }
            adaptorsTagFound = true;
            this.validateAdaptors((AdaptorsListType)element.getValue());
        }
        if (!installDirTagFound) {
            throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute InstallDir", "Doesn't appear");
        }
        if (workingDirTagFound) return;
        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute WorkingDir", "Doesn't appear");
    }

    public void validateDataNode(DataNodeType dn) throws InvalidElementException {
        if (dn != null) {
            List<AdaptorsListType> innerElements = dn.getAdaptors();
            if (innerElements != null) {
                boolean adaptorsTagFound = false;
                for (AdaptorsListType adaptors : innerElements) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("ComputeNode " + dn.getName(), "Attribute Adaptors", "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors(adaptors);
                }
            }
        } else {
            throw new InvalidElementException("Project", "Attribute DataNode", "is null");
        }
    }

    public void validateService(ServiceType s) throws InvalidElementException {
        if (s == null) {
            throw new InvalidElementException("Project", "Attribute Service", "is null");
        }
        this.validateLimitOfTasks(s.getLimitOfTasks());
    }

    public void validateHttpService(HttpType h) throws InvalidElementException {
        if (h == null) {
            throw new InvalidElementException("Project", "Attribute Service", "is null");
        }
        this.validateLimitOfTasks(h.getLimitOfTasks());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateCloud(CloudType c) throws InvalidElementException {
        if (c == null) throw new InvalidElementException("Project", "Attribute ComputeNode", "is null");
        List<JAXBElement<?>> innerElements = c.getCloudProviderOrInitialVMsOrMinimumVMs();
        if (innerElements == null) throw new InvalidElementException("Project", "Attribute Cloud", "has no inner fields");
        boolean cpTagFound = false;
        boolean initialVMsTagFound = false;
        boolean minVMsTagFound = false;
        boolean maxVMsTagFound = false;
        JAXBElement<?> initialVMs = null;
        int minVMs = -1;
        int maxVMs = -1;
        for (JAXBElement<?> element : innerElements) {
            if (element.getName().equals(new QName("CloudProvider"))) {
                cpTagFound = true;
                this.validateCloudProvider((CloudProviderType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("InitialVMs"))) {
                if (initialVMsTagFound) {
                    throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Appears more than once");
                }
                initialVMsTagFound = true;
                initialVMs = element;
                this.validateInitialVMs((Integer)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("MinimumVMs"))) {
                if (minVMsTagFound) {
                    throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Appears more than once");
                }
                minVMsTagFound = true;
                minVMs = (Integer)element.getValue();
                this.validateMinimumVMs((Integer)element.getValue());
                continue;
            }
            if (!element.getName().equals(new QName("MaximumVMs"))) throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Incorrect attribute");
            if (maxVMsTagFound) {
                throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Appears more than once");
            }
            maxVMsTagFound = true;
            maxVMs = (Integer)element.getValue();
            this.validateMaximumVMs((Integer)element.getValue());
        }
        if (!cpTagFound) {
            throw new InvalidElementException("Cloud", "Attribute CloudProvider", "Doesn't appear");
        }
        this.checkInitialMinMaxVMsCoherence(initialVMs, minVMs, maxVMs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateCloudProvider(CloudProviderType cp) throws InvalidElementException {
        if (cp == null) throw new InvalidElementException("Cloud", "Attribute CloudProvider", "is null");
        List<Object> innerElements = cp.getImagesOrInstanceTypesOrLimitOfVMs();
        if (innerElements == null) throw new InvalidElementException("Cloud", "Attribute CloudProvider", "has no inner fields");
        boolean imagesTagFound = false;
        boolean instancesTagFound = false;
        boolean lovTagFound = false;
        boolean propertiesTagFound = false;
        for (Object obj : innerElements) {
            if (obj instanceof ImagesType) {
                if (imagesTagFound) {
                    throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
                }
                imagesTagFound = true;
                this.validateImages((ImagesType)obj);
                continue;
            }
            if (obj instanceof InstanceTypesType) {
                if (instancesTagFound) {
                    throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
                }
                instancesTagFound = true;
                this.validateInstanceTypes((InstanceTypesType)obj);
                continue;
            }
            if (obj instanceof Integer) {
                if (lovTagFound) {
                    throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
                }
                lovTagFound = true;
                this.validateLimitOfVMs((Integer)obj);
                continue;
            }
            if (!(obj instanceof CloudPropertiesType)) throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Incorrect attribute");
            if (propertiesTagFound) {
                throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
            }
            propertiesTagFound = true;
            this.validateCloudProperties((CloudPropertiesType)obj);
        }
        if (!imagesTagFound) {
            throw new InvalidElementException("CloudProvider", "Attribute Images", "Doesn't appear");
        }
        if (instancesTagFound) return;
        throw new InvalidElementException("CloudProvider", "Attribute Instances", "Doesn't appear");
    }

    public void validateComputingCluster(ComputingClusterType cluster) throws InvalidElementException {
        if (cluster == null) {
            throw new InvalidElementException("ComputingCluster", "Attribute CloudProvider", "is null");
        }
        List<JAXBElement<?>> innerElements = cluster.getLimitOfTasksOrInstallDirOrWorkingDir();
        if (innerElements == null) {
            throw new InvalidElementException("Project", "Attribute ComputeNode " + cluster.getName(), "has no inner fields");
        }
        boolean installDirTagFound = false;
        boolean workingDirTagFound = false;
        boolean appTagFound = false;
        boolean adaptorsTagFound = false;
        boolean clusterNodeTag = false;
        boolean userTagFound = false;
        boolean taskLimitTagFound = false;
        boolean softwareTagFound = false;
        for (JAXBElement<?> element : innerElements) {
            if (element.getName().equals(new QName("InstallDir"))) {
                if (installDirTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                installDirTagFound = true;
                this.validateInstallDir((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("WorkingDir"))) {
                if (workingDirTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                workingDirTagFound = true;
                this.validateWorkingDir((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("LimitOfTasks"))) {
                if (taskLimitTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                taskLimitTagFound = true;
                this.validateLimitOfTasks((Integer)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("User"))) {
                if (userTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                userTagFound = true;
                this.validateUser((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("Application"))) {
                if (appTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                appTagFound = true;
                this.validateApplication((ApplicationType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("Adaptors"))) {
                if (adaptorsTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                adaptorsTagFound = true;
                this.validateAdaptors((AdaptorsListType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("Software"))) {
                if (softwareTagFound) {
                    throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                softwareTagFound = true;
                this.validateSoftwareList((SoftwareListType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("ClusterNode"))) {
                clusterNodeTag = true;
                this.validateClusterNode(cluster, (ClusterNodeType)element.getValue());
                continue;
            }
            throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute " + element.getName(), "Incorrect attribute");
        }
        if (!installDirTagFound) {
            throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute InstallDir", "Doesn't appear");
        }
        if (!workingDirTagFound) {
            throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute WorkingDir", "Doesn't appear");
        }
        if (!clusterNodeTag) {
            throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute ClusterNode", "Doesn't appear");
        }
        if (!taskLimitTagFound) {
            throw new InvalidElementException("ComputingCluster " + cluster.getName(), "Attribute Task Limit", "Doesn't appear");
        }
    }

    private void validateProcessor(ProcessorType processor) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = processor.getComputingUnitsOrArchitectureOrSpeed();
        if (innerElements != null) {
            boolean cuTagFound = false;
            boolean architectureTagFound = false;
            boolean speedTagFound = false;
            boolean typeTagFound = false;
            boolean memTagFound = false;
            boolean processorPropertyTagFound = false;
            for (JAXBElement<?> obj : innerElements) {
                if (obj.getName().equals(new QName("ComputingUnits"))) {
                    if (cuTagFound) {
                        throw new InvalidElementException("Processor", "Attribute ComputingUnits", "Appears more than once");
                    }
                    cuTagFound = true;
                    int val = (Integer)obj.getValue();
                    if (val > 0) continue;
                    throw new InvalidElementException("Processor", "Attribute ComputingUnits", "Must be greater than 0");
                }
                if (obj.getName().equals(new QName("Architecture"))) {
                    if (architectureTagFound) {
                        throw new InvalidElementException("Processor", "Attribute Architecture", "Appears more than once");
                    }
                    architectureTagFound = true;
                    continue;
                }
                if (obj.getName().equals(new QName("Speed"))) {
                    if (speedTagFound) {
                        throw new InvalidElementException("Processor", "Attribute Speed", "Appears more than once");
                    }
                    speedTagFound = true;
                    float val = ((Float)obj.getValue()).floatValue();
                    if (!((double)val <= 0.0)) continue;
                    throw new InvalidElementException("Processor", "Attribute Speed", "Must be greater than 0");
                }
                if (obj.getName().equals(new QName("Type"))) {
                    if (typeTagFound) {
                        throw new InvalidElementException("Processor", "Attribute Type", "Appears more than once");
                    }
                    typeTagFound = true;
                    continue;
                }
                if (obj.getName().equals(new QName("InternalMemorySize"))) {
                    if (memTagFound) {
                        throw new InvalidElementException("Processor", "Attribute InternalMemorySize", "Appears more than once");
                    }
                    memTagFound = true;
                    float val = ((Float)obj.getValue()).floatValue();
                    if (!((double)val <= 0.0)) continue;
                    throw new InvalidElementException("Processor", "Attribute InternalMemorySize", "Must be greater than 0");
                }
                if (obj.getName().equals(new QName("ProcessorProperty"))) {
                    if (processorPropertyTagFound) {
                        throw new InvalidElementException("Processor", "Attribute ProcessorProperty", "Appears more than once");
                    }
                    processorPropertyTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Processor", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!cuTagFound) {
                throw new InvalidElementException("Processor", "Attribute ComputingUnits", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Processor", "", "Content is empty");
        }
    }

    private void validateMemory(MemoryType memory) throws InvalidElementException {
        List<Serializable> innerElements = memory.getSizeOrType();
        if (innerElements != null) {
            boolean sizeTagFound = false;
            boolean typeTagFound = false;
            for (Serializable obj : innerElements) {
                if (obj instanceof Float) {
                    if (sizeTagFound) {
                        throw new InvalidElementException("Memory", "Attribute Size", "Appears more than once");
                    }
                    sizeTagFound = true;
                    Float val = (Float)obj;
                    if (!((double)val.floatValue() <= 0.0)) continue;
                    throw new InvalidElementException("Memory", "Attribute Size", "Must be greater than 0");
                }
                if (obj instanceof String) {
                    if (typeTagFound) {
                        throw new InvalidElementException("Memory", "Attribute Type", "Appears more than once");
                    }
                    typeTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Memory", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!sizeTagFound) {
                throw new InvalidElementException("Memory ", "Attribute Size", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Memory", "", "Content is empty");
        }
    }

    private void validateStorage(StorageType s) throws InvalidElementException {
        List<Serializable> innerElements = s.getSizeOrTypeOrBandwidth();
        if (innerElements != null) {
            boolean sizeTagFound = false;
            boolean typeTagFound = false;
            boolean bandwidthTagFound = false;
            for (Serializable obj : innerElements) {
                Number val;
                if (obj instanceof Float) {
                    if (sizeTagFound) {
                        throw new InvalidElementException("Storage", "Attribute Size", "Appears more than once");
                    }
                    sizeTagFound = true;
                    val = (Float)obj;
                    if (!((double)((Float)val).floatValue() <= 0.0)) continue;
                    throw new InvalidElementException("Storage", "Attribute Size", "Must be greater than 0");
                }
                if (obj instanceof String) {
                    if (typeTagFound) {
                        throw new InvalidElementException("Storage", "Attribute Type", "Appears more than once");
                    }
                    typeTagFound = true;
                    continue;
                }
                if (obj instanceof Integer) {
                    if (bandwidthTagFound) {
                        throw new InvalidElementException("Storage", "Attribute Bandwidth", "Appears more than once");
                    }
                    bandwidthTagFound = true;
                    val = (Integer)obj;
                    if ((Integer)val > 0) continue;
                    throw new InvalidElementException("Storage", "Attribute Bandwidth", "Must be greater than 0");
                }
                throw new InvalidElementException("Storage", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!sizeTagFound) {
                throw new InvalidElementException("Storage ", "Attribute Size", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Storage", "", "Content is empty");
        }
    }

    private void validateOS(OSType os) throws InvalidElementException {
    }

    private void validateAttachedDisksList(AttachedDisksListType disks) throws InvalidElementException {
        List<AttachedDiskType> innerElements = disks.getAttachedDisk();
        if (innerElements != null) {
            for (AttachedDiskType disk : innerElements) {
                this.validateAttachedDisk(disk);
            }
        } else {
            throw new InvalidElementException("AttachedDisksList", "", "Content is empty");
        }
    }

    private void validateAttachedDisk(AttachedDiskType disk) throws InvalidElementException {
        if (disk.getName() == null || disk.getName().isEmpty()) {
            throw new InvalidElementException("AttachedDisk ", "Attribute Name", "Doesn't appear");
        }
        if (disk.getMountPoint() == null || disk.getMountPoint().isEmpty()) {
            throw new InvalidElementException("AttachedDisk" + disk.getName(), "Attribute MountPoint", "Doesn't appear");
        }
    }

    private void validatePrice(PriceType price) throws InvalidElementException {
        if (price.getTimeUnit() <= 0) {
            throw new InvalidElementException("Price", "Attribute TimeUnit", "Invalid value");
        }
        if (price.getPricePerUnit() < 0.0f) {
            throw new InvalidElementException("Price", "Attribute PricePerUnit", "Invalid value");
        }
    }

    private void validateInstallDir(String installDir) throws InvalidElementException {
        if (installDir == null) {
            throw new InvalidElementException("ComputeNode", "Attribute installDir", "Is null");
        }
        if (installDir.isEmpty()) {
            throw new InvalidElementException("ComputeNode", "Attribute installDir", "Is empty");
        }
    }

    private void validateWorkingDir(String workingDir) throws InvalidElementException {
        if (workingDir == null) {
            throw new InvalidElementException("ComputeNode", "Attribute workingDir", "Is null");
        }
        if (workingDir.isEmpty()) {
            throw new InvalidElementException("ComputeNode", "Attribute workingDir", "Is empty");
        }
    }

    private void validateApplication(ApplicationType app) throws InvalidElementException {
    }

    private void validateApplication(String app) throws InvalidElementException {
    }

    private void validateLimitOfTasks(Integer lot) throws InvalidElementException {
        if (lot != null) {
            if (lot < 0) {
                throw new InvalidElementException("ComputeNode", "Attribute LimitOfTasks", "has an invalid value");
            }
            if (lot == 0) {
                this.logger.warn("ComputeNode has LimitOfTasks = 0, no task will be scheduled to this resource");
            }
        }
    }

    private void validateInitialVMs(Integer initialVMs) throws InvalidElementException {
        if (initialVMs == null) {
            throw new InvalidElementException("Cloud", "Attribute initialVMs", "Is null");
        }
        if (initialVMs < 0) {
            throw new InvalidElementException("ComputeNode", "Attribute initialVMs", "has an invalid value");
        }
    }

    private void validateMinimumVMs(Integer minimumVMs) throws InvalidElementException {
        if (minimumVMs == null) {
            throw new InvalidElementException("Cloud", "Attribute minimumVMs", "Is null");
        }
        if (minimumVMs < 0) {
            throw new InvalidElementException("ComputeNode", "Attribute minimumVMs", "has an invalid value");
        }
    }

    private void validateMaximumVMs(Integer maximumVMs) throws InvalidElementException {
        if (maximumVMs == null) {
            throw new InvalidElementException("Cloud", "Attribute maximumVMs", "Is null");
        }
        if (maximumVMs < 0) {
            throw new InvalidElementException("ComputeNode", "Attribute maximumVMs", "has an invalid value");
        }
    }

    private void checkInitialMinMaxVMsCoherence(JAXBElement<Integer> initialVMs, int minVMs, int maxVMs) throws InvalidElementException {
        int initial = -1;
        if (initialVMs != null) {
            initial = initialVMs.getValue();
        }
        if (minVMs >= 0 && maxVMs >= 0 && minVMs > maxVMs) {
            throw new InvalidElementException("Project", "Attributes minVMs/maxVMs", "define empty range");
        }
        if (minVMs >= 0 && initial >= 0 && initial < minVMs) {
            initialVMs.setValue(minVMs);
            this.logger.warn("InitialVMs value was " + initial + " but it is set to " + minVMs + " because it is the minimumVMs value");
        }
        if (maxVMs >= 0 && initial >= 0 && initial > maxVMs) {
            initialVMs.setValue(maxVMs);
            this.logger.warn("InitialVMs value was " + initial + " but it is set to " + maxVMs + " because it is the maximumVMs value");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAdaptors(AdaptorsListType adaptors) throws InvalidElementException {
        if (adaptors == null) throw new InvalidElementException("Adaptors", "", "Tag not present");
        List<AdaptorType> adaptorsList = adaptors.getAdaptor();
        if (adaptorsList == null) throw new InvalidElementException("Adaptors", "", "Content is empty");
        for (AdaptorType adaptor : adaptorsList) {
            this.validateAdaptor(adaptor);
        }
    }

    private void validateAdaptor(AdaptorType adaptor) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            boolean subsysTagFound = false;
            boolean portsTagFound = false;
            boolean brokerAdaptorTagFound = false;
            boolean propertiesTagFound = false;
            boolean userTagFound = false;
            for (JAXBElement<?> obj : innerElements) {
                if (obj.getName().equals(new QName("SubmissionSystem"))) {
                    if (subsysTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    subsysTagFound = true;
                    this.validateSubmissionSystem((SubmissionSystemType)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Ports"))) {
                    if (portsTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (brokerAdaptorTagFound || propertiesTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (GAT or External) was already defined");
                    }
                    portsTagFound = true;
                    this.validateNIOAdaptorProperties((NIOAdaptorProperties)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("BrokerAdaptor"))) {
                    if (brokerAdaptorTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (portsTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (NIO) was already defined");
                    }
                    brokerAdaptorTagFound = true;
                    this.validateGATAdaptorProperties((String)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Properties"))) {
                    if (propertiesTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    propertiesTagFound = true;
                    this.validateExternalAdaptorProperties((ExternalAdaptorProperties)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("User"))) {
                    if (userTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    userTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute" + obj.getName(), "Incorrect attribute");
            }
            if (!subsysTagFound) {
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute SubmissionSystem", "Doesn't appear");
            }
            if (!(portsTagFound || brokerAdaptorTagFound || propertiesTagFound)) {
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute Adaptor properties (NIO, GAT or External)", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Adaptor", "", "Content is empty");
        }
    }

    private void validateSubmissionSystem(SubmissionSystemType subSys) throws InvalidElementException {
        List<Object> innerElements = subSys.getBatchOrInteractive();
        if (innerElements != null) {
            boolean batchTagFound = false;
            boolean interactiveTagFound = false;
            for (Object obj : innerElements) {
                if (obj instanceof BatchType) {
                    if (batchTagFound) {
                        throw new InvalidElementException("SubmissionSystem", "Attribute Batch", "Appears more than once");
                    }
                    batchTagFound = true;
                    this.validateBatch((BatchType)obj);
                    continue;
                }
                if (obj instanceof InteractiveType) {
                    if (interactiveTagFound) {
                        throw new InvalidElementException("SubmissionSystem", "Attribute Interactive", "Appears more than once");
                    }
                    interactiveTagFound = true;
                    this.validateInteractive((InteractiveType)obj);
                    continue;
                }
                throw new InvalidElementException("SubmissionSystem", "Attribute " + obj.getClass(), "Invalid type");
            }
            if (!batchTagFound && !interactiveTagFound) {
                throw new InvalidElementException("SubmissionSystem", "Interactive/Batch", "At least 1 submission system must be defined");
            }
        } else {
            throw new InvalidElementException("SubmissionSystem", "", "Content is empty");
        }
    }

    private void validateBatch(BatchType batch) throws InvalidElementException {
        GOSAdaptorProperties batchProperties = batch.getBatchProperties();
        if (batchProperties != null) {
            this.validateGOSAdaptorProperties(batchProperties);
        }
    }

    private void validateInteractive(InteractiveType interactive) throws InvalidElementException {
    }

    private void validateNIOAdaptorProperties(NIOAdaptorProperties props) throws InvalidElementException {
        if (props.getMaxPort() < 0) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MaxPort", "Invalid value");
        }
        if (props.getMinPort() < 0) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MinPort", "Invalid value");
        }
        if (props.getMaxPort() <= props.getMinPort()) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MinPort-MaxPort", "Invalid range");
        }
    }

    private void validateGATAdaptorProperties(String broker) throws InvalidElementException {
        if (broker == null || broker.isEmpty()) {
            throw new InvalidElementException("GATAdaptor", "Attribute BrokerAdaptor", "Doesn't appear");
        }
    }

    private void validateGOSAdaptorProperties(GOSAdaptorProperties prop) throws InvalidElementException {
        Long maxExecTime = prop.getMaxExecTime();
        if (maxExecTime != null && maxExecTime < 1L) {
            throw new InvalidElementException("Properties of GOSAdaptor", "Attribute maxExecTime", "Invalid value");
        }
        Integer port = prop.getPort();
        if (port != null && port < 0) {
            throw new InvalidElementException("Properties of GOSAdaptor", "Attribute port", "Invalid value");
        }
    }

    private void validateExternalAdaptorProperties(ExternalAdaptorProperties props) throws InvalidElementException {
    }

    private void validateImages(ImagesType images) throws InvalidElementException {
        ArrayList<String> imageNames = new ArrayList<String>();
        List<ImageType> imagesList = images.getImage();
        if (imagesList != null) {
            for (ImageType im : imagesList) {
                if (imageNames.contains(im.getName())) {
                    throw new InvalidElementException("Images", "Attribute Image " + im.getName(), "Name already used");
                }
                imageNames.add(im.getName());
                this.validateImage(im);
            }
        } else {
            throw new InvalidElementException("Images", "", "Content is empty");
        }
    }

    private void validateImage(ImageType image) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = image.getInstallDirOrWorkingDirOrUser();
        if (innerElements != null) {
            boolean installDirTagFound = false;
            boolean workingDirTagFound = false;
            boolean userTagFound = false;
            boolean appTagFound = false;
            boolean lotTagFound = false;
            boolean adaptorsTagFound = false;
            for (JAXBElement<?> element : innerElements) {
                if (element.getName().equals(new QName("InstallDir"))) {
                    if (installDirTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    installDirTagFound = true;
                    this.validateInstallDir((String)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("WorkingDir"))) {
                    if (workingDirTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    workingDirTagFound = true;
                    this.validateWorkingDir((String)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("User"))) {
                    if (userTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    userTagFound = true;
                    this.validateUser((String)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("Application"))) {
                    if (appTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    appTagFound = true;
                    this.validateApplication((ApplicationType)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("LimitOfTasks"))) {
                    if (lotTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    lotTagFound = true;
                    this.validateLimitOfTasks((Integer)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("Package"))) {
                    this.validatePackage((PackageType)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("Adaptors"))) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors((AdaptorsListType)element.getValue());
                    continue;
                }
                throw new InvalidElementException("Image", "Attribute " + element.getName(), "Incorrect attribute");
            }
            if (!installDirTagFound) {
                throw new InvalidElementException("Image ", "Attribute installDir", "Doesn't appear");
            }
            if (!workingDirTagFound) {
                throw new InvalidElementException("Image ", "Attribute workingDir", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Image", "", "Content is empty");
        }
    }

    private void validateUser(String username) throws InvalidElementException {
    }

    private void validatePackage(PackageType pack) throws InvalidElementException {
        if (pack != null) {
            if (pack.getSource() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (pack.getSource().isEmpty()) {
                throw new InvalidElementException("Package", "Attribute source", "Is empty");
            }
            if (pack.getTarget() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (pack.getTarget().isEmpty()) {
                throw new InvalidElementException("Package", "Attribute source", "Is empty");
            }
            if (pack.getIncludedSoftware() != null) {
                this.validateSoftwareList(pack.getIncludedSoftware());
            }
        } else {
            throw new InvalidElementException("Image", "Attribute Package", "is null");
        }
    }

    private void validateSoftwareList(SoftwareListType softwares) throws InvalidElementException {
        if (softwares != null) {
            List<String> innerElements = softwares.getApplication();
            for (String app : innerElements) {
                this.validateApplication(app);
            }
        } else {
            throw new InvalidElementException("Package", "Attribute SoftwareList", "is null");
        }
    }

    private void validateInstanceTypes(InstanceTypesType instances) throws InvalidElementException {
        ArrayList<String> instanceNames = new ArrayList<String>();
        List<InstanceTypeType> instancesList = instances.getInstanceType();
        if (instancesList != null) {
            for (InstanceTypeType i : instances.getInstanceType()) {
                if (instanceNames.contains(i.getName())) {
                    throw new InvalidElementException("Instances", "Attribute Instance " + i.getName(), "Name already used");
                }
                instanceNames.add(i.getName());
                this.validateInstance(i);
            }
        } else {
            throw new InvalidElementException("InstanceTypes", "", "Content is empty");
        }
    }

    private void validateInstance(InstanceTypeType instance) throws InvalidElementException {
    }

    private void validateCloudProperties(CloudPropertiesType properties) throws InvalidElementException {
        if (properties != null) {
            List<CloudPropertyType> innerElements = properties.getProperty();
            if (innerElements != null) {
                for (CloudPropertyType prop : innerElements) {
                    this.validateCloudProperty(prop);
                }
            }
        } else {
            throw new InvalidElementException("Cloud", "Attribute Properties", "is null");
        }
    }

    private void validateCloudProperty(CloudPropertyType prop) throws InvalidElementException {
        if (prop != null) {
            if (prop.getName() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (prop.getName().isEmpty()) {
                throw new InvalidElementException("Package", "Attribute source", "Is empty");
            }
            if (prop.getValue() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (prop.getValue().isEmpty()) {
                // empty if block
            }
        } else {
            throw new InvalidElementException("Cloud Properties", "Attribute Property", "is null");
        }
    }

    private void validateLimitOfVMs(Integer lovms) throws InvalidElementException {
        if (lovms == null) {
            throw new InvalidElementException("CloudProvider", "Attribute LimitOfVMs", "Is null");
        }
        if (lovms < 0) {
            throw new InvalidElementException("CloudProvider", "Attribute LimitOfVMs", "has an invalid value");
        }
        if (lovms == 0) {
            this.logger.warn("CloudProvider has LimitOfVMs = 0, no task will be scheduled to this resource");
        }
    }

    private void validateClusterNode(ComputingClusterType cluster, ClusterNodeType node) throws InvalidElementException {
        List<JAXBElement<?>> elements = cluster.getLimitOfTasksOrInstallDirOrWorkingDir();
        int nApperances = 0;
        for (JAXBElement<?> el : elements) {
            ClusterNodeType n;
            if (!el.getName().equals(new QName("ClusterNode")) || !(n = (ClusterNodeType)el.getValue()).getName().equals(node.getName())) continue;
            ++nApperances;
        }
        if (nApperances > 1) {
            throw new InvalidElementException("ClusterNode " + node.getName() + " in cluster " + cluster.getName(), "Name Value", "Is repeated");
        }
        Integer nNodes = node.getNumberOfNodes();
        if (nNodes == 0) {
            this.logger.warn("ClusterNode " + node.getName() + " in cluster " + cluster.getName(), (Object)"Number of nodes is 0, no tasks will be assigned to this node.");
        }
        if (nNodes < 0) {
            throw new InvalidElementException("ClusterNode " + node.getName() + " in cluster " + cluster.getName(), "Number of nodes", "Cannot be less than 0.");
        }
    }
}

