/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.Task;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GraphGenerator {
    private static final boolean MONITOR_ENABLED = System.getProperty("compss.monitor") != null && !"0".equals(System.getProperty("compss.monitor"));
    private static final boolean DRAW_GRAPH = System.getProperty("compss.graph") != null && "true".equals(System.getProperty("compss.graph"));
    private static final boolean GRAPH_GENERATOR_ENABLED = MONITOR_ENABLED || DRAW_GRAPH;
    private static final String STREAM_DOT_DESCRIPTION = "[shape=rect style=\"rounded,filled\" width=0 height=0 margin=0.1 fontsize=10 fillcolor=\"#a9a9a9\" fontcolor=\"#000000\"]";
    private static final String CURRENT_GRAPH_FILENAME = "current_graph.dot";
    private static final String COMPLETE_GRAPH_FILENAME = "complete_graph.dot";
    private static final String COMPLETE_GRAPH_TMP_FILENAME = "complete_graph.dot.tmp";
    private static final String COMPLETE_LEGEND_TMP_FILENAME = "complete_legend.dot.tmp";
    private static final String MONITOR_DIR_PATH;
    private static final String CURRENT_GRAPH_FILE;
    private static final String COMPLETE_GRAPH_FILE;
    private static final String COMPLETE_GRAPH_TMP_FILE;
    private static final String COMPLETE_LEGEND_TMP_FILE;
    private static BufferedWriter full_graph;
    private static BufferedWriter current_graph;
    private static BufferedWriter legend;
    private static HashSet<Integer> legendTasks;
    private static int openCollectivesEdges;
    private static HashMap<String, List<String>> pendingGroupDependencies;
    private static HashMap<String, List<Task>> openCommutativeGroups;
    private static final Logger LOGGER;
    private static final String ERROR_MONITOR_DIR = "ERROR: Cannot create monitor directory";
    private static final String ERROR_ADDING_DATA = "Error adding task to graph file";
    private static final String ERROR_ADDING_EDGE = "Error adding edge to graph file";
    private static final String ERROR_OPEN_CURRENT_GRAPH = "Error openning current graph file";
    private static final String ERROR_CLOSE_CURRENT_GRAPH = "Error closing current graph file";
    private static final String ERROR_COMMIT_FINAL_GRAPH = "Error commiting full graph to file";

    public static boolean isEnabled() {
        return GRAPH_GENERATOR_ENABLED;
    }

    public static String getMonitorDirPath() {
        return MONITOR_DIR_PATH;
    }

    public BufferedWriter getAndOpenCurrentGraph() {
        try {
            current_graph = new BufferedWriter(new FileWriter(CURRENT_GRAPH_FILE));
            GraphGenerator.openCurrentGraphFile(current_graph);
        }
        catch (IOException e) {
            LOGGER.error(ERROR_OPEN_CURRENT_GRAPH);
            return null;
        }
        return current_graph;
    }

    public void closeCurrentGraph() {
        try {
            GraphGenerator.closeGraphFile(current_graph);
            current_graph.close();
        }
        catch (IOException e) {
            LOGGER.error(ERROR_CLOSE_CURRENT_GRAPH);
        }
    }

    public void commitGraph(boolean noMoreTasks) {
        LOGGER.debug("Commiting graph to final location");
        try {
            full_graph.close();
            try (FileInputStream sourceFIS = new FileInputStream(COMPLETE_GRAPH_TMP_FILE);
                 FileOutputStream destFOS = new FileOutputStream(COMPLETE_GRAPH_FILE);
                 FileChannel sourceChannel = sourceFIS.getChannel();
                 FileChannel destChannel = destFOS.getChannel();){
                destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            full_graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_TMP_FILE, true));
            BufferedWriter finalGraph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_FILE, true));
            GraphGenerator.closeDependenceGraph(finalGraph);
            GraphGenerator.openLegend(finalGraph);
            legend.close();
            try (FileInputStream sourceFIS = new FileInputStream(COMPLETE_LEGEND_TMP_FILE);
                 FileOutputStream destFOS = new FileOutputStream(COMPLETE_GRAPH_FILE, true);
                 FileChannel sourceChannel = sourceFIS.getChannel();
                 FileChannel destChannel = destFOS.getChannel();){
                destChannel.position(destChannel.size());
                sourceChannel.transferTo(0L, sourceChannel.size(), destChannel);
            }
            legend = new BufferedWriter(new FileWriter(COMPLETE_LEGEND_TMP_FILE, true));
            if (noMoreTasks) {
                GraphGenerator.closeLegend(finalGraph);
                GraphGenerator.closeGraphFile(finalGraph);
            }
            finalGraph.close();
        }
        catch (IOException e) {
            LOGGER.error(ERROR_COMMIT_FINAL_GRAPH, (Throwable)e);
        }
    }

    public void addSynchroToGraph(int synchId) {
        try {
            full_graph.newLine();
            if (synchId == 0) {
                full_graph.write("Synchro" + synchId + "[label=\"main\", shape=octagon, style=filled fillcolor=\"#8B0000\" fontcolor=\"#FFFFFF\"];");
            } else {
                full_graph.write("Synchro" + synchId + "[label=\"sync\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
            }
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addBarrierToGraph(int synchId) {
        try {
            full_graph.newLine();
            full_graph.write("Synchro" + synchId + "[label=\"barrier\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addTaskToGraph(Task task) {
        if (!task.hasCommutativeParams()) {
            this.addTask(task);
        }
    }

    private void addTask(Task task) {
        try {
            full_graph.newLine();
            full_graph.write(task.getDotDescription());
            int taskId = task.getTaskDescription().getCoreElement().getCoreId();
            if (!legendTasks.contains(taskId)) {
                legendTasks.add(taskId);
                legend.write(task.getLegendDescription());
            }
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addTaskToCommutativeGroup(Task task, String identifier) {
        List<Task> tasks = openCommutativeGroups.get(identifier);
        if (tasks == null) {
            tasks = new LinkedList<Task>();
            openCommutativeGroups.put(identifier, tasks);
        }
        tasks.add(task);
    }

    public void addStreamToGraph(String label) {
        try {
            full_graph.newLine();
            String dotDescription = label + STREAM_DOT_DESCRIPTION;
            full_graph.write(dotDescription);
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void startGroupingEdges() {
        ++openCollectivesEdges;
    }

    public void stopGroupingEdges() {
        --openCollectivesEdges;
    }

    public void addEdgeToGraph(String src, String tgt, EdgeType edgeType, String label) {
        if (openCollectivesEdges == 0) {
            if (pendingGroupDependencies.isEmpty()) {
                this.addSingleElementEdgeToGraph(src, tgt, edgeType, label);
            } else {
                this.addSingleElementEdgeToGraph(src, tgt, edgeType, label);
                for (Map.Entry<String, List<String>> entry : pendingGroupDependencies.entrySet()) {
                    String srctgt = entry.getKey();
                    try {
                        full_graph.newLine();
                        Boolean first = false;
                        String f = "";
                        String l = "";
                        for (String s : pendingGroupDependencies.get(srctgt)) {
                            if (first.booleanValue() && pendingGroupDependencies.get(srctgt).size() <= 2) {
                                l = ",d" + s;
                                continue;
                            }
                            if (first.booleanValue() && pendingGroupDependencies.get(srctgt).size() > 2) {
                                l = ",...,d" + s;
                                continue;
                            }
                            first = true;
                            f = "d" + s;
                        }
                        if (pendingGroupDependencies.get(srctgt).size() <= 2) {
                            full_graph.write(srctgt + " [label=\"[" + f + l + "]\",color=\"#024b30\",penwidth=2];");
                            continue;
                        }
                        full_graph.write(srctgt + " [label=\"[" + f + l + "](" + pendingGroupDependencies.get(srctgt).size() + ")\",color=\"#024b30\",penwidth=2];");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                pendingGroupDependencies.clear();
            }
        } else {
            List<String> labels = pendingGroupDependencies.get(src + " -> " + tgt);
            if (labels == null) {
                labels = new LinkedList<String>();
            }
            labels.add(label);
            pendingGroupDependencies.put(src + " -> " + tgt, labels);
        }
    }

    private void addSingleElementEdgeToGraph(String src, String tgt, EdgeType edgeType, String label) {
        try {
            StringBuilder edgeProperties = new StringBuilder();
            String edgeTypeProps = edgeType.getProperties();
            if (!edgeTypeProps.isEmpty() || !label.isEmpty()) {
                edgeProperties.append(" [");
                if (!edgeTypeProps.isEmpty()) {
                    edgeProperties.append(edgeTypeProps);
                    if (!label.isEmpty()) {
                        edgeProperties.append(", ");
                    }
                }
                if (!label.isEmpty()) {
                    edgeProperties.append("label=\"d").append(label).append("\"");
                }
                edgeProperties.append("]");
            }
            edgeProperties.append(";");
            full_graph.newLine();
            full_graph.write(src + " -> " + tgt + edgeProperties.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_EDGE, (Throwable)e);
        }
    }

    public static void removeTemporaryGraph() {
        if (!new File(COMPLETE_GRAPH_TMP_FILE).delete()) {
            LOGGER.error("Cannot remove temporary graph file");
        }
        if (!new File(COMPLETE_LEGEND_TMP_FILE).delete()) {
            LOGGER.error("Cannot remove temporary legend file");
        }
    }

    public void addEdgeToGraphFromGroup(String src, String tgt, String label, String identifier, String clusterType, EdgeType edgeType) {
        try {
            StringBuilder edgeProperties = new StringBuilder();
            String edgeTypeProps = edgeType.getProperties();
            if (!edgeTypeProps.isEmpty() || !label.isEmpty()) {
                edgeProperties.append(" [");
                if (!edgeTypeProps.isEmpty()) {
                    edgeProperties.append(edgeTypeProps);
                    if (!label.isEmpty()) {
                        edgeProperties.append(", ");
                    }
                }
                if (!label.isEmpty()) {
                    edgeProperties.append("label=\"d").append(label).append("\"");
                }
                edgeProperties.append("]");
            }
            edgeProperties.append("[ ltail=\"").append(clusterType).append(identifier).append("\" ]");
            edgeProperties.append(";");
            full_graph.newLine();
            full_graph.write(src + " -> " + tgt + edgeProperties.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_EDGE, (Throwable)e);
        }
    }

    public void closeCommutativeGroups() {
        for (Map.Entry<String, List<Task>> entry : openCommutativeGroups.entrySet()) {
            String identifier = entry.getKey();
            List<Task> tasks = entry.getValue();
            this.printCommutativeGroup(identifier, tasks);
        }
        openCommutativeGroups.clear();
    }

    public void closeCommutativeGroup(String identifier) {
        List<Task> tasks = openCommutativeGroups.remove(identifier);
        this.printCommutativeGroup(identifier, tasks);
    }

    private void printCommutativeGroup(String identifier, List<Task> tasks) {
        try {
            full_graph.newLine();
            StringBuilder msg1 = new StringBuilder();
            msg1.append("subgraph clusterCommutative").append(identifier).append(" {\n");
            full_graph.write(msg1.toString());
            StringBuilder msg2 = new StringBuilder();
            msg2.append("shape=rect;\n");
            msg2.append("node[height=0.75];\n");
            msg2.append("color=\"#A9A9A9\";\n");
            msg2.append("rank=same;\n");
            msg2.append("label=\"CGT").append(identifier).append("\";\n");
            full_graph.write(msg2.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
        if (tasks != null) {
            for (Task task : tasks) {
                this.addTask(task);
            }
        }
        try {
            full_graph.newLine();
            full_graph.write("}\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addReduceTaskToGraph(int identifier) {
        try {
            full_graph.newLine();
            StringBuilder msg1 = new StringBuilder();
            msg1.append("subgraph clusterReduce").append(identifier).append(" {\n");
            full_graph.write(msg1.toString());
            StringBuilder msg2 = new StringBuilder();
            msg2.append("shape=rect;\n");
            msg2.append("node[height=0.75];\n");
            msg2.append("color=\"#A9A9A9\";\n");
            msg2.append("rank=same;\n");
            msg2.append("label=\"RT").append(identifier).append("\";\n");
            full_graph.write(msg2.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addTaskGroupToGraph(String identifier) {
        try {
            full_graph.newLine();
            full_graph.write("subgraph clusterTasks" + identifier + " {\n");
            full_graph.write("shape=rect;\nnode[height=0.75];\ncolor=\"#A9A9A9\"; \nlabel=\"" + identifier + "\";\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void closeGroupInGraph() {
        try {
            full_graph.newLine();
            full_graph.write("}\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void createNewSubgraph() {
        try {
            full_graph.newLine();
            full_graph.write("subgraph{\n");
            full_graph.newLine();
            full_graph.write("                node[height=0.75];\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    private static void emptyFullGraph() throws IOException {
        GraphGenerator.openFullGraphFile(full_graph);
        GraphGenerator.openDependenceGraph(full_graph);
        GraphGenerator.closeDependenceGraph(full_graph);
        GraphGenerator.openLegend(full_graph);
        GraphGenerator.closeLegend(full_graph);
        GraphGenerator.closeGraphFile(full_graph);
    }

    private static void emptyCurrentGraph() throws IOException {
        GraphGenerator.openCurrentGraphFile(current_graph);
        GraphGenerator.openDependenceGraph(current_graph);
        GraphGenerator.closeDependenceGraph(current_graph);
        GraphGenerator.closeGraphFile(current_graph);
    }

    private static void openFullGraphFile(BufferedWriter graph) throws IOException {
        graph.write("digraph {");
        graph.newLine();
        graph.write("  newrank=true;");
        graph.newLine();
        graph.write("  rankdir=TB;");
        graph.newLine();
        graph.write("  labeljust=\"l\";");
        graph.newLine();
        graph.write("  compound= true;");
        graph.newLine();
        graph.flush();
    }

    private static void openCurrentGraphFile(BufferedWriter graph) throws IOException {
        graph.write("digraph {");
        graph.newLine();
        graph.write("  rankdir=TB;");
        graph.newLine();
        graph.write("  labeljust=\"l\";");
        graph.newLine();
        graph.write("  compound= true;");
        graph.newLine();
        graph.flush();
    }

    private static void openDependenceGraph(BufferedWriter graph) throws IOException {
        graph.write("  subgraph dependence_graph {");
        graph.newLine();
        graph.write("    ranksep=0.20;");
        graph.newLine();
        graph.write("    node[height=0.75];");
        graph.newLine();
        graph.flush();
    }

    private static void openLegend(BufferedWriter graph) throws IOException {
        graph.write("  subgraph legend {");
        graph.newLine();
        graph.write("    rank=sink;");
        graph.newLine();
        graph.write("    node [shape=plaintext, height=0.75];");
        graph.newLine();
        graph.write("    ranksep=0.20;");
        graph.newLine();
        graph.write("    label = \"Legend\";");
        graph.newLine();
        graph.write("    key [label=<");
        graph.newLine();
        graph.write("      <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" cellborder=\"1\">");
        graph.newLine();
        graph.flush();
    }

    private static void closeGraphFile(BufferedWriter graph) throws IOException {
        graph.write("}");
        graph.newLine();
        graph.flush();
    }

    private static void closeDependenceGraph(BufferedWriter graph) throws IOException {
        graph.write("  }");
        graph.newLine();
        graph.flush();
    }

    private static void closeLegend(BufferedWriter graph) throws IOException {
        graph.write("      </table>");
        graph.newLine();
        graph.write("    >]");
        graph.newLine();
        graph.write("  }");
        graph.newLine();
        graph.flush();
    }

    static {
        openCollectivesEdges = 0;
        pendingGroupDependencies = new HashMap();
        openCommutativeGroups = new HashMap();
        LOGGER = LogManager.getLogger("es.bsc.compss.Components");
        if (GRAPH_GENERATOR_ENABLED) {
            MONITOR_DIR_PATH = LoggerManager.getLogDir() + "monitor" + File.separator;
            if (!new File(MONITOR_DIR_PATH).mkdir()) {
                ErrorManager.error(ERROR_MONITOR_DIR);
            }
            CURRENT_GRAPH_FILE = MONITOR_DIR_PATH + CURRENT_GRAPH_FILENAME;
            COMPLETE_GRAPH_FILE = MONITOR_DIR_PATH + COMPLETE_GRAPH_FILENAME;
            COMPLETE_GRAPH_TMP_FILE = MONITOR_DIR_PATH + COMPLETE_GRAPH_TMP_FILENAME;
            COMPLETE_LEGEND_TMP_FILE = MONITOR_DIR_PATH + COMPLETE_LEGEND_TMP_FILENAME;
            try {
                current_graph = new BufferedWriter(new FileWriter(CURRENT_GRAPH_FILE));
                GraphGenerator.emptyCurrentGraph();
                current_graph.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating current graph file", (Throwable)ioe);
            }
            try {
                full_graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_FILE));
                GraphGenerator.emptyFullGraph();
                full_graph.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating full graph file", (Throwable)ioe);
            }
            try {
                full_graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_TMP_FILE));
                GraphGenerator.openFullGraphFile(full_graph);
                GraphGenerator.openDependenceGraph(full_graph);
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating graph file", (Throwable)ioe);
            }
            try {
                legend = new BufferedWriter(new FileWriter(COMPLETE_LEGEND_TMP_FILE));
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating full graph working copy file", (Throwable)ioe);
            }
            legendTasks = new HashSet();
        } else {
            MONITOR_DIR_PATH = null;
            CURRENT_GRAPH_FILE = CURRENT_GRAPH_FILENAME;
            COMPLETE_GRAPH_FILE = COMPLETE_GRAPH_FILENAME;
            COMPLETE_GRAPH_TMP_FILE = COMPLETE_GRAPH_TMP_FILENAME;
            COMPLETE_LEGEND_TMP_FILE = COMPLETE_LEGEND_TMP_FILENAME;
        }
    }
}

