/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.types.allocatableactions.MultiNodeExecutionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiNodeGroup {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    public static final int ID_MASTER_PROC = 1;
    public static final int ID_UNASSIGNED = -1;
    private static final AtomicLong NEXT_GROUP_ID = new AtomicLong();
    private final long groupId;
    private final int groupSize;
    private AtomicInteger nextProcessId;
    private boolean isAnyActionRunning;
    private final Set<MultiNodeExecutionAction> remainingActions;
    private final HashMap<Integer, MultiNodeExecutionAction> registeredSlaves;
    private MultiNodeExecutionAction registeredMaster;
    private int cancelled;

    public MultiNodeGroup(int groupSize) {
        LOGGER.debug("[MultiNodeGroup] Creating new group of size " + groupSize);
        this.groupId = NEXT_GROUP_ID.getAndIncrement();
        this.groupSize = groupSize;
        this.nextProcessId = new AtomicInteger(groupSize);
        this.isAnyActionRunning = false;
        this.remainingActions = new HashSet<MultiNodeExecutionAction>(groupSize);
        this.registeredSlaves = new HashMap();
        this.registeredMaster = null;
        this.cancelled = 0;
    }

    public void addAction(MultiNodeExecutionAction action) {
        this.remainingActions.add(action);
    }

    public long getGroupId() {
        return this.groupId;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public boolean isAnyActionRunning() {
        return this.isAnyActionRunning;
    }

    public void setActionRunning() {
        this.isAnyActionRunning = true;
    }

    public boolean isCancelled() {
        return this.cancelled == this.groupSize;
    }

    public void increaseCancelled() {
        ++this.cancelled;
    }

    public int registerProcess(MultiNodeExecutionAction action) {
        int actionId = this.nextProcessId.getAndDecrement();
        this.remainingActions.remove(action);
        if (actionId == 1) {
            LOGGER.debug("[MultiNodeGroup] Register action " + action.getId() + " as master of group " + this.groupId);
            this.registeredMaster = action;
        } else {
            LOGGER.debug("[MultiNodeGroup] Register action " + action.getId() + " as slave of group " + this.groupId);
            this.registeredSlaves.put(actionId, action);
            if (this.remainingActions.size() == this.groupSize - 1) {
                LOGGER.debug("[MultiNodeGroup] Upgrading actions of group " + this.groupId);
                this.updateRemainingActionScore();
            }
        }
        return actionId;
    }

    private void updateRemainingActionScore() {
        for (MultiNodeExecutionAction action : this.remainingActions) {
            action.upgrade();
        }
    }

    public MultiNodeExecutionAction getMasterAction() {
        return this.registeredMaster;
    }

    public List<String> getSlavesNames() {
        ArrayList<String> slavesNames = new ArrayList<String>();
        for (Map.Entry<Integer, MultiNodeExecutionAction> slave : this.registeredSlaves.entrySet()) {
            slavesNames.add(slave.getValue().getAssignedResource().getName());
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[MultiNodeGroup] SlaveNames of group ").append(this).append(" are:");
            for (String slaveName : slavesNames) {
                sb.append(" ").append(slaveName);
            }
            LOGGER.debug(sb.toString());
        }
        return slavesNames;
    }

    public void actionCompletion() {
        LOGGER.debug("[MultiNodeGroup] Notify action completion to all slaves of group " + this);
        for (Map.Entry<Integer, MultiNodeExecutionAction> entry : this.registeredSlaves.entrySet()) {
            entry.getValue().notifyCompleted();
        }
    }

    public void actionError() {
        this.nextProcessId = new AtomicInteger(this.groupSize);
        this.isAnyActionRunning = false;
        LOGGER.debug("[MultiNodeGroup] Notify action error to all slaves of group " + this);
        for (Map.Entry<Integer, MultiNodeExecutionAction> entry : this.registeredSlaves.entrySet()) {
            entry.getValue().notifyError();
        }
    }

    public String toString() {
        return "MultiNodeGroup@" + this.groupId;
    }
}

