/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.CollectionInfo;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.ObjectInfo;
import es.bsc.compss.types.data.StreamInfo;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;

public abstract class DataParams {
    private final Application app;

    public abstract String getDescription();

    public abstract DataInfo createDataInfo(DataInfoProvider var1);

    public abstract Integer getDataId(DataInfoProvider var1);

    public abstract Integer removeDataId(DataInfoProvider var1);

    public abstract void deleteLocal() throws Exception;

    public DataParams(Application app) {
        this.app = app;
    }

    public Application getApp() {
        return this.app;
    }

    public static class CollectionData
    extends DataParams {
        private final String collectionId;

        public CollectionData(Application app, String collectionId) {
            super(app);
            this.collectionId = collectionId;
        }

        @Override
        public String getDescription() {
            return "collection  " + this.collectionId;
        }

        @Override
        public Integer getDataId(DataInfoProvider dip) {
            Application app = this.getApp();
            return app.getCollectionDataId(this.collectionId);
        }

        @Override
        public DataInfo createDataInfo(DataInfoProvider dip) {
            CollectionInfo cInfo = new CollectionInfo(this);
            Application app = this.getApp();
            app.registerCollectionData(this.collectionId, cInfo);
            return cInfo;
        }

        @Override
        public Integer removeDataId(DataInfoProvider dip) {
            Application app = this.getApp();
            return app.removeCollectionData(this.collectionId);
        }

        public String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public void deleteLocal() throws Exception {
        }
    }

    public static class ExternalStreamData
    extends StreamData {
        public ExternalStreamData(Application app, int code) {
            super(app, code);
        }

        @Override
        public String getDescription() {
            return "external " + super.getDescription();
        }
    }

    public static class StreamData
    extends ObjectData {
        public StreamData(Application app, int code) {
            super(app, code);
        }

        @Override
        public String getDescription() {
            return "stream " + this.code;
        }

        @Override
        public DataInfo createDataInfo(DataInfoProvider dip) {
            StreamInfo sInfo = new StreamInfo(this);
            Application app = this.getApp();
            app.registerObjectData(this.code, sInfo);
            return sInfo;
        }
    }

    public static class BindingObjectData
    extends ObjectData {
        public BindingObjectData(Application app, int code) {
            super(app, code);
        }

        @Override
        public String getDescription() {
            return "binding " + super.getDescription();
        }
    }

    public static class ExternalPSCObjectData
    extends ObjectData {
        public ExternalPSCObjectData(Application app, int code) {
            super(app, code);
        }

        @Override
        public String getDescription() {
            return "external " + super.getDescription();
        }
    }

    public static class ObjectData
    extends DataParams {
        protected final int code;

        public ObjectData(Application app, int code) {
            super(app);
            this.code = code;
        }

        @Override
        public Integer getDataId(DataInfoProvider dip) {
            Application app = this.getApp();
            return app.getObjectDataId(this.code);
        }

        @Override
        public String getDescription() {
            return "object with code " + this.code;
        }

        @Override
        public DataInfo createDataInfo(DataInfoProvider dip) {
            ObjectInfo oInfo = new ObjectInfo(this);
            Application app = this.getApp();
            app.registerObjectData(this.code, oInfo);
            return oInfo;
        }

        @Override
        public Integer removeDataId(DataInfoProvider dip) {
            Application app = this.getApp();
            return app.removeObjectData(this.code);
        }

        public final int getCode() {
            return this.code;
        }

        @Override
        public void deleteLocal() throws Exception {
        }
    }

    public static class DirectoryData
    extends FileData {
        public DirectoryData(Application app, DataLocation loc) {
            super(app, loc);
        }

        @Override
        public String getDescription() {
            return "directory " + this.locKey;
        }
    }

    public static class FileData
    extends DataParams {
        protected final String locKey;
        private final DataLocation loc;

        public FileData(Application app, DataLocation loc) {
            super(app);
            this.loc = loc;
            this.locKey = loc.getLocationKey();
        }

        @Override
        public String getDescription() {
            return "file " + this.locKey;
        }

        @Override
        public DataInfo createDataInfo(DataInfoProvider dip) {
            Application app = this.getApp();
            FileInfo dInfo = new FileInfo(this);
            app.registerFileData(this.locKey, dInfo);
            return dInfo;
        }

        @Override
        public Integer getDataId(DataInfoProvider dip) {
            Application app = this.getApp();
            String locationKey = this.loc.getLocationKey();
            return app.getFileDataId(locationKey);
        }

        @Override
        public Integer removeDataId(DataInfoProvider dip) {
            Application app = this.getApp();
            String locationKey = this.loc.getLocationKey();
            return app.removeFileData(locationKey);
        }

        public DataLocation getLocation() {
            return this.loc;
        }

        @Override
        public void deleteLocal() throws Exception {
            String filePath = this.getLocation().getURIInHost(Comm.getAppHost()).getPath();
            File f = new File(filePath);
            FileOpsManager.deleteSync(f);
        }
    }
}

