/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class CollectionAccessParams
extends AccessParams<DataParams.CollectionData> {
    private static final long serialVersionUID = 1L;

    public static final CollectionAccessParams constructCAP(Application app, Direction dir, String collectionId) {
        return new CollectionAccessParams(app, dir, collectionId);
    }

    private CollectionAccessParams(Application app, Direction dir, String collectionId) {
        super(new DataParams.CollectionData(app, collectionId), dir);
    }

    @Override
    public void checkAccessValidity(DataInfoProvider dip) throws ValueUnawareRuntimeException {
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataVersion dv = dInfo.getCurrentDataVersion();
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerCollection(renaming, null);
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }

    @Override
    public void externalRegister() {
    }
}

