/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class DeleteDataRequest
extends APRequest {
    private final DataParams data;
    private final Semaphore sem;
    private ValueUnawareRuntimeException unawareException = null;
    private final boolean applicationDelete;

    public DeleteDataRequest(DataParams data, boolean applicationDelete) {
        this.data = data;
        this.sem = new Semaphore(0);
        this.applicationDelete = applicationDelete;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        try {
            LOGGER.info("[DeleteDataRequest] Deleting Data in Task Analyser");
            ta.deleteData(this.data, this.applicationDelete);
        }
        catch (ValueUnawareRuntimeException vure) {
            this.unawareException = vure;
        }
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DELETE_DATA;
    }
}

