/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.HTTPImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.updates.BusyResources;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.LinkedList;

public class BusyWorkerAction<T extends WorkerResourceDescription>
extends AllocatableAction {
    private final ResourceScheduler<T> worker;
    private final Implementation impl;
    private final BusyResources<T> ru;

    public BusyWorkerAction(SchedulingInformation schedulingInformation, ResourceScheduler<T> worker, TaskScheduler ts, ResourceUpdate<T> modification) {
        super(schedulingInformation, ts.getOrchestrator());
        this.worker = worker;
        this.ru = (BusyResources)modification;
        this.impl = modification.getModification() instanceof MethodResourceDescription ? AbstractMethodImplementation.generateDummy((MethodResourceDescription)modification.getModification()) : HTTPImplementation.generateDummy();
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return false;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        this.ru.notifyCompletion();
        this.notifyCompleted();
    }

    @Override
    protected void doAbort() {
    }

    @Override
    protected void doCompleted() {
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doFailed() {
        LOGGER.error("Error waiting for tasks to end");
    }

    @Override
    protected boolean doCanceled() {
        return true;
    }

    @Override
    protected void doFailIgnored() {
    }

    @Override
    protected Collection<AllocatableAction> doException(COMPSsException e) {
        return new LinkedList<AllocatableAction>();
    }

    @Override
    public Integer getCoreId() {
        return null;
    }

    public LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> workers = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        workers.add(this.worker);
        return workers;
    }

    @Override
    public Implementation[] getImplementations() {
        Implementation[] impls = new Implementation[]{this.impl};
        return impls;
    }

    public <R extends WorkerResourceDescription> boolean isCompatible(Worker<R> r) {
        return r == this.worker.getResource();
    }

    public <R extends WorkerResourceDescription> LinkedList<Implementation> getCompatibleImplementations(ResourceScheduler<R> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        if (r == this.worker) {
            impls.add(this.impl);
        }
        return impls;
    }

    public <R extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<R> targetWorker, Score actionScore) {
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(this.worker, this.impl);
    }

    @Override
    public void schedule(Collection<ResourceScheduler<? extends WorkerResourceDescription>> candidates, Score actionScore) throws UnassignedActionException {
        if (!candidates.contains(this.worker)) {
            throw new UnassignedActionException();
        }
        this.schedule(this.worker, this.impl);
    }

    @Override
    public void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Score actionScore) throws UnassignedActionException {
        if (targetWorker != this.worker) {
            throw new UnassignedActionException();
        }
        this.schedule(targetWorker, this.impl);
    }

    @Override
    public void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Implementation impl) throws UnassignedActionException {
        if (targetWorker != this.worker) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "BusyWorkerAction (Worker " + this.worker.getName() + ")";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getGroupPriority() {
        return -1L;
    }

    @Override
    public OnFailure getOnFailure() {
        return OnFailure.RETRY;
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return false;
    }

    @Override
    protected void stopAction() throws Exception {
    }
}

