/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ImplementationDescription;
import java.util.ArrayList;
import java.util.List;

public class CoreElement {
    private final int coreId;
    private final String signature;
    private final List<Implementation> implementations;

    public CoreElement(int coreId, String signature) {
        this.coreId = coreId;
        this.signature = signature;
        this.implementations = new ArrayList<Implementation>();
    }

    public int getCoreId() {
        return this.coreId;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean addImplementation(ImplementationDescription<?, ?> implDef) {
        boolean alreadyExisting = false;
        String implSignature = implDef.getSignature();
        for (Implementation impl : this.implementations) {
            String registeredImplSign = impl.getSignature();
            if (implSignature.compareTo(registeredImplSign) != 0) continue;
            alreadyExisting = true;
            break;
        }
        if (!alreadyExisting) {
            Implementation impl;
            int implId = this.implementations.size();
            impl = implDef.getImpl(this.coreId, implId);
            this.implementations.add(impl);
        }
        return alreadyExisting;
    }

    public List<Implementation> getImplementations() {
        return this.implementations;
    }

    public Implementation getImplementation(int implId) {
        return this.implementations.get(implId);
    }

    public int getImplementationsCount() {
        return this.implementations.size();
    }

    public void registerImplementations(List<Implementation> impls) {
        this.implementations.addAll(impls);
    }

    public String getImplementationSignature(int implId) {
        return this.implementations.get(implId).getSignature();
    }
}

