/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.info;

import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.DataOwner;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.types.request.exceptions.NonExistingValueException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataInfo<T extends DataParams> {
    private static final int FIRST_FILE_ID = 1;
    private static final int FIRST_VERSION_ID = 1;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static int nextDataId = 1;
    protected final int dataId = nextDataId++;
    protected final T params;
    protected final DataOwner owner;
    protected DataVersion currentVersion;
    private int currentVersionId;
    private TreeMap<Integer, DataVersion> versions;
    private int deletionBlocks;
    private final LinkedList<DataVersion> pendingDeletions;
    private final LinkedList<Integer> canceledVersions;
    private boolean deleted;

    public DataInfo(T data, DataOwner owner) {
        this.params = data;
        this.owner = owner;
        this.versions = new TreeMap();
        this.currentVersionId = 1;
        this.currentVersion = new DataVersion(this.dataId, 1, null);
        this.versions.put(this.currentVersionId, this.currentVersion);
        this.deletionBlocks = 0;
        this.pendingDeletions = new LinkedList();
        this.canceledVersions = new LinkedList();
        this.deleted = false;
    }

    public final int getDataId() {
        return this.dataId;
    }

    public final T getParams() {
        return this.params;
    }

    public DataOwner getOwner() {
        return this.owner;
    }

    public final DataVersion getFirstVersion() {
        return this.versions.get(1);
    }

    protected void newVersion() {
        ++this.currentVersionId;
        DataVersion validPred = this.currentVersion;
        if (validPred.hasBeenCancelled()) {
            validPred = validPred.getPreviousValidPredecessor();
        }
        DataVersion newVersion = new DataVersion(this.dataId, this.currentVersionId, validPred);
        this.versions.put(this.currentVersionId, newVersion);
        this.currentVersion = newVersion;
    }

    public final DataVersion getCurrentDataVersion() {
        return this.currentVersion;
    }

    public final EngineDataAccessId getLastAccess(AccessParams.AccessMode mode) {
        EngineDataAccessId daId = null;
        if (this.currentVersion != null) {
            switch (mode) {
                case C: 
                case R: {
                    daId = new RAccessId(this, this.currentVersion);
                    break;
                }
                case W: {
                    daId = new WAccessId(this, this.currentVersion);
                    break;
                }
                case CV: 
                case RW: {
                    DataVersion readInstance = this.versions.get(this.currentVersionId - 1);
                    if (readInstance != null) {
                        daId = new RWAccessId(this, readInstance, this.currentVersion);
                        break;
                    }
                    LOGGER.warn("Previous instance for data" + this.dataId + " is null.");
                }
            }
        } else {
            LOGGER.warn("Current instance for data" + this.dataId + " is null.");
        }
        return daId;
    }

    protected void currentVersionWillBeRead() {
        this.currentVersion.willBeRead();
        this.currentVersion.versionUsed();
    }

    protected void currentVersionWillBeWritten() {
        this.currentVersion.willBeWritten();
        this.currentVersion.versionUsed();
    }

    public abstract EngineDataAccessId willAccess(AccessParams.AccessMode var1);

    private void tryRemoveVersion(Integer versionId) {
        DataVersion version = this.versions.get(versionId);
        if (version != null && version.markToDelete()) {
            version.getDataInstanceId().delete();
            this.versions.remove(versionId);
        }
    }

    public void committedAccess(EngineDataAccessId dAccId) {
        Integer rVersionId = null;
        if (dAccId.isRead()) {
            rVersionId = ((EngineDataAccessId.ReadingDataAccessId)((Object)dAccId)).getReadDataInstance().getVersionId();
            this.versionHasBeenRead(rVersionId);
        }
        if (dAccId.isWrite()) {
            Integer wVersionId = ((EngineDataAccessId.WritingDataAccessId)((Object)dAccId)).getWrittenDataInstance().getVersionId();
            if (rVersionId == null) {
                rVersionId = wVersionId - 1;
            }
            this.tryRemoveVersion(rVersionId);
            this.versionHasBeenWritten(wVersionId);
        }
    }

    private void versionHasBeenRead(int versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (readVersion.hasBeenRead()) {
            readVersion.getDataInstanceId().delete();
            this.versions.remove(versionId);
        }
    }

    private void versionHasBeenWritten(int versionId) {
        DataVersion writtenVersion = this.versions.get(versionId);
        if (writtenVersion.hasBeenWritten()) {
            writtenVersion.getDataInstanceId().delete();
            this.versions.remove(versionId);
        }
    }

    public final boolean isCurrentVersionBeenUsed() {
        return this.currentVersion.hasBeenUsed();
    }

    public void cancelledAccess(EngineDataAccessId dAccId, boolean keepModified) {
        switch (dAccId.getDirection()) {
            case C: 
            case R: {
                Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                this.canceledReadVersion(rVersionId);
                break;
            }
            case CV: 
            case RW: {
                Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                if (keepModified) {
                    this.versionHasBeenRead(rVersionId);
                    this.tryRemoveVersion(rVersionId);
                    this.versionHasBeenWritten(wVersionId);
                    break;
                }
                this.canceledReadVersion(rVersionId);
                this.canceledWriteVersion(wVersionId);
                break;
            }
            default: {
                Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                this.canceledWriteVersion(wVersionId);
            }
        }
    }

    private void canceledReadVersion(Integer versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (!this.deleted && readVersion.isToDelete() && readVersion.hasBeenUsed()) {
            readVersion.unmarkToDelete();
        }
        if (readVersion.hasBeenRead()) {
            readVersion.getDataInstanceId().delete();
            this.versions.remove(versionId);
        }
    }

    private void canceledWriteVersion(Integer versionId) {
        DataVersion version = this.versions.get(versionId);
        version.versionCancelled();
        this.canceledVersions.add(versionId);
        if (versionId == this.currentVersionId) {
            DataVersion firstVersion;
            Integer lastVersion = this.currentVersionId;
            while (this.canceledVersions.contains(lastVersion)) {
                this.tryRemoveVersion(lastVersion);
                lastVersion = lastVersion - 1;
            }
            if (lastVersion > 1) {
                this.currentVersionId = lastVersion;
                this.currentVersion = this.versions.get(this.currentVersionId);
            } else if (lastVersion == 1 && (firstVersion = this.getFirstVersion()) != null && firstVersion.hasBeenUsed()) {
                this.currentVersionId = lastVersion;
                this.currentVersion = firstVersion;
            }
        }
    }

    public final void blockDeletions() {
        ++this.deletionBlocks;
    }

    public final boolean unblockDeletions() {
        --this.deletionBlocks;
        if (this.deletionBlocks == 0) {
            for (DataVersion version : this.pendingDeletions) {
                if (!version.markToDelete()) continue;
                version.getDataInstanceId().delete();
                this.versions.remove(version.getDataInstanceId().getVersionId());
            }
            if (this.versions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void delete() {
        this.deleted = true;
        if (this.deletionBlocks > 0) {
            this.pendingDeletions.addAll(this.versions.values());
        } else {
            LinkedList<Integer> removedVersions = new LinkedList<Integer>();
            for (DataVersion version : this.versions.values()) {
                if (!version.markToDelete()) continue;
                version.getDataInstanceId().delete();
                removedVersions.add(version.getDataInstanceId().getVersionId());
            }
            Iterator<DataVersion> iterator = removedVersions.iterator();
            while (iterator.hasNext()) {
                int versionId = (Integer)((Object)iterator.next());
                this.versions.remove(versionId);
            }
        }
    }

    public abstract void waitForDataReadyToDelete(Semaphore var1) throws NonExistingValueException;

    public final boolean isCurrentVersionToDelete() {
        return this.currentVersion.isToDelete();
    }

    public abstract boolean readValue(Task var1, DependencyParameter var2, boolean var3);

    public abstract void writeValue(Task var1, DependencyParameter var2, boolean var3);

    public abstract void mainAccess(RegisterDataAccessRequest var1, EngineDataAccessId var2);

    public abstract void completedProducer(AbstractTask var1);

    public abstract AbstractTask getLastVersionProducer();

    public abstract List<AbstractTask> getDataWriters();
}

