/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskAnalysisRequest
implements APRequest {
    private static final Logger TIMER_LOGGER = LogManager.getLogger("es.bsc.compss.Timers");
    private static final boolean IS_TIMER_COMPSS_ENABLED;
    private final Task task;

    public TaskAnalysisRequest(Task task) {
        this.task = task;
    }

    public AbstractTask getTask() {
        return this.task;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) {
        if (IS_TIMER_COMPSS_ENABLED) {
            long startTime = System.nanoTime();
            this.processTask();
            long endTime = System.nanoTime();
            float elapsedTime = (float)(endTime - startTime) / 1000000.0f;
            TIMER_LOGGER.info("[TIMER] TA Process of task " + this.task.getId() + ": " + elapsedTime + " ms");
        } else {
            this.processTask();
        }
        if (this.task.getStatus() == TaskState.RECOVERED) {
            if (DEBUG) {
                LOGGER.debug("Task " + this.task.getId() + " was checkpointed in a previous run. Skipping execution.");
            }
            this.task.end(true);
        } else {
            td.executeTask(ap, this.task);
        }
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onAccessesProcessed();
    }

    private void processTask() {
        TaskDescription<Parameter> description = this.task.getTaskDescription();
        LOGGER.info("New " + description.getType().toString().toLowerCase() + " task: Name:" + description.getName() + "), ID = " + this.task.getId() + " APP = " + this.task.getApplication().getId());
        this.task.register();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.ANALYSE_TASK;
    }

    static {
        String isTimerCOMPSsEnabledProperty = System.getProperty("compss.timers");
        IS_TIMER_COMPSS_ENABLED = isTimerCOMPSsEnabledProperty == null || isTimerCOMPSsEnabledProperty.isEmpty() || isTimerCOMPSsEnabledProperty.equals("null") ? false : Boolean.valueOf(isTimerCOMPSsEnabledProperty);
    }
}

