/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.NonExistingValueException;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class WaitForDataReadyToDeleteRequest
implements APRequest {
    private final Application app;
    private final DataParams data;
    private ValueUnawareRuntimeException vure = null;
    private NonExistingValueException neve = null;
    private final Semaphore sem;

    public WaitForDataReadyToDeleteRequest(Application app, DataParams data) {
        this.data = data;
        this.sem = new Semaphore(0);
        this.app = app;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) {
        LOGGER.info("[WaitForDataReadyToDelete] Notifying waiting data " + this.data.getDescription() + "to DIP...");
        try {
            LOGGER.debug("Waiting for data " + this.data.getDescription() + " to be ready for deletion");
            DataInfo dataInfo = this.data.getRegisteredData(this.app);
            if (dataInfo == null) {
                if (DEBUG) {
                    LOGGER.debug("No data found for data associated to " + this.data.getDescription());
                }
                throw new ValueUnawareRuntimeException();
            }
            dataInfo.waitForDataReadyToDelete(this.sem);
        }
        catch (ValueUnawareRuntimeException vure) {
            this.vure = vure;
            this.sem.release();
        }
        catch (NonExistingValueException neve) {
            this.neve = neve;
            this.sem.release();
        }
    }

    public void waitForDataReadiness() throws ValueUnawareRuntimeException, NonExistingValueException {
        this.sem.acquireUninterruptibly();
        if (this.vure != null) {
            throw this.vure;
        }
        if (this.neve != null) {
            throw this.neve;
        }
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DELETE_DATA;
    }
}

