/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.DotGraph;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.components.monitor.impl.NoGraph;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeMonitor
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components");
    private static final Logger LOGGER_API = LogManager.getLogger("es.bsc.compss.API");
    private static final String ERROR_MONITOR_DIR = "ERROR: Cannot create monitor directory";
    private static final String ERROR_GENERATING_DATA = "Error generating monitoring data";
    private static final boolean MONITOR_ENABLED = System.getProperty("compss.monitor") != null && !System.getProperty("compss.monitor").equals("0");
    private static final String MONITOR_DIR_PATH = LoggerManager.getLogDir() + "monitor" + File.separator;
    private final TaskDispatcher td;
    private final AccessProcessor ap;
    private final GraphHandler gh;
    private final long sleepTime;
    private boolean keepRunning;
    private boolean running;
    private final Thread monitor;
    private final String installDir;

    public static boolean isEnabled() {
        return MONITOR_ENABLED;
    }

    public RuntimeMonitor(AccessProcessor ap, TaskDispatcher td, long sleepTime) {
        this.td = td;
        this.ap = ap;
        if (GraphGenerator.isEnabled()) {
            if (!new File(MONITOR_DIR_PATH).mkdir()) {
                ErrorManager.error(ERROR_MONITOR_DIR);
            }
            this.gh = new DotGraph(MONITOR_DIR_PATH);
        } else {
            this.gh = new NoGraph();
        }
        this.keepRunning = true;
        this.sleepTime = sleepTime;
        this.installDir = System.getenv().get("COMPSS_HOME");
        if (RuntimeMonitor.isEnabled()) {
            this.monitor = new Thread(this);
            this.monitor.setName("Monitor Thread");
            this.monitor.start();
        } else {
            this.monitor = null;
        }
    }

    public GraphHandler getGraphHandler() {
        return this.gh;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.keepRunning) {
            try {
                this.getXMLTaskState();
                this.printCurrentGraph();
                this.td.printCurrentState();
                ResourceManager.printResourcesState();
                Thread.sleep(this.sleepTime);
            }
            catch (IOException ioe) {
                LOGGER.error(ERROR_GENERATING_DATA, (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                LOGGER.error(ERROR_GENERATING_DATA, (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        this.running = false;
    }

    public void shutdown() {
        if (RuntimeMonitor.isEnabled()) {
            LOGGER_API.debug("Stopping Monitor...");
            this.keepRunning = false;
            try {
                while (this.running) {
                    Thread.sleep(this.sleepTime);
                }
                this.getXMLTaskState();
                this.printCurrentGraph();
            }
            catch (IOException | InterruptedException ioe) {
                LOGGER.error(ERROR_GENERATING_DATA, (Throwable)ioe);
            }
            if (!new File(MONITOR_DIR_PATH + "monitor.xml").delete()) {
                LOGGER.error("Error clearing monitor.xml execution files");
            }
        }
        if (GraphGenerator.isEnabled()) {
            LOGGER_API.debug("Stopping Graph generation...");
            this.gh.removeCurrentGraph();
        }
    }

    private void getXMLTaskState() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"").append(this.installDir).append("/xml/monitor/monitor.xsl\"?>").append("\n");
        sb.append("<COMPSsState>").append("\n");
        sb.append(this.ap.getCurrentTaskState());
        sb.append(this.td.getCurrentMonitoringData());
        sb.append("</COMPSsState>");
        BufferedWriter fw = new BufferedWriter(new FileWriter(MONITOR_DIR_PATH + "COMPSs_state.xml"));
        fw.write(sb.toString());
        fw.close();
    }

    private void printCurrentGraph() {
        BufferedWriter graph = this.gh.getAndOpenCurrentGraph();
        if (graph != null) {
            this.td.printCurrentGraph(graph);
            this.gh.closeCurrentGraph();
        }
    }
}

