/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDescription;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class ContainerInvoker
extends Invoker {
    private static final int NUM_BASE_DOCKER_PYTHON_ARGS = 25;
    private static final int NUM_BASE_DOCKER_BINARY_ARGS = 12;
    private static final int NUM_BASE_SINGULARITY_PYTHON_ARGS = 21;
    private static final int NUM_BASE_SINGULARITY_BINARY_ARGS = 10;
    private static final int NUM_BASE_UDOCKER_PYTHON_ARGS = 24;
    private static final int NUM_BASE_UDOCKER_BINARY_ARGS = 11;
    private static final String REL_PATH_WD = ".." + File.separator + ".." + File.separator;
    private static final String REL_PATH_WORKER_CONTAINER = File.separator + "pycompss" + File.separator + "worker" + File.separator + "container" + File.separator + "container_worker.py";
    private final ContainerDescription container;
    private final ContainerDefinition.ContainerExecutionType internalExecutionType;
    private final String internalBinary;
    private final String internalParams;
    private final String internalFunction;
    private final boolean failByEV;
    private BinaryRunner br;

    public ContainerInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        ContainerDefinition containerImpl = null;
        try {
            containerImpl = (ContainerDefinition)invocation.getMethodImplementation().getDefinition();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()), e);
        }
        this.container = containerImpl.getContainer();
        this.internalExecutionType = containerImpl.getInternalExecutionType();
        this.internalBinary = containerImpl.getInternalBinary();
        this.internalParams = containerImpl.getInternalParams();
        this.internalFunction = containerImpl.getInternalFunction();
        this.failByEV = containerImpl.isFailByEV();
        this.br = null;
    }

    private boolean hasParamsString() {
        return this.internalParams != null && !this.internalParams.equals("[unassigned]");
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        LOGGER.info("Invoked Container execution (internalType = " + (Object)((Object)this.internalExecutionType) + ", internalBinary = " + this.internalBinary + ", internalFunction = " + this.internalFunction + ") in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            LOGGER.error("Exception running container", (Throwable)iee);
            throw new JobExecutionException(iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams languageParams = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (languageParams instanceof PythonParams) {
                    PythonParams pp = (PythonParams)languageParams;
                    pythonInterpreter = pp.checkCoverageAndGetPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("Python Container Execution of Job " + this.invocation.getJobId() + " (Task " + this.invocation.getTaskId() + ") has exit value " + retValue.toString());
                break;
            }
            case CET_BINARY: {
                for (InvocationParam invocationParam : this.invocation.getResults()) {
                    if (invocationParam.getType() == DataType.FILE_T) {
                        this.serializeBinaryExitValue(invocationParam, retValue);
                        continue;
                    }
                    invocationParam.setValue(retValue);
                    invocationParam.setValueClass(retValue.getClass());
                }
                break;
            }
        }
        if (this.failByEV && !retValue.toString().equals("0")) {
            throw new JobExecutionException("Received non-zero exit value (" + retValue.toString() + ") for Job " + this.invocation.getJobId() + " (Task " + this.invocation.getTaskId() + ")");
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String appDir;
        String workingDir;
        String workingDirMountPoint;
        String pythonInterpreter = null;
        String pythonVersion = null;
        String pythonPath = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.checkCoverageAndGetPythonInterpreter();
            pythonVersion = pp.getPythonVersion();
            pythonPath = pp.getPythonPath();
        }
        if ((workingDirMountPoint = (workingDir = (workingDir = this.sandBox.getFolder().getAbsolutePath()).endsWith(File.separator) ? workingDir : workingDir + File.separator)).contains("sandBox")) {
            workingDirMountPoint = new File(workingDirMountPoint).getParentFile().getParent();
        }
        appDir = (appDir = this.context.getAppDir()).endsWith(File.separator) ? appDir : appDir + File.separator;
        String pyCompssDir = this.context.getInstallDir();
        pyCompssDir = pyCompssDir.endsWith(File.separator) ? pyCompssDir : pyCompssDir + File.separator;
        pyCompssDir = pyCompssDir + "Bindings" + File.separator + "python" + File.separator + "3";
        boolean hasTarget = false;
        String returnType = "null";
        int returnLength = 0;
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                hasTarget = this.invocation.getTarget() != null;
                List<? extends InvocationParam> results = this.invocation.getResults();
                if (results == null || results.isEmpty()) break;
                returnType = String.valueOf(DataType.FILE_T.ordinal());
                returnLength = results.size();
                break;
            }
        }
        StdIOStream streamValues = new StdIOStream();
        List<String> containerCallParams = new ArrayList<String>();
        int numContainerCallParams = 0;
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                InvocationParam userParam;
                int i;
                if (hasTarget) {
                    this.addParamInfo(containerCallParams, this.invocation.getTarget());
                    ++numContainerCallParams;
                }
                if (returnLength > 0) {
                    for (i = 0; i < this.invocation.getResults().size(); ++i) {
                        userParam = this.invocation.getResults().get(i);
                        this.addParamInfo(containerCallParams, userParam);
                        ++numContainerCallParams;
                    }
                }
                for (i = 0; i < this.invocation.getParams().size(); ++i) {
                    userParam = this.invocation.getParams().get(i);
                    this.addParamInfo(containerCallParams, userParam);
                    ++numContainerCallParams;
                }
                break;
            }
            case CET_BINARY: {
                containerCallParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
                if (!this.hasParamsString()) break;
                containerCallParams = Arrays.asList(BinaryRunner.buildAppParams(this.invocation.getParams(), this.internalParams, pythonInterpreter));
            }
        }
        int numOptions = 0;
        String[] options = null;
        String optionsStr = this.container.getOptions().trim();
        if (optionsStr != null && !optionsStr.isEmpty() && !optionsStr.equals("[unassigned]")) {
            options = BinaryRunner.buildAppParams(this.invocation.getParams(), optionsStr, pythonInterpreter);
            numOptions = options.length;
        }
        int numCmdArgs = 0;
        block7 : switch (this.container.getEngine()) {
            case DOCKER: {
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        numCmdArgs = 25 + numOptions + containerCallParams.size();
                        break;
                    }
                    case CET_BINARY: {
                        numCmdArgs = 12 + numOptions + containerCallParams.size();
                    }
                }
                break;
            }
            case SINGULARITY: {
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        numCmdArgs = 21 + numOptions + containerCallParams.size();
                        break;
                    }
                    case CET_BINARY: {
                        numCmdArgs = 10 + numOptions + containerCallParams.size();
                    }
                }
                break;
            }
            case UDOCKER: {
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        numCmdArgs = 24 + numOptions + containerCallParams.size();
                        break block7;
                    }
                    case CET_BINARY: {
                        numCmdArgs = 11 + numOptions + containerCallParams.size();
                    }
                }
            }
        }
        String[] cmd = new String[numCmdArgs];
        int cmdIndex = 0;
        switch (this.container.getEngine()) {
            case DOCKER: {
                cmd[cmdIndex++] = "docker";
                cmd[cmdIndex++] = "run";
                cmd[cmdIndex++] = "-i";
                cmd[cmdIndex++] = "--rm";
                cmd[cmdIndex++] = "-v";
                String dockerWorkDirVolume = System.getenv("DOCKER_WORKING_DIR_VOLUME");
                LOGGER.info("Docker Working Dir Volume: {}", (Object)dockerWorkDirVolume);
                if (dockerWorkDirVolume != null && !dockerWorkDirVolume.isEmpty()) {
                    String dockerWorkDirMount = System.getenv("DOCKER_WORKING_DIR_MOUNT");
                    cmd[cmdIndex++] = dockerWorkDirVolume + ":" + dockerWorkDirMount;
                } else {
                    cmd[cmdIndex++] = workingDirMountPoint + ":" + workingDirMountPoint;
                }
                cmd[cmdIndex++] = "-v";
                String appDirVolume = System.getenv("DOCKER_APP_DIR_VOLUME");
                LOGGER.info("Docker APP Dir Volume: {}", (Object)appDirVolume);
                if (appDirVolume != null && !appDirVolume.isEmpty()) {
                    String dockerAppDirMount = System.getenv("DOCKER_APP_DIR_MOUNT");
                    LOGGER.info("Docker APP Dir mount: {}", (Object)dockerAppDirMount);
                    cmd[cmdIndex++] = appDirVolume + ":" + dockerAppDirMount;
                } else {
                    cmd[cmdIndex++] = appDir + ":" + appDir;
                }
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        cmd[cmdIndex++] = "-v";
                        String pycompssVol = System.getenv("DOCKER_PYCOMPSS_VOLUME");
                        LOGGER.info("Docker PYCOMPSS Dir Volume: {}", (Object)pycompssVol);
                        if (pycompssVol != null && !pycompssVol.isEmpty()) {
                            String pycompssMount = System.getenv("DOCKER_PYCOMPSS_MOUNT");
                            LOGGER.info("Docker pycompss mount: {}", (Object)pycompssMount);
                            cmd[cmdIndex++] = pycompssVol + ":" + pycompssMount;
                        } else {
                            cmd[cmdIndex++] = pyCompssDir + File.separator + "pycompss" + File.separator + ":" + pyCompssDir + File.separator + "pycompss";
                        }
                        cmd[cmdIndex++] = "--env";
                        cmd[cmdIndex++] = "PYTHONPATH=" + pythonPath + ":" + pyCompssDir;
                        break;
                    }
                }
                cmd[cmdIndex++] = "-w";
                cmd[cmdIndex++] = workingDir;
                cmdIndex = ContainerInvoker.addContainerOptions(cmd, cmdIndex, options);
                cmd[cmdIndex++] = this.container.getImage();
                break;
            }
            case SINGULARITY: {
                cmd[cmdIndex++] = "singularity";
                cmd[cmdIndex++] = "exec";
                cmd[cmdIndex++] = "--bind";
                cmd[cmdIndex++] = workingDirMountPoint + ":" + workingDirMountPoint;
                cmd[cmdIndex++] = "--bind";
                cmd[cmdIndex++] = appDir + ":" + appDir;
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        cmd[cmdIndex++] = "--bind";
                        cmd[cmdIndex++] = pyCompssDir + ":" + pyCompssDir;
                        break;
                    }
                }
                cmd[cmdIndex++] = "--pwd";
                cmd[cmdIndex++] = workingDir;
                cmdIndex = ContainerInvoker.addContainerOptions(cmd, cmdIndex, options);
                cmd[cmdIndex++] = this.container.getImage();
                break;
            }
            case UDOCKER: {
                cmd[cmdIndex++] = "udocker";
                cmd[cmdIndex++] = "run";
                cmd[cmdIndex++] = "--rm";
                cmd[cmdIndex++] = "-v";
                cmd[cmdIndex++] = workingDirMountPoint + ":" + workingDirMountPoint;
                cmd[cmdIndex++] = "-v";
                cmd[cmdIndex++] = appDir + ":" + appDir;
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        cmd[cmdIndex++] = "-v";
                        cmd[cmdIndex++] = pyCompssDir + File.separator + "pycompss" + File.separator + ":" + pyCompssDir + File.separator + "pycompss" + File.separator;
                        cmd[cmdIndex++] = "-e";
                        cmd[cmdIndex++] = "PYTHONPATH=" + pythonPath + ":" + pyCompssDir;
                        break;
                    }
                }
                cmd[cmdIndex++] = "-w";
                cmd[cmdIndex++] = workingDir;
                cmdIndex = ContainerInvoker.addContainerOptions(cmd, cmdIndex, options);
                cmd[cmdIndex++] = this.container.getImage();
            }
        }
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                String[] parts = this.internalFunction.split("&");
                String userModule = parts[0];
                String userFunction = parts[1];
                cmd[cmdIndex++] = "python" + pythonVersion;
                cmd[cmdIndex++] = pyCompssDir + REL_PATH_WORKER_CONTAINER;
                cmd[cmdIndex++] = userModule;
                cmd[cmdIndex++] = userFunction;
                cmd[cmdIndex++] = this.invocation.isDebugEnabled() ? "true" : "false";
                cmd[cmdIndex++] = "false";
                cmd[cmdIndex++] = String.valueOf(hasTarget);
                cmd[cmdIndex++] = returnType;
                cmd[cmdIndex++] = String.valueOf(returnLength);
                cmd[cmdIndex++] = String.valueOf(numContainerCallParams);
                break;
            }
            case CET_BINARY: {
                cmd[cmdIndex++] = this.internalBinary;
            }
        }
        for (int i = 0; i < containerCallParams.size(); ++i) {
            cmd[cmdIndex++] = containerCallParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[CONTAINER INVOKER] Begin binary call to container execution");
            outLog.println("[CONTAINER INVOKER] Engine: " + this.container.getEngine().toString());
            outLog.println("[CONTAINER INVOKER] Image: " + this.container.getImage());
            outLog.println("[CONTAINER INVOKER] Internal Type: " + (Object)((Object)this.internalExecutionType));
            outLog.println("[CONTAINER INVOKER] Internal Binary: " + this.internalBinary);
            outLog.println("[CONTAINER INVOKER] Internal Function: " + this.internalFunction);
            outLog.println("[CONTAINER INVOKER] On WorkingDir : " + workingDir);
            outLog.print("[CONTAINER INVOKER] BINARY CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[CONTAINER INVOKER] Binary STDIN: " + streamValues.getStdIn());
            outLog.println("[CONTAINER INVOKER] Binary STDOUT: " + streamValues.getStdOut());
            outLog.println("[CONTAINER INVOKER] Binary STDERR: " + streamValues.getStdErr());
        }
        String completePythonpath = pythonPath + ":" + pyCompssDir;
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.sandBox, this.context.getThreadOutStream(), this.context.getThreadErrStream(), completePythonpath, this.failByEV);
    }

    protected static int addContainerOptions(String[] cmd, int cmdIndex, String[] options) {
        if (options != null && options.length > 0) {
            for (String option : options) {
                cmd[cmdIndex++] = option;
            }
        }
        return cmdIndex;
    }

    private void addParamInfo(List<String> paramsList, InvocationParam p) {
        paramsList.addAll(ContainerInvoker.convertParameter(p));
    }

    private static ArrayList<String> convertParameter(InvocationParam np) {
        ArrayList<String> paramArgs = new ArrayList<String>();
        DataType type = np.getType();
        paramArgs.add(Integer.toString(type.ordinal()));
        paramArgs.add(Integer.toString(np.getStdIOStream().ordinal()));
        paramArgs.add(np.getPrefix());
        String name = np.getName();
        if (name == null || name.isEmpty()) {
            paramArgs.add("null");
        } else {
            paramArgs.add(name);
        }
        if (name == null || name.isEmpty()) {
            paramArgs.add("null");
        } else {
            paramArgs.add(np.getContentType());
        }
        switch (type) {
            case FILE_T: {
                String destFile;
                String originalFile = "null";
                if (np.getSourceDataId() != null) {
                    originalFile = np.getOriginalName();
                }
                if (!ContainerInvoker.isRuntimeRenamed(destFile = new File(np.getRenamedName()).getName())) {
                    destFile = originalFile;
                }
                paramArgs.add(originalFile + ":" + destFile + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                break;
            }
            case OBJECT_T: 
            case PSCO_T: 
            case STREAM_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: {
                paramArgs.add(np.getValue().toString());
                paramArgs.add(np.isWriteFinalValue() ? "W" : "R");
                break;
            }
            case BINDING_OBJECT_T: {
                String destData;
                String extObjValue = np.getValue().toString();
                LOGGER.debug("Generating command args for Binding_object " + extObjValue);
                BindingObject bo = BindingObject.generate(extObjValue);
                String originalData = "";
                if (np.getSourceDataId() != null) {
                    originalData = np.getSourceDataId();
                }
                if (!ContainerInvoker.isRuntimeRenamed(destData = bo.getName())) {
                    destData = originalData;
                }
                paramArgs.add(originalData + ":" + destData + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                paramArgs.add(Integer.toString(bo.getType()));
                paramArgs.add(Integer.toString(bo.getElements()));
                break;
            }
            case STRING_T: {
                String value = np.getValue().toString();
                String[] vals = value.split(" ");
                int numSubStrings = vals.length;
                paramArgs.add(Integer.toString(numSubStrings));
                for (String v : vals) {
                    paramArgs.add(v);
                }
                break;
            }
            case STRING_64_T: {
                byte[] decodedBytes = Base64.getDecoder().decode(np.getValue().toString());
                String[] values = new String(decodedBytes).split(" ");
                paramArgs.add(Integer.toString(values.length));
                paramArgs.addAll(Arrays.asList(values));
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                InvocationParamCollection ipc = (InvocationParamCollection)np;
                ContainerInvoker.writeCollection(ipc);
                paramArgs.add(np.getValue().toString());
                break;
            }
            default: {
                paramArgs.add(np.getValue().toString());
            }
        }
        return paramArgs;
    }

    private static void writeCollection(InvocationParamCollection<InvocationParam> ipc) {
        String pathToWrite = (String)ipc.getValue();
        LOGGER.debug("Writting Collection file " + pathToWrite + " ");
        if (new File(pathToWrite).exists()) {
            LOGGER.debug("Collection file " + pathToWrite + " already written");
        } else {
            try (PrintWriter writer = new PrintWriter(pathToWrite, "UTF-8");){
                for (InvocationParam subParam : ipc.getCollectionParameters()) {
                    int subParamType = subParam.getType().ordinal();
                    Object subParamValue = subParam.getValue();
                    String subParamContentType = subParam.getContentType();
                    writer.println(subParamType + " " + subParamValue + " " + subParamContentType);
                    if (!subParam.isCollective()) continue;
                    ContainerInvoker.writeCollection((InvocationParamCollection)subParam);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error writting collection to file", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private static boolean isRuntimeRenamed(String filename) {
        return filename.startsWith("d") && filename.endsWith(".IT");
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling binary process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

