/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.api.ApplicationRunner;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.api.impl.DoNothingApplicationMonitor;
import es.bsc.compss.checkpoint.CheckpointManager;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.ApplicationTaskMonitor;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.WallClockTimerTask;
import es.bsc.compss.types.data.info.CollectionInfo;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.params.DataOwner;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Application
implements ApplicationTaskMonitor,
DataOwner {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    private static final Random APP_ID_GENERATOR = new SecureRandom();
    private static final TreeMap<Long, Application> APPLICATIONS = new TreeMap();
    private static final ApplicationRunner DEFAULT_RUNNER = new DoNothingApplicationMonitor();
    private static final Application NO_APPLICATION = new Application(null, null, DEFAULT_RUNNER);
    private static GraphHandler GH;
    private static CheckpointManager CP;
    private static final int DEFAULT_THROTTLE_WAIT_TASK_COUNT = Integer.MAX_VALUE;
    private static final Semaphore THROTTLE;
    private final Long id;
    private final String parallelismSource;
    private TimerTask wallClockKiller;
    private final ApplicationRunner runner;
    private int totalTaskCount;
    private TreeMap<String, TaskGroup> taskGroups;
    private Stack<TaskGroup> currentTaskGroups;
    private final TreeMap<String, FileInfo> nameToData;
    private final TreeMap<Integer, DataInfo> codeToData;
    private final TreeMap<String, CollectionInfo> collectionToData;

    public static void setCP(CheckpointManager cp) {
        CP = cp;
    }

    public static void setGH(GraphHandler gh) {
        GH = gh;
    }

    public static String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Application app : APPLICATIONS.values()) {
            Long appId = app.getId();
            Integer totalTaskCount = app.totalTaskCount;
            TaskGroup appBaseGroup = (TaskGroup)app.currentTaskGroups.firstElement();
            Integer taskCount = appBaseGroup.getTasks().size();
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public static Application registerApplication(Long appId) {
        return Application.registerApplication(appId, null, null);
    }

    public static Application registerApplication(String parallelismSource, ApplicationRunner runner) {
        Long appId = APP_ID_GENERATOR.nextLong();
        while (APPLICATIONS.containsKey(appId)) {
            appId = APP_ID_GENERATOR.nextLong();
        }
        return Application.registerApplication(appId, parallelismSource, runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Application registerApplication(Long appId, String parallelismSource, ApplicationRunner runner) {
        Application app;
        if (appId == null) {
            LOGGER.error("No application id", (Throwable)new Exception("Application id is null"));
            app = NO_APPLICATION;
        } else {
            TreeMap<Long, Application> treeMap = APPLICATIONS;
            synchronized (treeMap) {
                app = APPLICATIONS.get(appId);
                if (app == null) {
                    if (runner == null) {
                        runner = DEFAULT_RUNNER;
                    }
                    app = new Application(appId, parallelismSource, runner);
                    APPLICATIONS.put(appId, app);
                }
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application deregisterApplication(Long appId) {
        Application app;
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            app = APPLICATIONS.remove(appId);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application[] getApplications() {
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            return APPLICATIONS.values().toArray(new Application[APPLICATIONS.size()]);
        }
    }

    private Application(Long appId, String parallelismSource, ApplicationRunner runner) {
        this.id = appId;
        this.parallelismSource = parallelismSource;
        this.runner = runner;
        this.totalTaskCount = 0;
        this.currentTaskGroups = new Stack();
        this.taskGroups = new TreeMap();
        this.stackTaskGroup("App" + appId);
        this.nameToData = new TreeMap();
        this.codeToData = new TreeMap();
        this.collectionToData = new TreeMap();
    }

    public Long getId() {
        return this.id;
    }

    public String getParallelismSource() {
        return this.parallelismSource;
    }

    public GraphHandler getGH() {
        return GH;
    }

    public CheckpointManager getCP() {
        return CP;
    }

    public final void openTaskGroup(String groupName) {
        this.stackTaskGroup(groupName);
        GH.openTaskGroup(groupName);
    }

    private void stackTaskGroup(String groupName) {
        LOGGER.debug("Adding group " + groupName + " to the current groups stack.");
        TaskGroup tg = new TaskGroup(groupName, this);
        this.currentTaskGroups.push(tg);
        this.taskGroups.put(groupName, tg);
    }

    public final void closeCurrentTaskGroup() {
        this.popGroup();
        GH.closeTaskGroup();
    }

    private void popGroup() {
        TaskGroup tg = this.currentTaskGroups.pop();
        tg.setClosed();
    }

    public Iterable<TaskGroup> getCurrentGroups() {
        return this.currentTaskGroups;
    }

    public TaskGroup getBaseTaskGroup() {
        return (TaskGroup)this.currentTaskGroups.firstElement();
    }

    public TaskGroup getGroup(String groupName) {
        return this.taskGroups.get(groupName);
    }

    public TaskGroup removeGroup(String name) {
        return this.taskGroups.remove(name);
    }

    @Override
    public void onTaskCreation(Task t) {
        THROTTLE.acquireUninterruptibly();
        ++this.totalTaskCount;
        this.getTaskMonitor().onCreation();
    }

    @Override
    public void onTaskAnalysisStart(Task task) {
        for (TaskGroup group : this.getCurrentGroups()) {
            task.addTaskGroup(group);
            group.addTask(task);
        }
        GH.startTaskAnalysis(task);
    }

    @Override
    public void onTaskAnalysisEnd(Task task, boolean taskHasEdge) {
        GH.endTaskAnalysis(task, taskHasEdge);
        CP.newTask(task);
    }

    @Override
    public void onCommutativeGroupCreation(CommutativeGroupTask g) {
        GH.createCommutativeGroup(g);
    }

    @Override
    public void onTaskBelongsToCommutativeGroup(Task t, CommutativeGroupTask g) {
        GH.taskBelongsToCommutativeGroup(t, g);
    }

    @Override
    public void onCommutativeGroupClosure(CommutativeGroupTask g) {
        GH.closeCommutativeGroup(g);
    }

    public void endTask(Task task) {
        THROTTLE.release();
        for (TaskGroup group : task.getTaskGroupList()) {
            group.removeTask(task);
            LOGGER.debug("Group " + group.getName() + " released task " + task.getId());
            if (group.hasPendingTasks()) continue;
            LOGGER.debug("All tasks of group " + group.getName() + " have finished execution");
            if (!group.hasBarrier()) continue;
            group.releaseBarrier();
            if (!group.isClosed()) continue;
            this.removeGroup(group.getName());
        }
    }

    public void stalled() {
        this.runner.stalledApplication();
    }

    public void readyToContinue(Semaphore sem) {
        this.runner.readyToContinue(sem);
    }

    private void reachesGroupBarrier(TaskGroup tg, Barrier request) {
        if (tg != null) {
            tg.registerBarrier(request);
        } else {
            request.release();
        }
    }

    public final void reachesGroupBarrier(String groupName, BarrierGroupRequest request) {
        TaskGroup tg = this.getGroup(groupName);
        this.reachesGroupBarrier(tg, (Barrier)request);
        GH.groupBarrier(request);
    }

    public final void reachesBarrier(Barrier barrier) {
        this.doBarrier(barrier);
        GH.barrier(this.nameToData, this.codeToData, this.collectionToData);
    }

    public final void endReached(Barrier barrier) {
        this.doBarrier(barrier);
        GH.endApp();
    }

    private void doBarrier(Barrier barrier) {
        TaskGroup baseGroup = (TaskGroup)this.currentTaskGroups.firstElement();
        this.reachesGroupBarrier(baseGroup, barrier);
    }

    @Override
    public void registerFileData(String locationKey, FileInfo di) {
        this.nameToData.put(locationKey, di);
    }

    @Override
    public FileInfo getFileData(String locationKey) {
        return this.nameToData.get(locationKey);
    }

    @Override
    public FileInfo removeFileData(String locationKey) throws ValueUnawareRuntimeException {
        FileInfo di = this.nameToData.remove(locationKey);
        this.removeData(di);
        return di;
    }

    @Override
    public void registerObjectData(int code, DataInfo di) {
        this.codeToData.put(code, di);
    }

    @Override
    public DataInfo getObjectData(int code) {
        return this.codeToData.get(code);
    }

    @Override
    public DataInfo removeObjectData(int code) throws ValueUnawareRuntimeException {
        DataInfo di = this.codeToData.remove(code);
        this.removeData(di);
        return di;
    }

    @Override
    public void registerCollectionData(String collectionId, CollectionInfo di) {
        this.collectionToData.put(collectionId, di);
    }

    @Override
    public CollectionInfo getCollectionData(String collectionId) {
        return this.collectionToData.get(collectionId);
    }

    @Override
    public CollectionInfo removeCollectionData(String collectionId) throws ValueUnawareRuntimeException {
        CollectionInfo di = this.collectionToData.remove(collectionId);
        this.removeData(di);
        return di;
    }

    private void removeData(DataInfo dataInfo) throws ValueUnawareRuntimeException {
        if (dataInfo == null) {
            throw new ValueUnawareRuntimeException();
        }
        dataInfo.delete();
    }

    public List<DataInfo> popAllData() {
        LinkedList<DataInfo> localData = new LinkedList<DataInfo>();
        localData.addAll(this.nameToData.values());
        this.nameToData.clear();
        localData.addAll(this.codeToData.values());
        this.codeToData.clear();
        localData.addAll(this.collectionToData.values());
        this.collectionToData.clear();
        return localData;
    }

    public Set<FileInfo> getWrittenFiles() {
        HashSet<FileInfo> wfiles = new HashSet<FileInfo>();
        for (DataInfo dataInfo : this.nameToData.values()) {
            if (dataInfo.getCurrentDataVersion().getDataInstanceId().getVersionId() <= 1) continue;
            wfiles.add((FileInfo)dataInfo);
        }
        return wfiles;
    }

    public void setTimerTask(WallClockTimerTask wcTimerTask) {
        this.wallClockKiller = wcTimerTask;
    }

    public void cancelTimerTask() {
        if (this.wallClockKiller != null) {
            this.wallClockKiller.cancel();
            this.wallClockKiller = null;
        }
    }

    public TaskMonitor getTaskMonitor() {
        return this.runner.getTaskMonitor();
    }

    static {
        String maxTasks = System.getenv("COMPSS_THROTTLE_MAX_TASKS");
        int throttleThreshold = maxTasks != null && !maxTasks.isEmpty() ? Integer.parseInt(maxTasks) : Integer.MAX_VALUE;
        THROTTLE = new Semaphore(throttleThreshold);
    }
}

